/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.metadata.SchemaDao;
import com.google.common.base.Throwables;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;

public final class SchemaDaoUtil {
    private static final Logger log = Logger.get(SchemaDaoUtil.class);

    private SchemaDaoUtil() {
    }

    public static void createTablesWithRetry(IDBI dbi) {
        Duration delay = new Duration(2.0, TimeUnit.SECONDS);
        while (true) {
            try (Handle handle = dbi.open();){
                SchemaDaoUtil.createTables((SchemaDao)handle.attach(SchemaDao.class));
                return;
            }
            catch (UnableToObtainConnectionException e) {
                log.warn("Failed to connect to database. Will retry again in %s. Exception: %s", new Object[]{delay, e.getMessage()});
                SchemaDaoUtil.sleep(delay);
                continue;
            }
            break;
        }
    }

    private static void createTables(SchemaDao dao) {
        dao.createTableDistributions();
        dao.createTableTables();
        dao.createTableColumns();
        dao.createTableViews();
        dao.createTableNodes();
        dao.createTableShards();
        dao.createTableShardNodes();
        dao.createTableExternalBatches();
        dao.createTableTransactions();
        dao.createTableCreatedShards();
        dao.createTableDeletedShards();
        dao.createTableBuckets();
        dao.createTableShardOrganizerJobs();
    }

    private static void sleep(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
    }
}

