/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ShardCleanerConfig {
    private Duration maxTransactionAge = new Duration(1.0, TimeUnit.DAYS);
    private Duration transactionCleanerInterval = new Duration(10.0, TimeUnit.MINUTES);
    private Duration localCleanerInterval = new Duration(1.0, TimeUnit.HOURS);
    private Duration localCleanTime = new Duration(4.0, TimeUnit.HOURS);
    private Duration backupCleanerInterval = new Duration(5.0, TimeUnit.MINUTES);
    private Duration backupCleanTime = new Duration(1.0, TimeUnit.DAYS);
    private int backupDeletionThreads = 50;
    private Duration maxCompletedTransactionAge = new Duration(1.0, TimeUnit.DAYS);

    @NotNull
    @MinDuration(value="1m")
    @MaxDuration(value="30d")
    public Duration getMaxTransactionAge() {
        return this.maxTransactionAge;
    }

    @Config(value="raptor.max-transaction-age")
    @ConfigDescription(value="Maximum time a transaction may run before it is aborted")
    public ShardCleanerConfig setMaxTransactionAge(Duration maxTransactionAge) {
        this.maxTransactionAge = maxTransactionAge;
        return this;
    }

    @NotNull
    @MinDuration(value="1m")
    public Duration getTransactionCleanerInterval() {
        return this.transactionCleanerInterval;
    }

    @Config(value="raptor.transaction-cleaner-interval")
    @ConfigDescription(value="How often to cleanup expired transactions")
    public ShardCleanerConfig setTransactionCleanerInterval(Duration transactionCleanerInterval) {
        this.transactionCleanerInterval = transactionCleanerInterval;
        return this;
    }

    @NotNull
    @MinDuration(value="1m")
    public Duration getLocalCleanerInterval() {
        return this.localCleanerInterval;
    }

    @Config(value="raptor.local-cleaner-interval")
    @ConfigDescription(value="How often to discover local shards that need to be cleaned up")
    public ShardCleanerConfig setLocalCleanerInterval(Duration localCleanerInterval) {
        this.localCleanerInterval = localCleanerInterval;
        return this;
    }

    @NotNull
    public Duration getLocalCleanTime() {
        return this.localCleanTime;
    }

    @Config(value="raptor.local-clean-time")
    @ConfigDescription(value="How long to wait after discovery before cleaning local shards")
    public ShardCleanerConfig setLocalCleanTime(Duration localCleanTime) {
        this.localCleanTime = localCleanTime;
        return this;
    }

    @NotNull
    @MinDuration(value="1m")
    public Duration getBackupCleanerInterval() {
        return this.backupCleanerInterval;
    }

    @Config(value="raptor.backup-cleaner-interval")
    @ConfigDescription(value="How often to check for backup shards that need to be cleaned up")
    public ShardCleanerConfig setBackupCleanerInterval(Duration backupCleanerInterval) {
        this.backupCleanerInterval = backupCleanerInterval;
        return this;
    }

    @NotNull
    public Duration getBackupCleanTime() {
        return this.backupCleanTime;
    }

    @Config(value="raptor.backup-clean-time")
    @ConfigDescription(value="How long to wait after deletion before cleaning backup shards")
    public ShardCleanerConfig setBackupCleanTime(Duration backupCleanTime) {
        this.backupCleanTime = backupCleanTime;
        return this;
    }

    @Min(value=1L)
    public int getBackupDeletionThreads() {
        return this.backupDeletionThreads;
    }

    @Config(value="raptor.backup-deletion-threads")
    @ConfigDescription(value="Maximum number of threads to use for deleting shards from backup store")
    public ShardCleanerConfig setBackupDeletionThreads(int backupDeletionThreads) {
        this.backupDeletionThreads = backupDeletionThreads;
        return this;
    }

    @NotNull
    @MinDuration(value="1m")
    @MaxDuration(value="30d")
    public Duration getMaxCompletedTransactionAge() {
        return this.maxCompletedTransactionAge;
    }

    @Config(value="raptor.max-completed-transaction-age")
    @ConfigDescription(value="Maximum time a record of a successful or failed transaction is kept")
    public ShardCleanerConfig setMaxCompletedTransactionAge(Duration maxCompletedTransactionAge) {
        this.maxCompletedTransactionAge = maxCompletedTransactionAge;
        return this;
    }
}

