/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.util.DatabaseUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TableMetadataRow {
    private final long tableId;
    private final String schemaName;
    private final String tableName;
    private final OptionalLong temporalColumnId;
    private final Optional<String> distributionName;
    private final OptionalInt bucketCount;
    private final boolean organized;

    public TableMetadataRow(long tableId, String schemaName, String tableName, OptionalLong temporalColumnId, Optional<String> distributionName, OptionalInt bucketCount, boolean organized) {
        this.tableId = tableId;
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.temporalColumnId = Objects.requireNonNull(temporalColumnId, "temporalColumnId is null");
        this.distributionName = Objects.requireNonNull(distributionName, "distributionName is null");
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        this.organized = organized;
    }

    public long getTableId() {
        return this.tableId;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public OptionalLong getTemporalColumnId() {
        return this.temporalColumnId;
    }

    public Optional<String> getDistributionName() {
        return this.distributionName;
    }

    public OptionalInt getBucketCount() {
        return this.bucketCount;
    }

    public boolean isOrganized() {
        return this.organized;
    }

    public static class Mapper
    implements ResultSetMapper<TableMetadataRow> {
        public TableMetadataRow map(int index, ResultSet rs, StatementContext context) throws SQLException {
            return new TableMetadataRow(rs.getLong("table_id"), rs.getString("schema_name"), rs.getString("table_name"), DatabaseUtil.getOptionalLong(rs, "temporal_column_id"), Optional.ofNullable(rs.getString("distribution_name")), DatabaseUtil.getOptionalInt(rs, "bucket_count"), rs.getBoolean("organization_enabled"));
        }
    }
}

