/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcRecordReader;
import com.facebook.presto.orc.memory.AggregatedMemoryContext;
import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.storage.ShardRewriter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.predicate.Utils;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class OrcPageSource
implements UpdatablePageSource {
    public static final int NULL_COLUMN = -1;
    public static final int ROWID_COLUMN = -2;
    public static final int SHARD_UUID_COLUMN = -3;
    public static final int BUCKET_NUMBER_COLUMN = -4;
    private final Optional<ShardRewriter> shardRewriter;
    private final OrcRecordReader recordReader;
    private final OrcDataSource orcDataSource;
    private final BitSet rowsToDelete;
    private final List<Long> columnIds;
    private final List<Type> types;
    private final Block[] constantBlocks;
    private final int[] columnIndexes;
    private final AggregatedMemoryContext systemMemoryContext;
    private int batchId;
    private boolean closed;

    public OrcPageSource(Optional<ShardRewriter> shardRewriter, OrcRecordReader recordReader, OrcDataSource orcDataSource, List<Long> columnIds, List<Type> columnTypes, List<Integer> columnIndexes, UUID shardUuid, OptionalInt bucketNumber, AggregatedMemoryContext systemMemoryContext) {
        this.shardRewriter = Objects.requireNonNull(shardRewriter, "shardRewriter is null");
        this.recordReader = Objects.requireNonNull(recordReader, "recordReader is null");
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        this.rowsToDelete = new BitSet(Math.toIntExact(recordReader.getFileRowCount()));
        Preconditions.checkArgument((columnIds.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"ids and types mismatch");
        Preconditions.checkArgument((columnIds.size() == columnIndexes.size() ? 1 : 0) != 0, (Object)"ids and indexes mismatch");
        int size = columnIds.size();
        this.columnIds = ImmutableList.copyOf(columnIds);
        this.types = ImmutableList.copyOf(columnTypes);
        this.constantBlocks = new Block[size];
        this.columnIndexes = new int[size];
        Objects.requireNonNull(shardUuid, "shardUuid is null");
        for (int i = 0; i < size; ++i) {
            this.columnIndexes[i] = columnIndexes.get(i);
            if (this.columnIndexes[i] == -1) {
                this.constantBlocks[i] = OrcPageSource.buildSingleValueBlock(columnTypes.get(i), null);
                continue;
            }
            if (this.columnIndexes[i] == -3) {
                this.constantBlocks[i] = OrcPageSource.buildSingleValueBlock(columnTypes.get(i), Slices.utf8Slice((String)shardUuid.toString()));
                continue;
            }
            if (this.columnIndexes[i] != -4) continue;
            this.constantBlocks[i] = bucketNumber.isPresent() ? OrcPageSource.buildSingleValueBlock(columnTypes.get(i), bucketNumber.getAsInt()) : OrcPageSource.buildSingleValueBlock(columnTypes.get(i), null);
        }
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    public long getTotalBytes() {
        return this.recordReader.getSplitLength();
    }

    public long getCompletedBytes() {
        return this.orcDataSource.getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.orcDataSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        try {
            ++this.batchId;
            int batchSize = this.recordReader.nextBatch();
            if (batchSize <= 0) {
                this.close();
                return null;
            }
            long filePosition = this.recordReader.getFilePosition();
            Block[] blocks = new Block[this.columnIndexes.length];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                Type type = this.types.get(fieldId);
                blocks[fieldId] = this.constantBlocks[fieldId] != null ? this.constantBlocks[fieldId].getRegion(0, batchSize) : (this.columnIndexes[fieldId] == -2 ? OrcPageSource.buildSequenceBlock(filePosition, batchSize) : new LazyBlock(batchSize, (LazyBlockLoader)new OrcBlockLoader(this.columnIndexes[fieldId], type)));
            }
            return new Page(batchSize, blocks);
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        this.closed = true;
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, (Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnNames", this.columnIds).add("types", this.types).toString();
    }

    public void deleteRows(Block rowIds) {
        for (int i = 0; i < rowIds.getPositionCount(); ++i) {
            long rowId = BigintType.BIGINT.getLong(rowIds, i);
            this.rowsToDelete.set(Math.toIntExact(rowId));
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        Preconditions.checkState((boolean)this.shardRewriter.isPresent(), (Object)"shardRewriter is missing");
        return this.shardRewriter.get().rewrite(this.rowsToDelete);
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryContext.getBytes();
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private static Block buildSequenceBlock(long start, int count) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(count);
        for (int i = 0; i < count; ++i) {
            BigintType.BIGINT.writeLong(builder, start + (long)i);
        }
        return builder.build();
    }

    private static Block buildSingleValueBlock(Type type, Object value) {
        Block block = Utils.nativeValueToBlock((Type)type, (Object)value);
        return new RunLengthEncodedBlock(block, 1024);
    }

    private final class OrcBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final int columnIndex;
        private final Type type;
        private boolean loaded;

        public OrcBlockLoader(int columnIndex, Type type) {
            this.expectedBatchId = OrcPageSource.this.batchId;
            this.columnIndex = columnIndex;
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState((OrcPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                Block block = OrcPageSource.this.recordReader.readBlock(this.type, this.columnIndex);
                lazyBlock.setBlock(block);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

