/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.raptor.util.Types;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.common.type.HiveDecimal;

public class Row {
    private final List<Object> columns;
    private final int sizeInBytes;

    public Row(List<Object> columns, int sizeInBytes) {
        this.columns = Objects.requireNonNull(columns, "columns is null");
        Preconditions.checkArgument((sizeInBytes >= 0 ? 1 : 0) != 0, (Object)"sizeInBytes must be >= 0");
        this.sizeInBytes = sizeInBytes;
    }

    public List<Object> getColumns() {
        return this.columns;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public static Row extractRow(Page page, int position, List<Type> types) {
        Preconditions.checkArgument((page.getChannelCount() == types.size() ? 1 : 0) != 0, (Object)"channelCount does not match");
        Preconditions.checkArgument((position < page.getPositionCount() ? 1 : 0) != 0, (String)"Requested position %s from a page with positionCount %s ", (int)position, (int)page.getPositionCount());
        RowBuilder rowBuilder = new RowBuilder(page.getChannelCount());
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            int size;
            Block block = page.getBlock(channel);
            Type type = types.get(channel);
            Object value = Row.getNativeContainerValue(type, block, position);
            if (value == null) {
                size = 1;
            } else if (type.getJavaType() == Boolean.TYPE) {
                size = 1;
            } else if (type.getJavaType() == Long.TYPE) {
                size = 8;
            } else if (type.getJavaType() == Double.TYPE) {
                size = 8;
            } else if (type.getJavaType() == Slice.class) {
                size = ((Slice)value).length();
            } else if (type.getJavaType() == Block.class) {
                size = ((Block)value).getSizeInBytes();
            } else {
                throw new AssertionError((Object)("Unimplemented type: " + type));
            }
            rowBuilder.add(Row.nativeContainerToOrcValue(type, value), size);
        }
        Row row = rowBuilder.build();
        Verify.verify((row.getColumns().size() == types.size() ? 1 : 0) != 0, (String)"Column count in row: %s Expected column count: %s", (Object[])new Object[]{row.getColumns().size(), types.size()});
        return row;
    }

    private static Object getNativeContainerValue(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (type.getJavaType() == Boolean.TYPE) {
            return type.getBoolean(block, position);
        }
        if (type.getJavaType() == Long.TYPE) {
            return type.getLong(block, position);
        }
        if (type.getJavaType() == Double.TYPE) {
            return type.getDouble(block, position);
        }
        if (type.getJavaType() == Slice.class) {
            return type.getSlice(block, position);
        }
        if (type.getJavaType() == Block.class) {
            return type.getObject(block, position);
        }
        throw new AssertionError((Object)("Unimplemented type: " + type));
    }

    private static Object nativeContainerToOrcValue(Type type, Object nativeValue) {
        if (nativeValue == null) {
            return null;
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            BigInteger unscaledValue = decimalType.isShort() ? BigInteger.valueOf((Long)nativeValue) : Decimals.decodeUnscaledValue((Slice)((Slice)nativeValue));
            return HiveDecimal.create((BigInteger)unscaledValue, (int)decimalType.getScale());
        }
        if (type.getJavaType() == Boolean.TYPE) {
            return nativeValue;
        }
        if (type.getJavaType() == Long.TYPE) {
            return nativeValue;
        }
        if (type.getJavaType() == Double.TYPE) {
            return nativeValue;
        }
        if (type.getJavaType() == Slice.class) {
            Slice slice = (Slice)nativeValue;
            return type instanceof VarcharType ? slice.toStringUtf8() : (Object)slice.getBytes();
        }
        if (Types.isArrayType(type)) {
            Block arrayBlock = (Block)nativeValue;
            Type elementType = (Type)type.getTypeParameters().get(0);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                list.add(Row.nativeContainerToOrcValue(elementType, Row.getNativeContainerValue(elementType, arrayBlock, i)));
            }
            return list;
        }
        if (Types.isMapType(type)) {
            Block mapBlock = (Block)nativeValue;
            Type keyType = (Type)type.getTypeParameters().get(0);
            Type valueType = (Type)type.getTypeParameters().get(1);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                Object key = Row.nativeContainerToOrcValue(keyType, Row.getNativeContainerValue(keyType, mapBlock, i));
                Object value = Row.nativeContainerToOrcValue(valueType, Row.getNativeContainerValue(valueType, mapBlock, i + 1));
                map.put(key, value);
            }
            return map;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unimplemented type: " + type);
    }

    private static class RowBuilder {
        private int rowSize;
        private final List<Object> columns;

        public RowBuilder(int columnCount) {
            this.columns = new ArrayList<Object>(columnCount);
        }

        public void add(Object value, int size) {
            this.columns.add(value);
            this.rowSize += size;
        }

        public Row build() {
            return new Row(this.columns, this.rowSize);
        }
    }
}

