/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.raptor.backup.BackupManager;
import com.facebook.presto.raptor.metadata.AssignmentLimiter;
import com.facebook.presto.raptor.metadata.DatabaseShardManager;
import com.facebook.presto.raptor.metadata.DatabaseShardRecorder;
import com.facebook.presto.raptor.metadata.MetadataConfig;
import com.facebook.presto.raptor.metadata.ShardCleaner;
import com.facebook.presto.raptor.metadata.ShardCleanerConfig;
import com.facebook.presto.raptor.metadata.ShardManager;
import com.facebook.presto.raptor.metadata.ShardRecorder;
import com.facebook.presto.raptor.storage.BucketBalancer;
import com.facebook.presto.raptor.storage.BucketBalancerConfig;
import com.facebook.presto.raptor.storage.FileStorageService;
import com.facebook.presto.raptor.storage.OrcStorageManager;
import com.facebook.presto.raptor.storage.ReaderAttributes;
import com.facebook.presto.raptor.storage.ShardEjector;
import com.facebook.presto.raptor.storage.ShardRecoveryManager;
import com.facebook.presto.raptor.storage.StorageManager;
import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.facebook.presto.raptor.storage.StorageService;
import com.facebook.presto.raptor.storage.organization.JobFactory;
import com.facebook.presto.raptor.storage.organization.OrganizationJobFactory;
import com.facebook.presto.raptor.storage.organization.ShardCompactionManager;
import com.facebook.presto.raptor.storage.organization.ShardCompactor;
import com.facebook.presto.raptor.storage.organization.ShardOrganizationManager;
import com.facebook.presto.raptor.storage.organization.ShardOrganizer;
import com.google.common.base.Ticker;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import java.util.Objects;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class StorageModule
implements Module {
    private final String connectorId;

    public StorageModule(String connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(StorageManagerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(BucketBalancerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ShardCleanerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MetadataConfig.class);
        binder.bind(Ticker.class).toInstance((Object)Ticker.systemTicker());
        binder.bind(StorageManager.class).to(OrcStorageManager.class).in(Scopes.SINGLETON);
        binder.bind(StorageService.class).to(FileStorageService.class).in(Scopes.SINGLETON);
        binder.bind(ShardManager.class).to(DatabaseShardManager.class).in(Scopes.SINGLETON);
        binder.bind(ShardRecorder.class).to(DatabaseShardRecorder.class).in(Scopes.SINGLETON);
        binder.bind(DatabaseShardManager.class).in(Scopes.SINGLETON);
        binder.bind(DatabaseShardRecorder.class).in(Scopes.SINGLETON);
        binder.bind(ShardRecoveryManager.class).in(Scopes.SINGLETON);
        binder.bind(BackupManager.class).in(Scopes.SINGLETON);
        binder.bind(ShardCompactionManager.class).in(Scopes.SINGLETON);
        binder.bind(ShardOrganizationManager.class).in(Scopes.SINGLETON);
        binder.bind(ShardOrganizer.class).in(Scopes.SINGLETON);
        binder.bind(JobFactory.class).to(OrganizationJobFactory.class).in(Scopes.SINGLETON);
        binder.bind(ShardCompactor.class).in(Scopes.SINGLETON);
        binder.bind(ShardEjector.class).in(Scopes.SINGLETON);
        binder.bind(ShardCleaner.class).in(Scopes.SINGLETON);
        binder.bind(BucketBalancer.class).in(Scopes.SINGLETON);
        binder.bind(ReaderAttributes.class).in(Scopes.SINGLETON);
        binder.bind(AssignmentLimiter.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ShardRecoveryManager.class).as(ObjectNames.generatedNameOf(ShardRecoveryManager.class, (String)this.connectorId));
        ExportBinder.newExporter((Binder)binder).export(BackupManager.class).as(ObjectNames.generatedNameOf(BackupManager.class, (String)this.connectorId));
        ExportBinder.newExporter((Binder)binder).export(StorageManager.class).as(ObjectNames.generatedNameOf(OrcStorageManager.class, (String)this.connectorId));
        ExportBinder.newExporter((Binder)binder).export(ShardCompactionManager.class).as(ObjectNames.generatedNameOf(ShardCompactionManager.class, (String)this.connectorId));
        ExportBinder.newExporter((Binder)binder).export(ShardOrganizer.class).as(ObjectNames.generatedNameOf(ShardOrganizer.class, (String)this.connectorId));
        ExportBinder.newExporter((Binder)binder).export(ShardCompactor.class).as(ObjectNames.generatedNameOf(ShardCompactor.class, (String)this.connectorId));
        ExportBinder.newExporter((Binder)binder).export(ShardEjector.class).as(ObjectNames.generatedNameOf(ShardEjector.class, (String)this.connectorId));
        ExportBinder.newExporter((Binder)binder).export(ShardCleaner.class).as(ObjectNames.generatedNameOf(ShardCleaner.class, (String)this.connectorId));
        ExportBinder.newExporter((Binder)binder).export(BucketBalancer.class).as(ObjectNames.generatedNameOf(BucketBalancer.class, (String)this.connectorId));
        ExportBinder.newExporter((Binder)binder).export(JobFactory.class).withGeneratedName();
    }
}

