/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage.organization;

import com.facebook.presto.raptor.metadata.ColumnInfo;
import com.facebook.presto.raptor.metadata.MetadataDao;
import com.facebook.presto.raptor.metadata.ShardInfo;
import com.facebook.presto.raptor.metadata.ShardManager;
import com.facebook.presto.raptor.metadata.TableColumn;
import com.facebook.presto.raptor.metadata.TableMetadata;
import com.facebook.presto.raptor.storage.organization.OrganizationSet;
import com.facebook.presto.raptor.storage.organization.ShardCompactor;
import com.facebook.presto.spi.block.SortOrder;
import com.google.common.base.Throwables;
import io.airlift.log.Logger;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

class OrganizationJob
implements Runnable {
    private static final Logger log = Logger.get(OrganizationJob.class);
    private final MetadataDao metadataDao;
    private final ShardManager shardManager;
    private final ShardCompactor compactor;
    private final OrganizationSet organizationSet;

    public OrganizationJob(OrganizationSet organizationSet, MetadataDao metadataDao, ShardManager shardManager, ShardCompactor compactor) {
        this.metadataDao = Objects.requireNonNull(metadataDao, "metadataDao is null");
        this.shardManager = Objects.requireNonNull(shardManager, "shardManager is null");
        this.compactor = Objects.requireNonNull(compactor, "compactor is null");
        this.organizationSet = Objects.requireNonNull(organizationSet, "organizationSet is null");
    }

    @Override
    public void run() {
        try {
            this.runJob(this.organizationSet.getTableId(), this.organizationSet.getBucketNumber(), this.organizationSet.getShards());
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void runJob(long tableId, OptionalInt bucketNumber, Set<UUID> shardUuids) throws IOException {
        long transactionId = this.shardManager.beginTransaction();
        try {
            this.runJob(transactionId, bucketNumber, tableId, shardUuids);
        }
        catch (Throwable e) {
            this.shardManager.rollbackTransaction(transactionId);
            throw e;
        }
    }

    private void runJob(long transactionId, OptionalInt bucketNumber, long tableId, Set<UUID> shardUuids) throws IOException {
        TableMetadata metadata = this.getTableMetadata(tableId);
        List<ShardInfo> newShards = this.performCompaction(transactionId, bucketNumber, shardUuids, metadata);
        log.info("Compacted shards %s into %s", new Object[]{shardUuids, newShards.stream().map(ShardInfo::getShardUuid).collect(Collectors.toList())});
        this.shardManager.replaceShardUuids(transactionId, tableId, metadata.getColumns(), shardUuids, newShards, OptionalLong.empty());
    }

    private TableMetadata getTableMetadata(long tableId) {
        List<TableColumn> sortColumns = this.metadataDao.listSortColumns(tableId);
        List<Long> sortColumnIds = sortColumns.stream().map(TableColumn::getColumnId).collect(Collectors.toList());
        List<ColumnInfo> columns = this.metadataDao.listTableColumns(tableId).stream().map(TableColumn::toColumnInfo).collect(Collectors.toList());
        return new TableMetadata(tableId, columns, sortColumnIds);
    }

    private List<ShardInfo> performCompaction(long transactionId, OptionalInt bucketNumber, Set<UUID> shardUuids, TableMetadata tableMetadata) throws IOException {
        if (tableMetadata.getSortColumnIds().isEmpty()) {
            return this.compactor.compact(transactionId, bucketNumber, shardUuids, tableMetadata.getColumns());
        }
        return this.compactor.compactSorted(transactionId, bucketNumber, shardUuids, tableMetadata.getColumns(), tableMetadata.getSortColumnIds(), Collections.nCopies(tableMetadata.getSortColumnIds().size(), SortOrder.ASC_NULLS_FIRST));
    }
}

