/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage.organization;

import com.facebook.presto.raptor.metadata.ForMetadata;
import com.facebook.presto.raptor.metadata.MetadataDao;
import com.facebook.presto.raptor.metadata.ShardManager;
import com.facebook.presto.raptor.metadata.ShardMetadata;
import com.facebook.presto.raptor.metadata.Table;
import com.facebook.presto.raptor.metadata.TableColumn;
import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.facebook.presto.raptor.storage.organization.CompactionSetCreator;
import com.facebook.presto.raptor.storage.organization.OrganizationSet;
import com.facebook.presto.raptor.storage.organization.ShardIndexInfo;
import com.facebook.presto.raptor.storage.organization.ShardOrganizer;
import com.facebook.presto.raptor.storage.organization.ShardOrganizerUtil;
import com.facebook.presto.raptor.util.DatabaseUtil;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.skife.jdbi.v2.IDBI;

public class ShardCompactionManager {
    private static final Logger log = Logger.get(ShardCompactionManager.class);
    private static final double FILL_FACTOR = 0.75;
    private final ScheduledExecutorService compactionDiscoveryService = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"shard-compaction-discovery"));
    private final AtomicBoolean discoveryStarted = new AtomicBoolean();
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final MetadataDao metadataDao;
    private final ShardOrganizer organizer;
    private final ShardManager shardManager;
    private final String currentNodeIdentifier;
    private final CompactionSetCreator compactionSetCreator;
    private final boolean compactionEnabled;
    private final Duration compactionDiscoveryInterval;
    private final DataSize maxShardSize;
    private final long maxShardRows;
    private final IDBI dbi;

    @Inject
    public ShardCompactionManager(@ForMetadata IDBI dbi, NodeManager nodeManager, ShardManager shardManager, ShardOrganizer organizer, StorageManagerConfig config) {
        this(dbi, nodeManager.getCurrentNode().getNodeIdentifier(), shardManager, organizer, config.getCompactionInterval(), config.getMaxShardSize(), config.getMaxShardRows(), config.isCompactionEnabled());
    }

    public ShardCompactionManager(IDBI dbi, String currentNodeIdentifier, ShardManager shardManager, ShardOrganizer organizer, Duration compactionDiscoveryInterval, DataSize maxShardSize, long maxShardRows, boolean compactionEnabled) {
        this.dbi = Objects.requireNonNull(dbi, "dbi is null");
        this.metadataDao = DatabaseUtil.onDemandDao(dbi, MetadataDao.class);
        this.currentNodeIdentifier = Objects.requireNonNull(currentNodeIdentifier, "currentNodeIdentifier is null");
        this.shardManager = Objects.requireNonNull(shardManager, "shardManager is null");
        this.organizer = Objects.requireNonNull(organizer, "organizer is null");
        this.compactionDiscoveryInterval = Objects.requireNonNull(compactionDiscoveryInterval, "compactionDiscoveryInterval is null");
        Preconditions.checkArgument((maxShardSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxShardSize must be > 0");
        this.maxShardSize = Objects.requireNonNull(maxShardSize, "maxShardSize is null");
        Preconditions.checkArgument((maxShardRows > 0L ? 1 : 0) != 0, (Object)"maxShardRows must be > 0");
        this.maxShardRows = maxShardRows;
        this.compactionEnabled = compactionEnabled;
        this.compactionSetCreator = new CompactionSetCreator(maxShardSize, maxShardRows);
    }

    @PostConstruct
    public void start() {
        if (!this.compactionEnabled) {
            return;
        }
        if (!this.discoveryStarted.getAndSet(true)) {
            this.startDiscovery();
        }
    }

    @PreDestroy
    public void shutdown() {
        if (!this.compactionEnabled) {
            return;
        }
        this.shutdown.set(true);
        this.compactionDiscoveryService.shutdown();
    }

    private void startDiscovery() {
        this.compactionDiscoveryService.scheduleWithFixedDelay(() -> {
            try {
                long interval = (long)this.compactionDiscoveryInterval.convertTo(TimeUnit.SECONDS).getValue();
                TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextLong(1L, interval));
                this.discoverShards();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                log.error(t, "Error discovering shards to compact");
            }
        }, 0L, this.compactionDiscoveryInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void discoverShards() {
        log.info("Discovering shards that need compaction...");
        Set<ShardMetadata> allShards = this.shardManager.getNodeShards(this.currentNodeIdentifier);
        ImmutableListMultimap tableShards = Multimaps.index(allShards, ShardMetadata::getTableId);
        for (Map.Entry entry : Multimaps.asMap((ListMultimap)tableShards).entrySet()) {
            long tableId = (Long)entry.getKey();
            if (!this.metadataDao.isCompactionEligible(tableId)) continue;
            List shards = (List)entry.getValue();
            Collection<OrganizationSet> organizationSets = this.filterAndCreateCompactionSets(tableId, shards);
            log.info("Created %s organization set(s) for table ID %s", new Object[]{organizationSets.size(), tableId});
            for (OrganizationSet set : organizationSets) {
                this.organizer.enqueue(set);
            }
        }
    }

    private Collection<OrganizationSet> filterAndCreateCompactionSets(long tableId, Collection<ShardMetadata> tableShards) {
        TableColumn tableColumn;
        Table tableInfo = this.metadataDao.getTableInformation(tableId);
        OptionalLong temporalColumnId = tableInfo.getTemporalColumnId();
        if (temporalColumnId.isPresent() && !ShardCompactionManager.isValidTemporalColumn(tableId, (tableColumn = this.metadataDao.getTableColumn(tableId, temporalColumnId.getAsLong())).getDataType())) {
            return ImmutableSet.of();
        }
        Set<ShardMetadata> filteredShards = tableShards.stream().filter(this::needsCompaction).filter(shard -> !this.organizer.inProgress(shard.getShardUuid())).collect(Collectors.toSet());
        Collection<ShardIndexInfo> shardIndexInfos = ShardOrganizerUtil.getOrganizationEligibleShards(this.dbi, this.metadataDao, tableInfo, filteredShards, false);
        if (tableInfo.getTemporalColumnId().isPresent()) {
            Set<ShardIndexInfo> temporalShards = shardIndexInfos.stream().filter(shard -> shard.getTemporalRange().isPresent()).collect(Collectors.toSet());
            return this.compactionSetCreator.createCompactionSets(tableInfo, temporalShards);
        }
        return this.compactionSetCreator.createCompactionSets(tableInfo, shardIndexInfos);
    }

    private static boolean isValidTemporalColumn(long tableId, Type type) {
        if (!type.equals(DateType.DATE) && !type.equals(TimestampType.TIMESTAMP)) {
            log.warn("Temporal column type of table ID %s set incorrectly to %s", new Object[]{tableId, type});
            return false;
        }
        return true;
    }

    private boolean needsCompaction(ShardMetadata shard) {
        if ((double)shard.getUncompressedSize() < 0.75 * (double)this.maxShardSize.toBytes()) {
            return true;
        }
        return (double)shard.getRowCount() < 0.75 * (double)this.maxShardRows;
    }
}

