/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.util;

import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Throwables;
import com.google.common.reflect.Reflection;
import com.mysql.jdbc.Statement;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Consumer;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.exceptions.DBIException;

public final class DatabaseUtil {
    private DatabaseUtil() {
    }

    public static <T> T onDemandDao(IDBI dbi, Class<T> daoType) {
        Objects.requireNonNull(dbi, "dbi is null");
        return (T)Reflection.newProxy(daoType, (proxy, method, args) -> {
            try (Handle handle = dbi.open();){
                Object dao = handle.attach(daoType);
                Object object = method.invoke(dao, args);
                return object;
            }
            catch (DBIException e) {
                throw DatabaseUtil.metadataError(e);
            }
            catch (InvocationTargetException e) {
                throw DatabaseUtil.metadataError(e.getCause());
            }
        });
    }

    public static <T> T runTransaction(IDBI dbi, TransactionCallback<T> callback) {
        try {
            return (T)dbi.inTransaction(callback);
        }
        catch (DBIException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw DatabaseUtil.metadataError(e);
        }
    }

    public static <T> void daoTransaction(IDBI dbi, Class<T> daoType, Consumer<T> callback) {
        DatabaseUtil.runTransaction(dbi, (handle, status) -> {
            callback.accept(handle.attach(daoType));
            return null;
        });
    }

    public static PrestoException metadataError(Throwable cause) {
        return new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_METADATA_ERROR, "Failed to perform metadata operation", cause);
    }

    public static void runIgnoringConstraintViolation(Runnable task) {
        block2: {
            try {
                task.run();
            }
            catch (RuntimeException e) {
                if (DatabaseUtil.sqlCodeStartsWith(e, "23")) break block2;
                throw e;
            }
        }
    }

    public static void enableStreamingResults(java.sql.Statement statement) throws SQLException {
        if (statement.isWrapperFor(Statement.class)) {
            statement.unwrap(Statement.class).enableStreamingResults();
        }
    }

    public static OptionalInt getOptionalInt(ResultSet rs, String name) throws SQLException {
        int value = rs.getInt(name);
        return rs.wasNull() ? OptionalInt.empty() : OptionalInt.of(value);
    }

    public static OptionalLong getOptionalLong(ResultSet rs, String name) throws SQLException {
        long value = rs.getLong(name);
        return rs.wasNull() ? OptionalLong.empty() : OptionalLong.of(value);
    }

    public static void bindOptionalInt(PreparedStatement statement, int index, OptionalInt value) throws SQLException {
        if (value.isPresent()) {
            statement.setInt(index, value.getAsInt());
        } else {
            statement.setNull(index, 4);
        }
    }

    public static boolean isSyntaxOrAccessError(Exception e) {
        return DatabaseUtil.sqlCodeStartsWith(e, "42");
    }

    private static boolean sqlCodeStartsWith(Exception e, String code) {
        for (Throwable throwable : Throwables.getCausalChain((Throwable)e)) {
            String state;
            if (!(throwable instanceof SQLException) || (state = ((SQLException)throwable).getSQLState()) == null || !state.startsWith(code)) continue;
            return true;
        }
        return false;
    }
}

