/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HivePassThroughRecordWriter;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;

public class HivePassThroughOutputFormat<K, V>
implements HiveOutputFormat<K, V> {
    private final OutputFormat<?, ?> actualOutputFormat;

    public HivePassThroughOutputFormat(OutputFormat<?, ?> outputFormat) {
        this.actualOutputFormat = outputFormat;
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        this.actualOutputFormat.checkOutputSpecs(ignored, job);
    }

    public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        return this.actualOutputFormat.getRecordWriter(ignored, job, name, progress);
    }

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        if (this.actualOutputFormat instanceof HiveOutputFormat) {
            return ((HiveOutputFormat)this.actualOutputFormat).getHiveRecordWriter(jc, finalOutPath, valueClass, isCompressed, tableProperties, progress);
        }
        FileSystem fs = finalOutPath.getFileSystem((Configuration)jc);
        RecordWriter recordWriter = this.actualOutputFormat.getRecordWriter(fs, jc, null, progress);
        return new HivePassThroughRecordWriter(recordWriter);
    }
}

