/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr.zookeeper;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.util.ZooKeeperHiveHelper;

public class CuratorFrameworkSingleton {
    private static HiveConf conf = null;
    private static CuratorFramework sharedClient = null;
    static final Log LOG = LogFactory.getLog("CuratorFrameworkSingleton");

    public static synchronized CuratorFramework getInstance(HiveConf hiveConf) {
        if (sharedClient == null) {
            conf = hiveConf == null ? new HiveConf() : hiveConf;
            int sessionTimeout = (int)conf.getTimeVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT, TimeUnit.MILLISECONDS);
            int baseSleepTime = (int)conf.getTimeVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_BASESLEEPTIME, TimeUnit.MILLISECONDS);
            int maxRetries = conf.getIntVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_MAX_RETRIES);
            String quorumServers = ZooKeeperHiveHelper.getQuorumServers(conf);
            sharedClient = CuratorFrameworkFactory.builder().connectString(quorumServers).sessionTimeoutMs(sessionTimeout).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(baseSleepTime, maxRetries)).build();
            sharedClient.start();
        }
        return sharedClient;
    }

    public static synchronized void closeAndReleaseInstance() {
        if (sharedClient != null) {
            sharedClient.close();
            sharedClient = null;
            String shutdownMsg = "Closing ZooKeeper client.";
            LOG.info(shutdownMsg);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CuratorFrameworkSingleton.closeAndReleaseInstance();
            }
        });
    }
}

