/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.common;

import com.facebook.presto.hive.$internal.com.google.common.cache.Cache;
import com.facebook.presto.hive.$internal.com.google.common.cache.CacheBuilder;
import com.facebook.presto.hive.$internal.com.google.common.cache.RemovalListener;
import com.facebook.presto.hive.$internal.com.google.common.cache.RemovalNotification;
import com.facebook.presto.hive.$internal.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.facebook.presto.hive.$internal.org.apache.commons.lang.builder.EqualsBuilder;
import com.facebook.presto.hive.$internal.org.apache.commons.lang.builder.HashCodeBuilder;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;

class HiveClientCache {
    public static final int DEFAULT_HIVE_CACHE_EXPIRY_TIME_SECONDS = 120;
    private final Cache<HiveClientCacheKey, ICacheableMetaStoreClient> hiveCache;
    private static final Logger LOG = LoggerFactory.getLogger(HiveClientCache.class);
    private final int timeout;
    private final Object CACHE_TEARDOWN_LOCK = new Object();
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private final ScheduledFuture<?> cleanupHandle;
    private static final ThreadLocal<Integer> threadId = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return nextId.getAndIncrement();
        }
    };

    private int getThreadId() {
        return threadId.get();
    }

    public static IMetaStoreClient getNonCachedHiveMetastoreClient(HiveConf hiveConf) throws MetaException {
        return RetryingMetaStoreClient.getProxy(hiveConf);
    }

    public HiveClientCache(HiveConf hiveConf) {
        this(hiveConf.getInt("hcatalog.hive.client.cache.expiry.time", 120));
    }

    public HiveClientCache(int timeout) {
        this.timeout = timeout;
        RemovalListener<HiveClientCacheKey, ICacheableMetaStoreClient> removalListener = new RemovalListener<HiveClientCacheKey, ICacheableMetaStoreClient>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoval(RemovalNotification<HiveClientCacheKey, ICacheableMetaStoreClient> notification) {
                ICacheableMetaStoreClient hiveMetaStoreClient = notification.getValue();
                if (hiveMetaStoreClient != null) {
                    Object object = HiveClientCache.this.CACHE_TEARDOWN_LOCK;
                    synchronized (object) {
                        hiveMetaStoreClient.setExpiredFromCache();
                        hiveMetaStoreClient.tearDownIfUnused();
                    }
                }
            }
        };
        this.hiveCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, TimeUnit.SECONDS).removalListener(removalListener).build();
        Runnable cleanupThread = new Runnable(){

            @Override
            public void run() {
                HiveClientCache.this.hiveCache.cleanUp();
            }
        };
        long cleanupInterval = 120L;
        if ((long)timeout > cleanupInterval) {
            cleanupInterval = timeout;
        }
        ThreadFactory daemonThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HiveClientCache-cleaner-%d").build();
        this.cleanupHandle = Executors.newScheduledThreadPool(1, daemonThreadFactory).scheduleWithFixedDelay(cleanupThread, timeout + 5, cleanupInterval, TimeUnit.SECONDS);
        Thread cleanupHiveClientShutdownThread = new Thread(){

            @Override
            public void run() {
                LOG.debug("Cleaning up hive client cache in ShutDown hook");
                HiveClientCache.this.cleanupHandle.cancel(false);
                HiveClientCache.this.closeAllClientsQuietly();
            }
        };
        Runtime.getRuntime().addShutdownHook(cleanupHiveClientShutdownThread);
    }

    void closeAllClientsQuietly() {
        try {
            ConcurrentMap<HiveClientCacheKey, ICacheableMetaStoreClient> elements = this.hiveCache.asMap();
            for (ICacheableMetaStoreClient cacheableHiveMetaStoreClient : elements.values()) {
                cacheableHiveMetaStoreClient.tearDown();
            }
        }
        catch (Exception e) {
            LOG.warn("Clean up of hive clients in the cache failed. Ignored", e);
        }
    }

    public void cleanup() {
        this.hiveCache.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICacheableMetaStoreClient get(HiveConf hiveConf) throws MetaException, IOException, LoginException {
        HiveClientCacheKey cacheKey = HiveClientCacheKey.fromHiveConf(hiveConf, this.getThreadId());
        ICacheableMetaStoreClient cacheableHiveMetaStoreClient = null;
        Object object = this.CACHE_TEARDOWN_LOCK;
        synchronized (object) {
            cacheableHiveMetaStoreClient = this.getOrCreate(cacheKey);
            cacheableHiveMetaStoreClient.acquire();
        }
        if (!cacheableHiveMetaStoreClient.isOpen()) {
            object = this.CACHE_TEARDOWN_LOCK;
            synchronized (object) {
                this.hiveCache.invalidate(cacheKey);
                cacheableHiveMetaStoreClient.close();
                cacheableHiveMetaStoreClient = this.getOrCreate(cacheKey);
                cacheableHiveMetaStoreClient.acquire();
            }
        }
        return cacheableHiveMetaStoreClient;
    }

    private ICacheableMetaStoreClient getOrCreate(final HiveClientCacheKey cacheKey) throws IOException, MetaException, LoginException {
        try {
            return this.hiveCache.get(cacheKey, new Callable<ICacheableMetaStoreClient>(){

                @Override
                public ICacheableMetaStoreClient call() throws MetaException {
                    return (ICacheableMetaStoreClient)RetryingMetaStoreClient.getProxy(cacheKey.getHiveConf(), new Class[]{HiveConf.class, Integer.class}, new Object[]{cacheKey.getHiveConf(), HiveClientCache.this.timeout}, CacheableHiveMetaStoreClient.class.getName());
                }
            });
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof MetaException) {
                throw (MetaException)((Object)t);
            }
            if (t instanceof LoginException) {
                throw (LoginException)t;
            }
            throw new IOException("Error creating hiveMetaStoreClient", t);
        }
    }

    static class CacheableHiveMetaStoreClient
    extends HiveMetaStoreClient
    implements ICacheableMetaStoreClient {
        private final AtomicInteger users = new AtomicInteger(0);
        private volatile boolean expiredFromCache = false;
        private boolean isClosed = false;
        private final long expiryTime;
        private static final int EXPIRY_TIME_EXTENSION_IN_MILLIS = 60000;

        CacheableHiveMetaStoreClient(HiveConf conf, Integer timeout) throws MetaException {
            super(conf);
            this.expiryTime = System.currentTimeMillis() + (long)(timeout * 1000) + 60000L;
        }

        @Override
        public void acquire() {
            this.users.incrementAndGet();
        }

        @Override
        public void release() {
            this.users.decrementAndGet();
        }

        @Override
        public void setExpiredFromCache() {
            this.expiredFromCache = true;
        }

        @Override
        public boolean isClosed() {
            return this.isClosed;
        }

        @Override
        public AtomicInteger getUsers() {
            return this.users;
        }

        @Override
        public boolean isOpen() {
            try {
                super.getDatabases("NonExistentDatabaseUsedForHealthCheck");
            }
            catch (TException e) {
                return false;
            }
            return true;
        }

        @Override
        public void close() {
            this.release();
            if (System.currentTimeMillis() >= this.expiryTime) {
                this.setExpiredFromCache();
            }
            this.tearDownIfUnused();
        }

        @Override
        public void tearDownIfUnused() {
            if (this.users.get() == 0 && this.expiredFromCache) {
                this.tearDown();
            }
        }

        @Override
        public synchronized void tearDown() {
            try {
                if (!this.isClosed) {
                    super.close();
                }
                this.isClosed = true;
            }
            catch (Exception e) {
                LOG.warn("Error closing hive metastore client. Ignored.", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.tearDown();
            }
            finally {
                super.finalize();
            }
        }
    }

    public static interface ICacheableMetaStoreClient
    extends IMetaStoreClient {
        public void acquire();

        public void release();

        public void setExpiredFromCache();

        public AtomicInteger getUsers();

        public boolean isClosed();

        public boolean isOpen();

        public void tearDownIfUnused();

        public void tearDown();
    }

    public static class HiveClientCacheKey {
        private final String metaStoreURIs;
        private final UserGroupInformation ugi;
        private final HiveConf hiveConf;
        private final int threadId;

        private HiveClientCacheKey(HiveConf hiveConf, int threadId) throws IOException, LoginException {
            this.metaStoreURIs = hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS);
            this.ugi = Utils.getUGI();
            this.hiveConf = hiveConf;
            this.threadId = threadId;
        }

        public static HiveClientCacheKey fromHiveConf(HiveConf hiveConf, int threadId) throws IOException, LoginException {
            return new HiveClientCacheKey(hiveConf, threadId);
        }

        public HiveConf getHiveConf() {
            return this.hiveConf;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HiveClientCacheKey that = (HiveClientCacheKey)o;
            return new EqualsBuilder().append(this.metaStoreURIs, that.metaStoreURIs).append(this.ugi, that.ugi).append(this.threadId, that.threadId).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.metaStoreURIs).append(this.ugi).append(this.threadId).toHashCode();
        }
    }
}

