/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.data;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.hcatalog.data.HCatRecordObjectInspector;

public class HCatRecordObjectInspectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HCatRecordObjectInspectorFactory.class);
    static HashMap<TypeInfo, HCatRecordObjectInspector> cachedHCatRecordObjectInspectors = new HashMap();
    static HashMap<TypeInfo, ObjectInspector> cachedObjectInspectors = new HashMap();

    public static HCatRecordObjectInspector getHCatRecordObjectInspector(StructTypeInfo typeInfo) throws SerDeException {
        HCatRecordObjectInspector oi = cachedHCatRecordObjectInspectors.get(typeInfo);
        if (oi == null) {
            LOG.debug("Got asked for OI for {} [{} ]", (Object)typeInfo.getCategory(), (Object)typeInfo.getTypeName());
            switch (typeInfo.getCategory()) {
                case STRUCT: {
                    StructTypeInfo structTypeInfo = typeInfo;
                    ArrayList<String> fieldNames = structTypeInfo.getAllStructFieldNames();
                    ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                    ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fieldTypeInfos.size());
                    for (int i = 0; i < fieldTypeInfos.size(); ++i) {
                        fieldObjectInspectors.add(HCatRecordObjectInspectorFactory.getStandardObjectInspectorFromTypeInfo((TypeInfo)fieldTypeInfos.get(i)));
                    }
                    oi = new HCatRecordObjectInspector(fieldNames, fieldObjectInspectors);
                    break;
                }
                default: {
                    throw new SerDeException("TypeInfo [" + typeInfo.getTypeName() + "] was not of struct type - HCatRecord expected struct type, got [" + typeInfo.getCategory().toString() + "]");
                }
            }
            cachedHCatRecordObjectInspectors.put(typeInfo, oi);
        }
        return oi;
    }

    public static ObjectInspector getStandardObjectInspectorFromTypeInfo(TypeInfo typeInfo) {
        ObjectInspector oi = cachedObjectInspectors.get(typeInfo);
        if (oi == null) {
            LOG.debug("Got asked for OI for {}, [{}]", (Object)typeInfo.getCategory(), (Object)typeInfo.getTypeName());
            switch (typeInfo.getCategory()) {
                case PRIMITIVE: {
                    oi = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory());
                    break;
                }
                case STRUCT: {
                    StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                    ArrayList<String> fieldNames = structTypeInfo.getAllStructFieldNames();
                    ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                    ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fieldTypeInfos.size());
                    for (int i = 0; i < fieldTypeInfos.size(); ++i) {
                        fieldObjectInspectors.add(HCatRecordObjectInspectorFactory.getStandardObjectInspectorFromTypeInfo((TypeInfo)fieldTypeInfos.get(i)));
                    }
                    oi = ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldObjectInspectors);
                    break;
                }
                case LIST: {
                    ObjectInspector elementObjectInspector = HCatRecordObjectInspectorFactory.getStandardObjectInspectorFromTypeInfo(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                    oi = ObjectInspectorFactory.getStandardListObjectInspector(elementObjectInspector);
                    break;
                }
                case MAP: {
                    ObjectInspector keyObjectInspector = HCatRecordObjectInspectorFactory.getStandardObjectInspectorFromTypeInfo(((MapTypeInfo)typeInfo).getMapKeyTypeInfo());
                    ObjectInspector valueObjectInspector = HCatRecordObjectInspectorFactory.getStandardObjectInspectorFromTypeInfo(((MapTypeInfo)typeInfo).getMapValueTypeInfo());
                    oi = ObjectInspectorFactory.getStandardMapObjectInspector(keyObjectInspector, valueObjectInspector);
                    break;
                }
                default: {
                    oi = null;
                }
            }
            cachedObjectInspectors.put(typeInfo, oi);
        }
        return oi;
    }
}

