/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.hive.hcatalog.common.ErrorType;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchemaUtils;
import org.apache.hive.hcatalog.har.HarOutputCommitterPostProcessor;
import org.apache.hive.hcatalog.mapreduce.FileOutputFormatContainer;
import org.apache.hive.hcatalog.mapreduce.HCatFileUtil;
import org.apache.hive.hcatalog.mapreduce.HCatMapRedUtil;
import org.apache.hive.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hive.hcatalog.mapreduce.HCatTableInfo;
import org.apache.hive.hcatalog.mapreduce.InternalUtil;
import org.apache.hive.hcatalog.mapreduce.OutputCommitterContainer;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hive.hcatalog.mapreduce.StorerInfo;
import org.apache.hive.hcatalog.mapreduce.TaskCommitContextRegistry;
import org.apache.thrift.TException;

class FileOutputCommitterContainer
extends OutputCommitterContainer {
    private static final String TEMP_DIR_NAME = "_temporary";
    private static final String LOGS_DIR_NAME = "_logs";
    static final String DYNTEMP_DIR_NAME = "_DYN";
    static final String SCRATCH_DIR_NAME = "_SCRATCH";
    private static final String APPEND_SUFFIX = "_a_";
    private static final int APPEND_COUNTER_WARN_THRESHOLD = 1000;
    private final int maxAppendAttempts;
    private static final Logger LOG = LoggerFactory.getLogger(FileOutputCommitterContainer.class);
    private final boolean dynamicPartitioningUsed;
    private boolean partitionsDiscovered;
    private final boolean customDynamicLocationUsed;
    private Map<String, Map<String, String>> partitionsDiscoveredByPath;
    private Map<String, org.apache.hadoop.mapreduce.JobContext> contextDiscoveredByPath;
    private final HiveStorageHandler cachedStorageHandler;
    HarOutputCommitterPostProcessor harProcessor = new HarOutputCommitterPostProcessor();
    private String ptnRootLocation = null;
    private OutputJobInfo jobInfo = null;
    public static final String SUCCEEDED_FILE_NAME = "_SUCCESS";
    static final String SUCCESSFUL_JOB_OUTPUT_DIR_MARKER = "mapreduce.fileoutputcommitter.marksuccessfuljobs";

    public FileOutputCommitterContainer(org.apache.hadoop.mapreduce.JobContext context, OutputCommitter baseCommitter) throws IOException {
        super(context, baseCommitter);
        this.jobInfo = HCatOutputFormat.getJobInfo(context.getConfiguration());
        this.dynamicPartitioningUsed = this.jobInfo.isDynamicPartitioningUsed();
        this.partitionsDiscovered = !this.dynamicPartitioningUsed;
        this.cachedStorageHandler = HCatUtil.getStorageHandler(context.getConfiguration(), this.jobInfo.getTableInfo().getStorerInfo());
        Table table = new Table(this.jobInfo.getTableInfo().getTable());
        this.customDynamicLocationUsed = this.dynamicPartitioningUsed && Boolean.valueOf(table.getProperty("EXTERNAL")) != false && this.jobInfo.getCustomDynamicPath() != null && this.jobInfo.getCustomDynamicPath().length() > 0;
        this.maxAppendAttempts = context.getConfiguration().getInt("hcat.append.limit", 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTask(TaskAttemptContext context) throws IOException {
        if (!this.dynamicPartitioningUsed) {
            this.getBaseOutputCommitter().abortTask((TaskAttemptContext)HCatMapRedUtil.createTaskAttemptContext(context));
        } else {
            try {
                TaskCommitContextRegistry.getInstance().abortTask(context);
            }
            finally {
                TaskCommitContextRegistry.getInstance().discardCleanupFor(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTask(TaskAttemptContext context) throws IOException {
        if (!this.dynamicPartitioningUsed) {
            FileOutputFormatContainer.setWorkOutputPath(context);
            this.getBaseOutputCommitter().commitTask((TaskAttemptContext)HCatMapRedUtil.createTaskAttemptContext(context));
        } else {
            try {
                TaskCommitContextRegistry.getInstance().commitTask(context);
            }
            finally {
                TaskCommitContextRegistry.getInstance().discardCleanupFor(context);
            }
        }
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        if (!this.dynamicPartitioningUsed) {
            return this.getBaseOutputCommitter().needsTaskCommit((TaskAttemptContext)HCatMapRedUtil.createTaskAttemptContext(context));
        }
        return true;
    }

    public void setupJob(org.apache.hadoop.mapreduce.JobContext context) throws IOException {
        if (this.getBaseOutputCommitter() != null && !this.dynamicPartitioningUsed) {
            this.getBaseOutputCommitter().setupJob((org.apache.hadoop.mapreduce.JobContext)HCatMapRedUtil.createJobContext(context));
        }
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        if (!this.dynamicPartitioningUsed) {
            this.getBaseOutputCommitter().setupTask((TaskAttemptContext)HCatMapRedUtil.createTaskAttemptContext(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortJob(org.apache.hadoop.mapreduce.JobContext jobContext, JobStatus.State state) throws IOException {
        try {
            if (this.dynamicPartitioningUsed) {
                this.discoverPartitions(jobContext);
            }
            JobContext mapRedJobContext = HCatMapRedUtil.createJobContext(jobContext);
            if (this.getBaseOutputCommitter() != null && !this.dynamicPartitioningUsed) {
                this.getBaseOutputCommitter().abortJob((org.apache.hadoop.mapreduce.JobContext)mapRedJobContext, state);
            } else if (this.dynamicPartitioningUsed) {
                for (org.apache.hadoop.mapreduce.JobContext currContext : this.contextDiscoveredByPath.values()) {
                    try {
                        new JobConf(currContext.getConfiguration()).getOutputCommitter().abortJob(currContext, state);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            }
            OutputJobInfo jobInfo = HCatOutputFormat.getJobInfo(jobContext.getConfiguration());
            Path tblPath = new Path(jobInfo.getTableInfo().getTableLocation());
            Path src = this.dynamicPartitioningUsed ? (!this.customDynamicLocationUsed ? new Path(this.getPartitionRootLocation(jobInfo.getLocation(), jobInfo.getTableInfo().getTable().getPartitionKeysSize())) : new Path(this.getCustomPartitionRootLocation(jobInfo, jobContext.getConfiguration()))) : new Path(jobInfo.getLocation());
            FileSystem fs = src.getFileSystem(jobContext.getConfiguration());
            LOG.info("Job failed. Try cleaning up temporary directory [{}].", src);
            if (!src.equals((Object)tblPath)) {
                fs.delete(src, true);
            }
        }
        finally {
            this.cancelDelegationTokens(jobContext);
        }
    }

    private static boolean getOutputDirMarking(Configuration conf) {
        return conf.getBoolean(SUCCESSFUL_JOB_OUTPUT_DIR_MARKER, false);
    }

    public void commitJob(org.apache.hadoop.mapreduce.JobContext jobContext) throws IOException {
        Path filePath;
        Path outputPath;
        FileSystem fileSys;
        if (this.dynamicPartitioningUsed) {
            this.discoverPartitions(jobContext);
            for (org.apache.hadoop.mapreduce.JobContext context : this.contextDiscoveredByPath.values()) {
                new JobConf(context.getConfiguration()).getOutputCommitter().commitJob(context);
            }
        }
        if (this.getBaseOutputCommitter() != null && !this.dynamicPartitioningUsed) {
            this.getBaseOutputCommitter().commitJob((org.apache.hadoop.mapreduce.JobContext)HCatMapRedUtil.createJobContext(jobContext));
        }
        this.registerPartitions(jobContext);
        OutputJobInfo jobInfo = HCatOutputFormat.getJobInfo(jobContext.getConfiguration());
        if (FileOutputCommitterContainer.getOutputDirMarking(jobContext.getConfiguration()) && (fileSys = (outputPath = new Path(jobInfo.getLocation())).getFileSystem(jobContext.getConfiguration())).exists(outputPath) && !fileSys.exists(filePath = new Path(outputPath, SUCCEEDED_FILE_NAME))) {
            fileSys.create(filePath).close();
        }
        this.cancelDelegationTokens(jobContext);
    }

    public void cleanupJob(org.apache.hadoop.mapreduce.JobContext context) throws IOException {
        throw new IOException("The method cleanupJob is deprecated and should not be called.");
    }

    private String getCustomPartitionRootLocation(OutputJobInfo jobInfo, Configuration conf) {
        if (this.ptnRootLocation == null) {
            String parentPath = jobInfo.getTableInfo().getTableLocation();
            if (jobInfo.getCustomDynamicRoot() != null && jobInfo.getCustomDynamicRoot().length() > 0) {
                parentPath = new Path(parentPath, jobInfo.getCustomDynamicRoot()).toString();
            }
            Path ptnRoot = new Path(parentPath, DYNTEMP_DIR_NAME + conf.get("mapreduce.lib.hcatoutput.dynamic.jobid"));
            this.ptnRootLocation = ptnRoot.toString();
        }
        return this.ptnRootLocation;
    }

    private String getPartitionRootLocation(String ptnLocn, int numPtnKeys) {
        if (this.customDynamicLocationUsed) {
            return null;
        }
        if (this.ptnRootLocation == null) {
            Path ptnRoot = new Path(ptnLocn);
            for (int i = 0; i < numPtnKeys; ++i) {
                ptnRoot = ptnRoot.getParent();
            }
            this.ptnRootLocation = ptnRoot.toString();
        }
        return this.ptnRootLocation;
    }

    private Partition constructPartition(org.apache.hadoop.mapreduce.JobContext context, OutputJobInfo jobInfo, String partLocnRoot, String dynPartPath, Map<String, String> partKVs, HCatSchema outputSchema, Map<String, String> params, Table table, FileSystem fs, String grpName, FsPermission perms) throws IOException {
        Path partPath;
        Partition partition = new Partition();
        partition.setDbName(table.getDbName());
        partition.setTableName(table.getTableName());
        partition.setSd(new StorageDescriptor(table.getTTable().getSd()));
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
        for (HCatFieldSchema fieldSchema : outputSchema.getFields()) {
            fields.add(HCatSchemaUtils.getFieldSchema(fieldSchema));
        }
        partition.getSd().setCols(fields);
        partition.setValues(FileOutputFormatContainer.getPartitionValueList(table, partKVs));
        partition.setParameters(params);
        if (this.customDynamicLocationUsed) {
            partPath = new Path(dynPartPath);
        } else if (!this.dynamicPartitioningUsed && Boolean.valueOf(table.getProperty("EXTERNAL")).booleanValue() && jobInfo.getLocation() != null && jobInfo.getLocation().length() > 0) {
            String jobLocation = jobInfo.getLocation();
            String finalLocn = jobLocation.replaceAll("/_SCRATCH\\d\\.?\\d+", "");
            partPath = new Path(finalLocn);
        } else {
            partPath = new Path(partLocnRoot);
            int i = 0;
            for (FieldSchema partKey : table.getPartitionKeys()) {
                if (i++ != 0) {
                    fs.mkdirs(partPath);
                    this.applyGroupAndPerms(fs, partPath, perms, grpName, false);
                }
                partPath = this.constructPartialPartPath(partPath, partKey.getName().toLowerCase(), partKVs);
            }
        }
        fs.mkdirs(partPath);
        if (!ShimLoader.getHadoopShims().getHCatShim().isFileInHDFS(fs, partPath)) {
            this.applyGroupAndPerms(fs, partPath, perms, grpName, true);
        }
        if (this.dynamicPartitioningUsed) {
            String dynamicPartitionDestination = this.getFinalDynamicPartitionDestination(table, partKVs, jobInfo);
            if (this.harProcessor.isEnabled()) {
                this.harProcessor.exec(context, partition, partPath);
                partition.getSd().setLocation(this.harProcessor.getProcessedLocation(new Path(dynamicPartitionDestination)));
            } else {
                partition.getSd().setLocation(dynamicPartitionDestination);
            }
        } else {
            partition.getSd().setLocation(partPath.toString());
        }
        return partition;
    }

    private void applyGroupAndPerms(FileSystem fs, Path dir, FsPermission permission, String group, boolean recursive) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("applyGroupAndPerms : " + dir + " perms: " + permission + " group: " + group + " recursive: " + recursive);
        }
        fs.setPermission(dir, permission);
        if (recursive) {
            for (FileStatus fileStatus : fs.listStatus(dir)) {
                if (fileStatus.isDir()) {
                    this.applyGroupAndPerms(fs, fileStatus.getPath(), permission, group, true);
                    continue;
                }
                fs.setPermission(fileStatus.getPath(), permission);
            }
        }
    }

    private String getFinalDynamicPartitionDestination(Table table, Map<String, String> partKVs, OutputJobInfo jobInfo) {
        Path partPath = new Path(table.getTTable().getSd().getLocation());
        if (!this.customDynamicLocationUsed) {
            for (FieldSchema partKey : table.getPartitionKeys()) {
                partPath = this.constructPartialPartPath(partPath, partKey.getName().toLowerCase(), partKVs);
            }
            return partPath.toString();
        }
        if (jobInfo.getCustomDynamicRoot() != null && jobInfo.getCustomDynamicRoot().length() > 0) {
            partPath = new Path(partPath, jobInfo.getCustomDynamicRoot());
        }
        return new Path(partPath, HCatFileUtil.resolveCustomPath(jobInfo, partKVs, false)).toString();
    }

    private Map<String, String> getStorerParameterMap(StorerInfo storer) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : storer.getProperties().entrySet()) {
            params.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return params;
    }

    private Path constructPartialPartPath(Path partialPath, String partKey, Map<String, String> partKVs) {
        StringBuilder sb = new StringBuilder(FileUtils.escapePathName(partKey));
        sb.append("=");
        sb.append(FileUtils.escapePathName(partKVs.get(partKey)));
        return new Path(partialPath, sb.toString());
    }

    private void updateTableSchema(IMetaStoreClient client, Table table, HCatSchema partitionSchema) throws IOException, InvalidOperationException, MetaException, TException {
        List<FieldSchema> newColumns = HCatUtil.validatePartitionSchema(table, partitionSchema);
        if (newColumns.size() != 0) {
            ArrayList<FieldSchema> tableColumns = new ArrayList<FieldSchema>(table.getTTable().getSd().getCols());
            tableColumns.addAll(newColumns);
            table.getTTable().getSd().setCols(tableColumns);
            client.alter_table(table.getDbName(), table.getTableName(), table.getTTable());
        }
    }

    private void moveTaskOutputs(FileSystem fs, Path file, Path srcDir, Path destDir, boolean dryRun, boolean immutable) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("moveTaskOutputs " + file + " from: " + srcDir + " to: " + destDir + " dry: " + dryRun + " immutable: " + immutable);
        }
        if (this.dynamicPartitioningUsed) {
            immutable = true;
        }
        if (file.getName().equals(TEMP_DIR_NAME) || file.getName().equals(LOGS_DIR_NAME) || file.getName().equals(SUCCEEDED_FILE_NAME)) {
            return;
        }
        Path finalOutputPath = this.getFinalPath(fs, file, srcDir, destDir, immutable);
        FileStatus fileStatus = fs.getFileStatus(file);
        if (!fileStatus.isDir()) {
            if (dryRun) {
                if (immutable) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Testing if moving file: [" + file + "] to [" + finalOutputPath + "] would cause a problem");
                    }
                    if (fs.exists(finalOutputPath)) {
                        throw new HCatException(ErrorType.ERROR_MOVE_FAILED, "Data already exists in " + finalOutputPath + ", duplicate publish not possible.");
                    }
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Moving file: [ " + file + "] to [" + finalOutputPath + "]");
                }
                fs.mkdirs(finalOutputPath.getParent());
                if (!fs.rename(file, finalOutputPath)) {
                    if (!fs.delete(finalOutputPath, true)) {
                        throw new HCatException(ErrorType.ERROR_MOVE_FAILED, "Failed to delete existing path " + finalOutputPath);
                    }
                    if (!fs.rename(file, finalOutputPath)) {
                        throw new HCatException(ErrorType.ERROR_MOVE_FAILED, "Failed to move output to " + finalOutputPath);
                    }
                }
            }
        } else {
            FileStatus[] children = fs.listStatus(file);
            FileStatus firstChild = null;
            if (children != null) {
                for (int index = 0; index < children.length; ++index) {
                    if (children[index].getPath().getName().equals(TEMP_DIR_NAME) || children[index].getPath().getName().equals(LOGS_DIR_NAME) || children[index].getPath().getName().equals(SUCCEEDED_FILE_NAME)) continue;
                    firstChild = children[index];
                    break;
                }
            }
            if (firstChild != null && firstChild.isDir()) {
                for (FileStatus child : children) {
                    this.moveTaskOutputs(fs, child.getPath(), srcDir, destDir, dryRun, immutable);
                }
            } else if (!dryRun) {
                if (this.dynamicPartitioningUsed) {
                    Path dstPath;
                    Path parentDir = finalOutputPath.getParent();
                    Path placeholder = new Path(parentDir, "_placeholder");
                    if (fs.mkdirs(parentDir)) {
                        fs.create(placeholder).close();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Moving directory: " + file + " to " + parentDir);
                    }
                    Path path = dstPath = !this.customDynamicLocationUsed ? parentDir : finalOutputPath;
                    if (!fs.rename(file, dstPath)) {
                        String msg = "Failed to move file: " + file + " to " + dstPath;
                        LOG.error(msg);
                        throw new HCatException(ErrorType.ERROR_MOVE_FAILED, msg);
                    }
                    fs.delete(placeholder, false);
                } else {
                    for (FileStatus child : children) {
                        this.moveTaskOutputs(fs, child.getPath(), srcDir, destDir, dryRun, immutable);
                    }
                }
            } else if (immutable && fs.exists(finalOutputPath) && !MetaStoreUtils.isDirEmpty(fs, finalOutputPath)) {
                throw new HCatException(ErrorType.ERROR_DUPLICATE_PARTITION, "Data already exists in " + finalOutputPath + ", duplicate publish not possible.");
            }
        }
    }

    private Path getFinalPath(FileSystem fs, Path file, Path src, Path dest, boolean immutable) throws IOException {
        URI relativePath;
        URI taskOutputUri = file.toUri();
        if (taskOutputUri == (relativePath = src.toUri().relativize(taskOutputUri))) {
            throw new HCatException(ErrorType.ERROR_MOVE_FAILED, "Can not get the relative path: base = " + src + " child = " + file);
        }
        if (relativePath.getPath().length() > 0) {
            Path itemDest = new Path(dest, relativePath.getPath());
            if (!immutable) {
                int counter;
                String filetype;
                String name = relativePath.getPath();
                int index = name.lastIndexOf(46);
                if (index >= 0) {
                    filetype = name.substring(index);
                    name = name.substring(0, index);
                } else {
                    filetype = "";
                }
                for (counter = 1; fs.exists(itemDest) && counter < this.maxAppendAttempts; ++counter) {
                    itemDest = new Path(dest, name + APPEND_SUFFIX + counter + filetype);
                }
                if (counter == this.maxAppendAttempts) {
                    throw new HCatException(ErrorType.ERROR_MOVE_FAILED, "Could not find a unique destination path for move: file = " + file + " , src = " + src + ", dest = " + dest);
                }
                if (counter > 1000) {
                    LOG.warn("Append job used filename clash counter [" + counter + "] which is greater than warning limit [" + 1000 + "]. Please compact this table so that performance is not impacted." + " Please see HIVE-9381 for details.");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("FinalPath(file:" + file + ":" + src + "->" + dest + "=" + itemDest);
            }
            return itemDest;
        }
        return dest;
    }

    private void discoverPartitions(org.apache.hadoop.mapreduce.JobContext context) throws IOException {
        if (!this.partitionsDiscovered) {
            OutputJobInfo jobInfo = HCatOutputFormat.getJobInfo(context.getConfiguration());
            this.harProcessor.setEnabled(jobInfo.getHarRequested());
            List<Integer> dynamicPartCols = jobInfo.getPosOfDynPartCols();
            int maxDynamicPartitions = jobInfo.getMaxDynamicPartitions();
            Path loadPath = new Path(jobInfo.getLocation());
            FileSystem fs = loadPath.getFileSystem(context.getConfiguration());
            String dynPathSpec = loadPath.toUri().getPath();
            dynPathSpec = dynPathSpec.replaceAll("__HIVE_DEFAULT_PARTITION__", "*");
            Path pathPattern = new Path(dynPathSpec);
            FileStatus[] status = fs.globStatus(pathPattern, FileUtils.HIDDEN_FILES_PATH_FILTER);
            this.partitionsDiscoveredByPath = new LinkedHashMap<String, Map<String, String>>();
            this.contextDiscoveredByPath = new LinkedHashMap<String, org.apache.hadoop.mapreduce.JobContext>();
            if (status.length != 0) {
                if (maxDynamicPartitions != -1 && status.length > maxDynamicPartitions) {
                    this.partitionsDiscovered = true;
                    throw new HCatException(ErrorType.ERROR_TOO_MANY_DYNAMIC_PTNS, "Number of dynamic partitions being created exceeds configured max allowable partitions[" + maxDynamicPartitions + "], increase parameter [" + HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS.varname + "] if needed.");
                }
                for (FileStatus st : status) {
                    LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>();
                    if (!this.customDynamicLocationUsed) {
                        Warehouse.makeSpecFromName(fullPartSpec, st.getPath());
                    } else {
                        HCatFileUtil.getPartKeyValuesForCustomLocation(fullPartSpec, jobInfo, st.getPath().toString());
                    }
                    this.partitionsDiscoveredByPath.put(st.getPath().toString(), fullPartSpec);
                    JobConf jobConf = (JobConf)context.getConfiguration();
                    JobContext currContext = HCatMapRedUtil.createJobContext(jobConf, context.getJobID(), (Progressable)InternalUtil.createReporter(HCatMapRedUtil.createTaskAttemptContext((Configuration)jobConf, ShimLoader.getHadoopShims().getHCatShim().createTaskAttemptID())));
                    HCatOutputFormat.configureOutputStorageHandler((org.apache.hadoop.mapreduce.JobContext)currContext, jobInfo, fullPartSpec);
                    this.contextDiscoveredByPath.put(st.getPath().toString(), (org.apache.hadoop.mapreduce.JobContext)currContext);
                }
            }
            this.partitionsDiscovered = true;
        }
    }

    private void registerPartitions(org.apache.hadoop.mapreduce.JobContext context) throws IOException {
        IMetaStoreClient client;
        block39: {
            if (this.dynamicPartitioningUsed) {
                this.discoverPartitions(context);
            }
            OutputJobInfo jobInfo = HCatOutputFormat.getJobInfo(context.getConfiguration());
            Configuration conf = context.getConfiguration();
            Table table = new Table(jobInfo.getTableInfo().getTable());
            Path tblPath = new Path(table.getTTable().getSd().getLocation());
            FileSystem fs = tblPath.getFileSystem(conf);
            if (table.getPartitionKeys().size() == 0) {
                Path src = new Path(jobInfo.getLocation());
                this.moveTaskOutputs(fs, src, src, tblPath, false, table.isImmutable());
                if (!src.equals((Object)tblPath)) {
                    fs.delete(src, true);
                }
                return;
            }
            client = null;
            HCatTableInfo tableInfo = jobInfo.getTableInfo();
            ArrayList<Object> partitionsAdded = new ArrayList();
            try {
                Path src;
                HiveConf hiveConf = HCatUtil.getHiveConf(conf);
                client = HCatUtil.getHiveMetastoreClient(hiveConf);
                StorerInfo storer = InternalUtil.extractStorerInfo(table.getTTable().getSd(), table.getParameters());
                FileStatus tblStat = fs.getFileStatus(tblPath);
                String grpName = tblStat.getGroup();
                FsPermission perms = tblStat.getPermission();
                ArrayList<Partition> partitionsToAdd = new ArrayList<Partition>();
                if (!this.dynamicPartitioningUsed) {
                    partitionsToAdd.add(this.constructPartition(context, jobInfo, tblPath.toString(), null, jobInfo.getPartitionValues(), jobInfo.getOutputSchema(), this.getStorerParameterMap(storer), table, fs, grpName, perms));
                } else {
                    for (Map.Entry<String, Map<String, String>> entry : this.partitionsDiscoveredByPath.entrySet()) {
                        partitionsToAdd.add(this.constructPartition(context, jobInfo, this.getPartitionRootLocation(entry.getKey(), entry.getValue().size()), entry.getKey(), entry.getValue(), jobInfo.getOutputSchema(), this.getStorerParameterMap(storer), table, fs, grpName, perms));
                    }
                }
                ArrayList<Map<String, String>> ptnInfos = new ArrayList<Map<String, String>>();
                for (Partition ptn : partitionsToAdd) {
                    ptnInfos.add(InternalUtil.createPtnKeyValueMap(new Table(tableInfo.getTable()), ptn));
                }
                if (this.dynamicPartitioningUsed && this.harProcessor.isEnabled() && !partitionsToAdd.isEmpty()) {
                    if (!this.customDynamicLocationUsed) {
                        src = new Path(this.ptnRootLocation);
                        this.moveTaskOutputs(fs, src, src, tblPath, true, true);
                        this.moveTaskOutputs(fs, src, src, tblPath, false, true);
                        if (!src.equals((Object)tblPath)) {
                            fs.delete(src, true);
                        }
                    } else {
                        this.moveCustomLocationTaskOutputs(fs, table, hiveConf);
                    }
                    try {
                        this.updateTableSchema(client, table, jobInfo.getOutputSchema());
                        LOG.info("HAR is being used. The table {} has new partitions {}.", (Object)table.getTableName(), ptnInfos);
                        client.add_partitions(partitionsToAdd);
                        partitionsAdded = partitionsToAdd;
                        break block39;
                    }
                    catch (Exception e) {
                        for (Partition p : partitionsToAdd) {
                            Path ptnPath = new Path(this.harProcessor.getParentFSPath(new Path(p.getSd().getLocation())));
                            if (!fs.exists(ptnPath)) continue;
                            fs.delete(ptnPath, true);
                        }
                        throw e;
                    }
                }
                this.updateTableSchema(client, table, jobInfo.getOutputSchema());
                LOG.info("HAR not is not being used. The table {} has new partitions {}.", (Object)table.getTableName(), ptnInfos);
                if (partitionsToAdd.size() > 0) {
                    if (!this.dynamicPartitioningUsed) {
                        if (partitionsToAdd.size() > 1) {
                            throw new HCatException(ErrorType.ERROR_PUBLISHING_PARTITION, "More than one partition to publish in non-dynamic partitioning job");
                        }
                        Partition p = (Partition)partitionsToAdd.get(0);
                        Path src2 = new Path(jobInfo.getLocation());
                        Path dest = new Path(p.getSd().getLocation());
                        this.moveTaskOutputs(fs, src2, src2, dest, true, table.isImmutable());
                        this.moveTaskOutputs(fs, src2, src2, dest, false, table.isImmutable());
                        if (!src2.equals((Object)dest)) {
                            fs.delete(src2, true);
                        }
                        boolean publishRequired = false;
                        try {
                            Partition existingP = client.getPartition(p.getDbName(), p.getTableName(), p.getValues());
                            if (existingP != null) {
                                if (table.isImmutable()) {
                                    throw new HCatException(ErrorType.ERROR_DUPLICATE_PARTITION, "Attempted duplicate partition publish on to immutable table");
                                }
                                if (!existingP.getSd().getInputFormat().equals(table.getInputFormatClass().getName())) {
                                    throw new HCatException(ErrorType.ERROR_PUBLISHING_PARTITION, "Attempted partition append, where old partition format was " + existingP.getSd().getInputFormat() + " and table format was " + table.getInputFormatClass().getName());
                                }
                            } else {
                                publishRequired = true;
                            }
                        }
                        catch (NoSuchObjectException e) {
                            publishRequired = true;
                        }
                        if (publishRequired) {
                            client.add_partitions(partitionsToAdd);
                            partitionsAdded = partitionsToAdd;
                        }
                    } else {
                        if (!this.customDynamicLocationUsed) {
                            src = new Path(this.ptnRootLocation);
                            this.moveTaskOutputs(fs, src, src, tblPath, true, true);
                            this.moveTaskOutputs(fs, src, src, tblPath, false, true);
                            if (!src.equals((Object)tblPath)) {
                                fs.delete(src, true);
                            }
                        } else {
                            this.moveCustomLocationTaskOutputs(fs, table, hiveConf);
                        }
                        client.add_partitions(partitionsToAdd);
                        partitionsAdded = partitionsToAdd;
                    }
                }
                for (Partition p : partitionsAdded) {
                    this.applyGroupAndPerms(fs, new Path(p.getSd().getLocation()), tblStat.getPermission(), tblStat.getGroup(), true);
                }
            }
            catch (Exception e) {
                try {
                    if (partitionsAdded.size() > 0) {
                        try {
                            for (Partition p : partitionsAdded) {
                                client.dropPartition(tableInfo.getDatabaseName(), tableInfo.getTableName(), p.getValues(), true);
                            }
                        }
                        catch (Exception te) {
                            throw new HCatException(ErrorType.ERROR_PUBLISHING_PARTITION, (Throwable)e);
                        }
                    }
                    if (e instanceof HCatException) {
                        throw (HCatException)e;
                    }
                    throw new HCatException(ErrorType.ERROR_PUBLISHING_PARTITION, (Throwable)e);
                }
                catch (Throwable throwable) {
                    HCatUtil.closeHiveClientQuietly(client);
                    throw throwable;
                }
            }
        }
        HCatUtil.closeHiveClientQuietly(client);
    }

    private void moveCustomLocationTaskOutputs(FileSystem fs, Table table, Configuration conf) throws IOException {
        for (Map.Entry<String, Map<String, String>> entry : this.partitionsDiscoveredByPath.entrySet()) {
            Path src = new Path(entry.getKey());
            Path destPath = new Path(this.getFinalDynamicPartitionDestination(table, entry.getValue(), this.jobInfo));
            this.moveTaskOutputs(fs, src, src, destPath, true, true);
            this.moveTaskOutputs(fs, src, src, destPath, false, true);
        }
        Path parentPath = new Path(this.getCustomPartitionRootLocation(this.jobInfo, conf));
        if (fs.exists(parentPath)) {
            fs.delete(parentPath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void cancelDelegationTokens(org.apache.hadoop.mapreduce.JobContext context) throws IOException {
        IMetaStoreClient client;
        block6: {
            LOG.info("Cancelling delegation token for the job.");
            client = null;
            try {
                HiveConf hiveConf = HCatUtil.getHiveConf(context.getConfiguration());
                client = HCatUtil.getHiveMetastoreClient(hiveConf);
                String tokenStrForm = client.getTokenStrForm();
                if (tokenStrForm == null || context.getConfiguration().get("mapreduce.lib.hcatoutput.token.sig") == null) break block6;
                client.cancelDelegationToken(tokenStrForm);
            }
            catch (MetaException e) {
                LOG.warn("MetaException while cancelling delegation token.", (Throwable)((Object)e));
                HCatUtil.closeHiveClientQuietly(client);
            }
            catch (TException e2) {
                LOG.warn("TException while cancelling delegation token.", e2);
                {
                    catch (Throwable throwable) {
                        HCatUtil.closeHiveClientQuietly(client);
                        throw throwable;
                    }
                }
                HCatUtil.closeHiveClientQuietly(client);
            }
        }
        HCatUtil.closeHiveClientQuietly(client);
    }
}

