/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.block.ClosingBlockLease;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.array.Arrays;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.reader.SliceSelectiveStreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.ByteArrayInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.orc.stream.RowGroupDictionaryLengthInputStream;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class SliceDictionarySelectiveReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDictionarySelectiveReader.class).instanceSize();
    private static final byte FILTER_NOT_EVALUATED = 0;
    private static final byte FILTER_PASSED = 1;
    private static final byte FILTER_FAILED = 2;
    private static final byte[] EMPTY_DICTIONARY_DATA = new byte[0];
    private static final int[] EMPTY_DICTIONARY_OFFSETS = new int[2];
    private static final int BATCHES_PER_ROWGROUP = 10;
    private static final float MATERIALIZATION_RATIO = 2.0f;
    private final TupleDomainFilter filter;
    private final boolean nonDeterministicFilter;
    private final boolean nullsAllowed;
    private final Type outputType;
    private final boolean outputRequired;
    private final StreamDescriptor streamDescriptor;
    private final int maxCodePointCount;
    private final boolean isCharType;
    private byte[] dictionaryData = EMPTY_DICTIONARY_DATA;
    private int[] dictionaryOffsetVector = EMPTY_DICTIONARY_OFFSETS;
    private int[] stripeDictionaryLength = new int[0];
    private int[] rowGroupDictionaryLength = new int[0];
    private byte[] evaluationStatus;
    private byte[] valueWithPadding;
    private int readOffset;
    private VariableWidthBlock dictionary = new VariableWidthBlock(1, Slices.wrappedBuffer((byte[])EMPTY_DICTIONARY_DATA), EMPTY_DICTIONARY_OFFSETS, Optional.of(new boolean[]{true}));
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    private BooleanInputStream presentStream;
    private BooleanInputStream inDictionaryStream;
    private InputStreamSource<ByteArrayInputStream> stripeDictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    private InputStreamSource<LongInputStream> stripeDictionaryLengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private boolean stripeDictionaryOpen;
    private boolean dictionaryWrapped;
    private int stripeDictionarySize;
    private int currentDictionarySize;
    private InputStreamSource<ByteArrayInputStream> rowGroupDictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    private InputStreamSource<BooleanInputStream> inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    private InputStreamSource<RowGroupDictionaryLengthInputStream> rowGroupDictionaryLengthStreamSource = MissingInputStreamSource.missingStreamSource(RowGroupDictionaryLengthInputStream.class);
    private InputStreamSource<LongInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private LongInputStream dataStream;
    private boolean rowGroupOpen;
    private OrcLocalMemoryContext systemMemoryContext;
    private int[] values;
    private boolean allNulls;
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean valuesInUse;

    public SliceDictionarySelectiveReader(StreamDescriptor streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, OrcLocalMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.filter = Objects.requireNonNull(filter, "filter is null").orElse(null);
        this.systemMemoryContext = systemMemoryContext;
        this.nonDeterministicFilter = this.filter != null && !this.filter.isDeterministic();
        this.nullsAllowed = this.filter == null || this.nonDeterministicFilter || this.filter.testNull();
        this.outputType = Objects.requireNonNull(outputType, "outputType is null").orElse(null);
        OrcType orcType = streamDescriptor.getOrcType();
        this.maxCodePointCount = orcType == null ? 0 : orcType.getLength().orElse(-1);
        this.valueWithPadding = this.maxCodePointCount < 0 ? null : new byte[this.maxCodePointCount];
        this.isCharType = orcType.getOrcTypeKind() == OrcType.OrcTypeKind.CHAR;
        this.outputRequired = outputType.isPresent();
        Preconditions.checkArgument((filter.isPresent() || this.outputRequired ? 1 : 0) != 0, (Object)"filter must be present if outputRequired is false");
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        if (this.outputRequired) {
            this.values = Arrays.ensureCapacity(this.values, positionCount);
        }
        this.outputPositions = SelectiveStreamReaders.initializeOutputPositions(this.outputPositions, positions, positionCount);
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        this.outputPositionCount = 0;
        int streamPosition = this.dataStream == null && this.presentStream != null ? this.readAllNulls(positions, positionCount) : (this.filter == null ? this.readNoFilter(positions, positionCount) : this.readWithFilter(positions, positionCount));
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readNoFilter(int[] positions, int positionCount) throws IOException {
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                this.values[i] = this.currentDictionarySize - 1;
            } else {
                boolean isInRowDictionary = this.inDictionaryStream != null && !this.inDictionaryStream.nextBit();
                int index = Math.toIntExact(this.dataStream.next());
                this.values[i] = isInRowDictionary ? this.stripeDictionarySize + index : index;
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    private int readWithFilter(int[] positions, int positionCount) throws IOException {
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nonDeterministicFilter && this.filter.testNull() || this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.values[this.outputPositionCount] = this.currentDictionarySize - 1;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                int length;
                int index;
                boolean inRowDictionary = this.inDictionaryStream != null && !this.inDictionaryStream.nextBit();
                int rawIndex = Math.toIntExact(this.dataStream.next());
                int n = index = inRowDictionary ? this.stripeDictionarySize + rawIndex : rawIndex;
                if (this.isCharType) {
                    length = this.maxCodePointCount;
                } else {
                    int n2 = length = inRowDictionary ? this.rowGroupDictionaryLength[rawIndex] : this.stripeDictionaryLength[rawIndex];
                }
                if (this.nonDeterministicFilter) {
                    this.evaluateFilter(position, index, length);
                } else {
                    switch (this.evaluationStatus[index]) {
                        case 2: {
                            break;
                        }
                        case 1: {
                            if (this.outputRequired) {
                                this.values[this.outputPositionCount] = index;
                            }
                            this.outputPositions[this.outputPositionCount] = position;
                            ++this.outputPositionCount;
                            break;
                        }
                        case 0: {
                            this.evaluationStatus[index] = this.evaluateFilter(position, index, length);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("invalid evaluation state");
                        }
                    }
                }
            }
            ++streamPosition;
            if (this.filter == null) continue;
            this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
            int succeedingPositionsToFail = this.filter.getSucceedingPositionsToFail();
            if (succeedingPositionsToFail <= 0) continue;
            int positionsToSkip = 0;
            for (int j = 0; j < succeedingPositionsToFail; ++j) {
                int nextPosition = positions[++i];
                positionsToSkip += 1 + nextPosition - streamPosition;
                streamPosition = nextPosition + 1;
            }
            this.skip(positionsToSkip);
        }
        return streamPosition;
    }

    private byte evaluateFilter(int position, int index, int length) {
        if (!this.filter.testLength(length)) {
            return 2;
        }
        int currentLength = this.dictionaryOffsetVector[index + 1] - this.dictionaryOffsetVector[index];
        if (this.isCharType && length != currentLength) {
            System.arraycopy(this.dictionaryData, this.dictionaryOffsetVector[index], this.valueWithPadding, 0, currentLength);
            java.util.Arrays.fill(this.valueWithPadding, currentLength, length, (byte)32);
            if (!this.filter.testBytes(this.valueWithPadding, 0, length)) {
                return 2;
            }
        } else if (!this.filter.testBytes(this.dictionaryData, this.dictionaryOffsetVector[index], length)) {
            return 2;
        }
        if (this.outputRequired) {
            this.values[this.outputPositionCount] = index;
        }
        this.outputPositions[this.outputPositionCount] = position;
        ++this.outputPositionCount;
        return 1;
    }

    private int readAllNulls(int[] positions, int positionCount) throws IOException {
        this.presentStream.skip(positions[positionCount - 1]);
        if (this.nonDeterministicFilter) {
            this.outputPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                if (this.filter.testNull()) {
                    ++this.outputPositionCount;
                    continue;
                }
                this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
                i += this.filter.getSucceedingPositionsToFail();
            }
        } else {
            this.outputPositionCount = this.nullsAllowed ? positionCount : 0;
        }
        this.allNulls = true;
        return positions[positionCount - 1] + 1;
    }

    private void skip(int items) throws IOException {
        if (this.presentStream != null) {
            int dataToSkip = this.presentStream.countBitsSet(items);
            if (this.inDictionaryStream != null) {
                this.inDictionaryStream.skip(dataToSkip);
            }
            if (this.dataStream != null) {
                this.dataStream.skip(dataToSkip);
            }
        } else {
            if (this.inDictionaryStream != null) {
                this.inDictionaryStream.skip(items);
            }
            this.dataStream.skip(items);
        }
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), positionCount);
        }
        this.compactValues(positions, positionCount);
        long blockSizeInBytes = 0L;
        int nullCount = 0;
        for (int i = 0; i < positionCount; ++i) {
            int id = this.values[i];
            blockSizeInBytes += (long)(this.dictionaryOffsetVector[id + 1] - this.dictionaryOffsetVector[id]);
            if (id != this.currentDictionarySize - 1) continue;
            ++nullCount;
        }
        if (nullCount == positionCount) {
            return new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), positionCount);
        }
        int dictionarySizeInBytes = this.dictionaryOffsetVector[this.currentDictionarySize - 1];
        if ((float)(blockSizeInBytes * 10L) < (float)dictionarySizeInBytes / 2.0f) {
            return this.getMaterializedBlock(positionCount, blockSizeInBytes, nullCount);
        }
        this.wrapDictionaryIfNecessary();
        int[] valuesCopy = java.util.Arrays.copyOf(this.values, positionCount);
        return new DictionaryBlock(positionCount, (Block)this.dictionary, valuesCopy);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return this.newLease((Block)new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), positionCount));
        }
        if (positionCount < this.outputPositionCount) {
            this.compactValues(positions, positionCount);
        }
        this.wrapDictionaryIfNecessary();
        return this.newLease((Block)new DictionaryBlock(positionCount, (Block)this.dictionary, this.values));
    }

    private void wrapDictionaryIfNecessary() {
        if (this.dictionaryWrapped) {
            return;
        }
        boolean[] isNullVector = new boolean[this.currentDictionarySize];
        isNullVector[this.currentDictionarySize - 1] = true;
        byte[] dictionaryDataCopy = java.util.Arrays.copyOf(this.dictionaryData, this.dictionaryOffsetVector[this.currentDictionarySize]);
        int[] dictionaryOffsetVectorCopy = java.util.Arrays.copyOf(this.dictionaryOffsetVector, this.currentDictionarySize + 1);
        this.dictionary = new VariableWidthBlock(this.currentDictionarySize, Slices.wrappedBuffer((byte[])dictionaryDataCopy), dictionaryOffsetVectorCopy, Optional.of(isNullVector));
        this.dictionaryWrapped = true;
    }

    private void compactValues(int[] positions, int positionCount) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            this.values[positionIndex] = this.values[i];
            this.outputPositions[positionIndex] = nextPosition;
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
    }

    private void openRowGroup() throws IOException {
        RowGroupDictionaryLengthInputStream dictionaryLengthStream;
        if (!this.stripeDictionaryOpen) {
            if (this.stripeDictionarySize > 0) {
                LongInputStream lengthStream;
                if (this.stripeDictionaryLength.length < this.stripeDictionarySize) {
                    this.stripeDictionaryLength = new int[this.stripeDictionarySize];
                }
                if ((lengthStream = this.stripeDictionaryLengthStreamSource.openStream()) == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Dictionary is not empty but dictionary length stream is not present");
                }
                lengthStream.nextIntVector(this.stripeDictionarySize, this.stripeDictionaryLength, 0);
                long dataLength = 0L;
                for (int i = 0; i < this.stripeDictionarySize; ++i) {
                    dataLength += (long)this.stripeDictionaryLength[i];
                }
                this.dictionaryData = Arrays.ensureCapacity(this.dictionaryData, Math.toIntExact(dataLength));
                this.dictionaryOffsetVector = Arrays.ensureCapacity(this.dictionaryOffsetVector, this.stripeDictionarySize + 2);
                ByteArrayInputStream dictionaryDataStream = this.stripeDictionaryDataStreamSource.openStream();
                SliceDictionarySelectiveReader.readDictionary(dictionaryDataStream, this.stripeDictionarySize, this.stripeDictionaryLength, 0, this.dictionaryData, this.dictionaryOffsetVector, this.maxCodePointCount, this.isCharType);
            } else {
                this.dictionaryData = EMPTY_DICTIONARY_DATA;
                this.dictionaryOffsetVector = EMPTY_DICTIONARY_OFFSETS;
            }
            this.dictionaryWrapped = false;
        }
        if ((dictionaryLengthStream = this.rowGroupDictionaryLengthStreamSource.openStream()) != null) {
            int rowGroupDictionarySize = dictionaryLengthStream.getEntryCount();
            this.rowGroupDictionaryLength = Arrays.ensureCapacity(this.rowGroupDictionaryLength, rowGroupDictionarySize);
            dictionaryLengthStream.nextIntVector(rowGroupDictionarySize, this.rowGroupDictionaryLength, 0);
            long dataLength = 0L;
            for (int i = 0; i < rowGroupDictionarySize; ++i) {
                dataLength += (long)this.rowGroupDictionaryLength[i];
            }
            this.dictionaryData = Arrays.ensureCapacity(this.dictionaryData, this.dictionaryOffsetVector[this.stripeDictionarySize] + Math.toIntExact(dataLength), Arrays.ExpansionFactor.MEDIUM, Arrays.ExpansionOption.PRESERVE);
            this.dictionaryOffsetVector = Arrays.ensureCapacity(this.dictionaryOffsetVector, this.stripeDictionarySize + rowGroupDictionarySize + 2, Arrays.ExpansionFactor.MEDIUM, Arrays.ExpansionOption.PRESERVE);
            this.dictionaryWrapped = false;
            ByteArrayInputStream dictionaryDataStream = this.rowGroupDictionaryDataStreamSource.openStream();
            SliceDictionarySelectiveReader.readDictionary(dictionaryDataStream, rowGroupDictionarySize, this.rowGroupDictionaryLength, this.stripeDictionarySize, this.dictionaryData, this.dictionaryOffsetVector, this.maxCodePointCount, this.isCharType);
            this.currentDictionarySize = this.stripeDictionarySize + rowGroupDictionarySize + 1;
            this.initiateEvaluationStatus(this.stripeDictionarySize + rowGroupDictionarySize + 1);
        } else {
            this.currentDictionarySize = this.stripeDictionarySize + 1;
            this.initiateEvaluationStatus(this.stripeDictionarySize + 1);
        }
        this.dictionaryOffsetVector[this.currentDictionarySize] = this.dictionaryOffsetVector[this.currentDictionarySize - 1];
        this.stripeDictionaryOpen = true;
        this.presentStream = this.presentStreamSource.openStream();
        this.inDictionaryStream = this.inDictionaryStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private static void readDictionary(@Nullable ByteArrayInputStream dictionaryDataStream, int dictionarySize, int[] dictionaryLengthVector, int offsetVectorOffset, byte[] data, int[] offsetVector, int maxCodePointCount, boolean isCharType) throws IOException {
        Slice slice = Slices.wrappedBuffer((byte[])data);
        if (offsetVectorOffset == 0) {
            offsetVector[0] = 0;
        }
        for (int i = 0; i < dictionarySize; ++i) {
            int truncatedLength;
            int offsetIndex = offsetVectorOffset + i;
            int offset = offsetVector[offsetIndex];
            int length = dictionaryLengthVector[i];
            if (length > 0) {
                dictionaryDataStream.next(data, offset, offset + length);
                truncatedLength = SliceSelectiveStreamReader.computeTruncatedLength(slice, offset, length, maxCodePointCount, isCharType);
                Verify.verify((truncatedLength >= 0 ? 1 : 0) != 0);
            } else {
                truncatedLength = 0;
            }
            offsetVector[offsetIndex + 1] = offsetVector[offsetIndex] + truncatedLength;
        }
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, Map<Integer, ColumnEncoding> encoding) {
        this.stripeDictionaryDataStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, ByteArrayInputStream.class);
        this.stripeDictionaryLengthStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.stripeDictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getColumnEncoding(this.streamDescriptor.getSequence()).getDictionarySize();
        this.stripeDictionaryOpen = false;
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.rowGroupDictionaryLengthStreamSource = MissingInputStreamSource.missingStreamSource(RowGroupDictionaryLengthInputStream.class);
        this.rowGroupDictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.inDictionaryStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.IN_DICTIONARY, BooleanInputStream.class);
        this.rowGroupDictionaryLengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH, RowGroupDictionaryLengthInputStream.class);
        this.rowGroupDictionaryDataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY, ByteArrayInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void close() {
        this.dictionary = null;
        this.dictionaryData = null;
        this.dictionaryOffsetVector = null;
        this.rowGroupDictionaryLength = null;
        this.stripeDictionaryLength = null;
        this.values = null;
        this.outputPositions = null;
        this.systemMemoryContext.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.values) + SizeOf.sizeOf((byte[])this.dictionaryData) + SizeOf.sizeOf((int[])this.dictionaryOffsetVector) + SizeOf.sizeOf((int[])this.stripeDictionaryLength) + SizeOf.sizeOf((int[])this.rowGroupDictionaryLength) + SizeOf.sizeOf((byte[])this.evaluationStatus) + SizeOf.sizeOf((byte[])this.valueWithPadding) + this.dictionary.getRetainedSizeInBytes();
    }

    @VisibleForTesting
    public void resetDataStream() {
        this.dataStream = null;
    }

    private void initiateEvaluationStatus(int positionCount) {
        Verify.verify((positionCount > 0 ? 1 : 0) != 0);
        this.evaluationStatus = Arrays.ensureCapacity(this.evaluationStatus, positionCount - 1);
        java.util.Arrays.fill(this.evaluationStatus, 0, this.evaluationStatus.length, (byte)0);
    }

    private BlockLease newLease(Block block) {
        this.valuesInUse = true;
        return ClosingBlockLease.newLease((Block)block, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> {
            this.valuesInUse = false;
        }});
    }

    private Block getMaterializedBlock(int positionCount, long blockSizeInBytes, int nullCount) {
        byte[] sliceData = new byte[Math.toIntExact(blockSizeInBytes)];
        int[] offsetVector = new int[positionCount + 1];
        int currentOffset = 0;
        for (int i = 0; i < positionCount; ++i) {
            int id = this.values[i];
            int offset = this.dictionaryOffsetVector[id];
            int length = this.dictionaryOffsetVector[id + 1] - offset;
            System.arraycopy(this.dictionaryData, offset, sliceData, currentOffset, length);
            offsetVector[i + 1] = currentOffset += length;
        }
        if (nullCount > 0) {
            boolean[] isNullVector = new boolean[positionCount];
            for (int i = 0; i < positionCount; ++i) {
                if (this.values[i] != this.currentDictionarySize - 1) continue;
                isNullVector[i] = true;
            }
            return new VariableWidthBlock(positionCount, Slices.wrappedBuffer((byte[])sliceData), offsetVector, Optional.of(isNullVector));
        }
        return new VariableWidthBlock(positionCount, Slices.wrappedBuffer((byte[])sliceData), offsetVector, Optional.empty());
    }
}

