/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table;

import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.JsonParseException;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.RequestOptions;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.ExecutionEngine;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.StorageRequest;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.CloudTableClient;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.EntityResolver;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.QueryTableOperation;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TableDeserializer;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TableEntity;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TableEntitySerializer;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TableOperationType;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TableRequest;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TableRequestOptions;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TableResult;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TableServiceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import javax.xml.stream.XMLStreamException;

public class TableOperation {
    private TableEntity entity;
    private TableOperationType opType = null;
    private boolean echoContent;

    public static TableOperation delete(TableEntity entity) {
        Utility.assertNotNull("entity", entity);
        Utility.assertNotNullOrEmpty("entity etag", entity.getEtag());
        return new TableOperation(entity, TableOperationType.DELETE);
    }

    public static TableOperation insert(TableEntity entity) {
        return TableOperation.insert(entity, false);
    }

    public static TableOperation insert(TableEntity entity, boolean echoContent) {
        Utility.assertNotNull("entity", entity);
        return new TableOperation(entity, TableOperationType.INSERT, echoContent);
    }

    public static TableOperation insertOrMerge(TableEntity entity) {
        Utility.assertNotNull("entity", entity);
        return new TableOperation(entity, TableOperationType.INSERT_OR_MERGE);
    }

    public static TableOperation insertOrReplace(TableEntity entity) {
        Utility.assertNotNull("entity", entity);
        return new TableOperation(entity, TableOperationType.INSERT_OR_REPLACE);
    }

    public static TableOperation merge(TableEntity entity) {
        Utility.assertNotNull("entity", entity);
        Utility.assertNotNullOrEmpty("entity etag", entity.getEtag());
        return new TableOperation(entity, TableOperationType.MERGE);
    }

    public static TableOperation retrieve(String partitionKey, String rowKey, Class<? extends TableEntity> clazzType) {
        QueryTableOperation retOp = new QueryTableOperation(partitionKey, rowKey);
        retOp.setClazzType(clazzType);
        return retOp;
    }

    public static TableOperation retrieve(String partitionKey, String rowKey, EntityResolver<?> resolver) {
        QueryTableOperation retOp = new QueryTableOperation(partitionKey, rowKey);
        retOp.setResolver(resolver);
        return retOp;
    }

    public static TableOperation replace(TableEntity entity) {
        Utility.assertNotNullOrEmpty("entity etag", entity.getEtag());
        return new TableOperation(entity, TableOperationType.REPLACE);
    }

    protected TableOperation() {
    }

    protected TableOperation(TableEntity entity, TableOperationType opType) {
        this(entity, opType, false);
    }

    protected TableOperation(TableEntity entity, TableOperationType opType, boolean echoContent) {
        this.entity = entity;
        this.opType = opType;
        this.echoContent = echoContent;
    }

    private TableResult performDelete(CloudTableClient client, String tableName, TableRequestOptions options, OperationContext opContext) throws StorageException {
        return ExecutionEngine.executeWithRetry(client, this, this.deleteImpl(client, tableName, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudTableClient, TableOperation, TableResult> deleteImpl(CloudTableClient client, final String tableName, final TableRequestOptions options, final OperationContext opContext) throws StorageException {
        String tableIdentity;
        final boolean isTableEntry = "Tables".equals(tableName);
        String string = tableIdentity = isTableEntry ? this.getEntity().writeEntity(opContext).get("TableName").getValueAsString() : null;
        if (!isTableEntry) {
            Utility.assertNotNullOrEmpty("Delete requires a valid ETag (which may be the '*' wildcard).", this.getEntity().getEtag());
            Utility.assertNotNull("Delete requires a partition key.", this.getEntity().getPartitionKey());
            Utility.assertNotNull("Delete requires a row key.", this.getEntity().getRowKey());
        }
        StorageRequest<CloudTableClient, TableOperation, TableResult> deleteRequest = new StorageRequest<CloudTableClient, TableOperation, TableResult>((RequestOptions)options, client.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudTableClient client, TableOperation operation, OperationContext context) throws Exception {
                return TableRequest.delete(client.getTransformedEndPoint(context).getUri(this.getCurrentLocation()), options, null, context, tableName, TableOperation.this.generateRequestIdentity(isTableEntry, tableIdentity, false), operation.getEntity().getEtag());
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                StorageRequest.signTableRequest(connection, client, -1L, context);
            }

            @Override
            public TableResult preProcessResponse(TableOperation operation, CloudTableClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() == 404 || this.getResult().getStatusCode() == 409) {
                    throw TableServiceException.generateTableServiceException(false, this.getResult(), operation, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                }
                if (this.getResult().getStatusCode() != 204) {
                    throw TableServiceException.generateTableServiceException(true, this.getResult(), operation, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                }
                return operation.parseResponse(null, this.getResult().getStatusCode(), null, opContext, options);
            }
        };
        return deleteRequest;
    }

    private TableResult performInsert(CloudTableClient client, String tableName, TableRequestOptions options, OperationContext opContext) throws StorageException {
        return ExecutionEngine.executeWithRetry(client, this, this.insertImpl(client, tableName, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudTableClient, TableOperation, TableResult> insertImpl(CloudTableClient client, final String tableName, final TableRequestOptions options, final OperationContext opContext) throws StorageException {
        String tableIdentity;
        final boolean isTableEntry = "Tables".equals(tableName);
        String string = tableIdentity = isTableEntry ? this.getEntity().writeEntity(opContext).get("TableName").getValueAsString() : null;
        if (!isTableEntry) {
            Utility.assertNotNull("Insert requires a partition key.", this.getEntity().getPartitionKey());
            Utility.assertNotNull("Insert requires a row key.", this.getEntity().getRowKey());
        }
        ByteArrayOutputStream entityStream = new ByteArrayOutputStream();
        try {
            TableEntitySerializer.writeSingleEntityToStream(entityStream, options.getTablePayloadFormat(), this.entity, isTableEntry, opContext);
            final byte[] entityBytes = entityStream.toByteArray();
            StorageRequest<CloudTableClient, TableOperation, TableResult> putRequest = new StorageRequest<CloudTableClient, TableOperation, TableResult>((RequestOptions)options, client.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(CloudTableClient client, TableOperation operation, OperationContext context) throws Exception {
                    this.setSendStream(new ByteArrayInputStream(entityBytes));
                    this.setLength(Long.valueOf(entityBytes.length));
                    return TableRequest.insert(client.getTransformedEndPoint(opContext).getUri(this.getCurrentLocation()), options, null, opContext, tableName, TableOperation.this.generateRequestIdentity(isTableEntry, tableIdentity, false), operation.opType != TableOperationType.INSERT ? operation.getEntity().getEtag() : null, operation.getEchoContent(), operation.opType.getUpdateType());
                }

                @Override
                public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                    StorageRequest.signTableRequest(connection, client, -1L, opContext);
                }

                @Override
                public TableResult preProcessResponse(TableOperation operation, CloudTableClient client, OperationContext context) throws Exception {
                    if (operation.opType == TableOperationType.INSERT) {
                        if (operation.getEchoContent()) {
                            if (this.getResult().getStatusCode() == 201) {
                                return new TableResult();
                            }
                            if (this.getResult().getStatusCode() == 409) {
                                throw TableServiceException.generateTableServiceException(false, this.getResult(), operation, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                            }
                            throw TableServiceException.generateTableServiceException(true, this.getResult(), operation, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                        }
                        if (this.getResult().getStatusCode() == 204) {
                            return operation.parseResponse(null, this.getResult().getStatusCode(), this.getConnection().getHeaderField("ETag"), opContext, options);
                        }
                        if (this.getResult().getStatusCode() == 409) {
                            throw TableServiceException.generateTableServiceException(false, this.getResult(), operation, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                        }
                        throw TableServiceException.generateTableServiceException(true, this.getResult(), operation, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                    }
                    if (this.getResult().getStatusCode() == 204) {
                        return operation.parseResponse(null, this.getResult().getStatusCode(), this.getConnection().getHeaderField("ETag"), opContext, options);
                    }
                    throw TableServiceException.generateTableServiceException(true, this.getResult(), operation, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                }

                @Override
                public TableResult postProcessResponse(HttpURLConnection connection, TableOperation operation, CloudTableClient client, OperationContext context, TableResult result) throws Exception {
                    if (operation.opType == TableOperationType.INSERT && operation.getEchoContent()) {
                        result = operation.parseResponse(this.getConnection().getInputStream(), this.getResult().getStatusCode(), this.getConnection().getHeaderField("ETag"), opContext, options);
                    }
                    return result;
                }
            };
            return putRequest;
        }
        catch (XMLStreamException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (IOException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
    }

    private TableResult performMerge(CloudTableClient client, String tableName, TableRequestOptions options, OperationContext opContext) throws StorageException {
        return ExecutionEngine.executeWithRetry(client, this, this.mergeImpl(client, tableName, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudTableClient, TableOperation, TableResult> mergeImpl(CloudTableClient client, final String tableName, final TableRequestOptions options, final OperationContext opContext) throws StorageException {
        Utility.assertNotNullOrEmpty("Merge requires a valid ETag (which may be the '*' wildcard).", this.getEntity().getEtag());
        Utility.assertNotNull("Merge requires a partition key.", this.getEntity().getPartitionKey());
        Utility.assertNotNull("Merge requires a row key.", this.getEntity().getRowKey());
        ByteArrayOutputStream entityStream = new ByteArrayOutputStream();
        try {
            TableEntitySerializer.writeSingleEntityToStream(entityStream, options.getTablePayloadFormat(), this.getEntity(), false, opContext);
            final byte[] entityBytes = entityStream.toByteArray();
            StorageRequest<CloudTableClient, TableOperation, TableResult> putRequest = new StorageRequest<CloudTableClient, TableOperation, TableResult>((RequestOptions)options, client.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(CloudTableClient client, TableOperation operation, OperationContext context) throws Exception {
                    this.setSendStream(new ByteArrayInputStream(entityBytes));
                    this.setLength(Long.valueOf(entityBytes.length));
                    return TableRequest.merge(client.getTransformedEndPoint(opContext).getUri(this.getCurrentLocation()), options, null, opContext, tableName, TableOperation.this.generateRequestIdentity(false, null, false), operation.getEntity().getEtag());
                }

                @Override
                public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                    StorageRequest.signTableRequest(connection, client, -1L, opContext);
                }

                @Override
                public TableResult preProcessResponse(TableOperation operation, CloudTableClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() == 404 || this.getResult().getStatusCode() == 409) {
                        throw TableServiceException.generateTableServiceException(false, this.getResult(), operation, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                    }
                    if (this.getResult().getStatusCode() == 204) {
                        return operation.parseResponse(null, this.getResult().getStatusCode(), this.getConnection().getHeaderField("ETag"), opContext, options);
                    }
                    throw TableServiceException.generateTableServiceException(true, this.getResult(), operation, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                }
            };
            return putRequest;
        }
        catch (XMLStreamException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (IOException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
    }

    private TableResult performUpdate(CloudTableClient client, String tableName, TableRequestOptions options, OperationContext opContext) throws StorageException {
        return ExecutionEngine.executeWithRetry(client, this, this.updateImpl(client, tableName, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudTableClient, TableOperation, TableResult> updateImpl(CloudTableClient client, final String tableName, final TableRequestOptions options, final OperationContext opContext) throws StorageException {
        Utility.assertNotNullOrEmpty("Replace requires a valid ETag (which may be the '*' wildcard).", this.getEntity().getEtag());
        Utility.assertNotNull("Replace requires a partition key.", this.getEntity().getPartitionKey());
        Utility.assertNotNull("Replace requires a row key.", this.getEntity().getRowKey());
        ByteArrayOutputStream entityStream = new ByteArrayOutputStream();
        try {
            TableEntitySerializer.writeSingleEntityToStream(entityStream, options.getTablePayloadFormat(), this.getEntity(), false, opContext);
            final byte[] entityBytes = entityStream.toByteArray();
            StorageRequest<CloudTableClient, TableOperation, TableResult> putRequest = new StorageRequest<CloudTableClient, TableOperation, TableResult>((RequestOptions)options, client.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(CloudTableClient client, TableOperation operation, OperationContext context) throws Exception {
                    this.setSendStream(new ByteArrayInputStream(entityBytes));
                    this.setLength(Long.valueOf(entityBytes.length));
                    return TableRequest.update(client.getTransformedEndPoint(context).getUri(this.getCurrentLocation()), options, null, context, tableName, TableOperation.this.generateRequestIdentity(false, null, false), operation.getEntity().getEtag());
                }

                @Override
                public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                    StorageRequest.signTableRequest(connection, client, -1L, opContext);
                }

                @Override
                public TableResult preProcessResponse(TableOperation operation, CloudTableClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() == 404 || this.getResult().getStatusCode() == 409) {
                        throw TableServiceException.generateTableServiceException(false, this.getResult(), operation, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                    }
                    if (this.getResult().getStatusCode() == 204) {
                        return operation.parseResponse(null, this.getResult().getStatusCode(), this.getConnection().getHeaderField("ETag"), opContext, options);
                    }
                    throw TableServiceException.generateTableServiceException(true, this.getResult(), operation, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                }
            };
            return putRequest;
        }
        catch (XMLStreamException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (IOException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
    }

    protected TableResult execute(CloudTableClient client, String tableName, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, client);
        Utility.assertNotNullOrEmpty("TableName", tableName);
        if (this.getOperationType() == TableOperationType.INSERT || this.getOperationType() == TableOperationType.INSERT_OR_MERGE || this.getOperationType() == TableOperationType.INSERT_OR_REPLACE) {
            return this.performInsert(client, tableName, options, opContext);
        }
        if (this.getOperationType() == TableOperationType.DELETE) {
            return this.performDelete(client, tableName, options, opContext);
        }
        if (this.getOperationType() == TableOperationType.MERGE) {
            return this.performMerge(client, tableName, options, opContext);
        }
        if (this.getOperationType() == TableOperationType.REPLACE) {
            return this.performUpdate(client, tableName, options, opContext);
        }
        if (this.getOperationType() == TableOperationType.RETRIEVE) {
            return ((QueryTableOperation)this).performRetrieve(client, tableName, options, opContext);
        }
        throw new IllegalArgumentException("Unknown table operation.");
    }

    protected String generateRequestIdentity(boolean isSingleIndexEntry, String entryName, boolean encodeKeys) throws StorageException {
        if (isSingleIndexEntry) {
            return String.format("'%s'", entryName);
        }
        if (this.opType == TableOperationType.INSERT) {
            return "";
        }
        String pk = null;
        String rk = null;
        if (this.opType == TableOperationType.RETRIEVE) {
            QueryTableOperation qOp = (QueryTableOperation)this;
            pk = qOp.getPartitionKey();
            rk = qOp.getRowKey();
        } else {
            pk = this.getEntity().getPartitionKey();
            rk = this.getEntity().getRowKey();
        }
        return String.format("%s='%s',%s='%s'", "PartitionKey", encodeKeys ? Utility.safeEncode(pk) : pk, "RowKey", encodeKeys ? Utility.safeEncode(rk) : rk);
    }

    protected String generateRequestIdentityWithTable(String tableName) throws StorageException {
        return String.format("%s(%s)", tableName, this.generateRequestIdentity(false, null, false));
    }

    protected final synchronized TableEntity getEntity() {
        return this.entity;
    }

    protected final synchronized TableOperationType getOperationType() {
        return this.opType;
    }

    protected TableResult parseResponse(InputStream inStream, int httpStatusCode, String etagFromHeader, OperationContext opContext, TableRequestOptions options) throws XMLStreamException, InstantiationException, IllegalAccessException, StorageException, JsonParseException, IOException {
        TableResult resObj;
        if (this.opType == TableOperationType.INSERT && this.echoContent) {
            resObj = TableDeserializer.parseSingleOpResponse(inStream, options, httpStatusCode, null, null, opContext);
            resObj.setEtag(etagFromHeader);
            resObj.updateResultObject(this.getEntity());
        } else {
            resObj = new TableResult(httpStatusCode);
            resObj.setResult(this.getEntity());
            if (this.opType != TableOperationType.DELETE && etagFromHeader != null) {
                resObj.setEtag(etagFromHeader);
                resObj.updateResultObject(this.getEntity());
            }
        }
        return resObj;
    }

    protected final synchronized void setEntity(TableEntity entity) {
        this.entity = entity;
    }

    protected boolean getEchoContent() {
        return this.echoContent;
    }

    protected void setEchoContent(boolean echoContent) {
        this.echoContent = echoContent;
    }
}

