/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bytecode;

import com.facebook.airlift.bytecode.ClassDefinition;
import com.facebook.airlift.bytecode.ClassInfo;
import com.facebook.airlift.bytecode.ParameterizedType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.CheckClassAdapter;

public class ClassInfoLoader {
    private final Map<ParameterizedType, ClassNode> classNodes;
    private final Map<ParameterizedType, byte[]> bytecodes;
    private final ClassLoader classLoader;
    private final Map<ParameterizedType, ClassInfo> classInfoCache = new HashMap<ParameterizedType, ClassInfo>();
    private final boolean loadMethodNodes;

    public static ClassInfoLoader createClassInfoLoader(Iterable<ClassDefinition> classDefinitions, ClassLoader classLoader) {
        ImmutableMap.Builder classNodes = ImmutableMap.builder();
        for (ClassDefinition classDefinition : classDefinitions) {
            ClassNode classNode = new ClassNode();
            classDefinition.visit((ClassVisitor)classNode);
            classNodes.put((Object)classDefinition.getType(), (Object)classNode);
        }
        return new ClassInfoLoader((Map<ParameterizedType, ClassNode>)classNodes.build(), (Map<ParameterizedType, byte[]>)ImmutableMap.of(), classLoader, true);
    }

    public ClassInfoLoader(Map<ParameterizedType, ClassNode> classNodes, Map<ParameterizedType, byte[]> bytecodes, ClassLoader classLoader, boolean loadMethodNodes) {
        this.classNodes = ImmutableMap.copyOf(classNodes);
        this.bytecodes = ImmutableMap.copyOf(bytecodes);
        this.classLoader = classLoader;
        this.loadMethodNodes = loadMethodNodes;
    }

    public ClassInfo loadClassInfo(ParameterizedType type) {
        ClassInfo classInfo = this.classInfoCache.get(type);
        if (classInfo == null) {
            classInfo = this.readClassInfoQuick(type);
            this.classInfoCache.put(type, classInfo);
        }
        return classInfo;
    }

    private ClassInfo readClassInfoQuick(ParameterizedType type) {
        ClassReader classReader;
        ClassNode classNode = this.classNodes.get(type);
        if (classNode != null) {
            return new ClassInfo(this, classNode);
        }
        byte[] bytecode = this.bytecodes.get(type);
        if (bytecode != null) {
            classReader = new ClassReader(bytecode);
        } else {
            String classFileName = type.getClassName() + ".class";
            try (InputStream is = this.classLoader.getResourceAsStream(classFileName);){
                classReader = new ClassReader(is);
            }
            catch (IOException e) {
                try {
                    Class<?> aClass = this.classLoader.loadClass(type.getJavaClassName());
                    return new ClassInfo(this, aClass);
                }
                catch (ClassNotFoundException e1) {
                    throw new RuntimeException("Class not found " + type, e);
                }
            }
        }
        if (this.loadMethodNodes) {
            classNode = new ClassNode();
            classReader.accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)classNode, false), 2);
            return new ClassInfo(this, classNode);
        }
        int header = classReader.header;
        int access = classReader.readUnsignedShort(header);
        char[] buf = new char[2048];
        int superClassIndex = classReader.getItem(classReader.readUnsignedShort(header + 4));
        ParameterizedType superClass = superClassIndex == 0 ? null : ParameterizedType.typeFromPathName(classReader.readUTF8(superClassIndex, buf));
        int interfaceCount = classReader.readUnsignedShort(header + 6);
        ImmutableList.Builder interfaces = ImmutableList.builder();
        header += 8;
        for (int i = 0; i < interfaceCount; ++i) {
            interfaces.add((Object)ParameterizedType.typeFromPathName(classReader.readClass(header, buf)));
            header += 2;
        }
        return new ClassInfo(this, type, access, superClass, (Iterable<ParameterizedType>)interfaces.build(), null);
    }
}

