/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class RaptorTableProperties {
    public static final String ORDERING_PROPERTY = "ordering";
    public static final String TEMPORAL_COLUMN_PROPERTY = "temporal_column";
    public static final String BUCKET_COUNT_PROPERTY = "bucket_count";
    public static final String BUCKETED_ON_PROPERTY = "bucketed_on";
    public static final String DISTRIBUTION_NAME_PROPERTY = "distribution_name";
    public static final String ORGANIZED_PROPERTY = "organized";
    public static final String TABLE_SUPPORTS_DELTA_DELETE = "table_supports_delta_delete";
    private final List<PropertyMetadata<?>> tableProperties;

    @Inject
    public RaptorTableProperties(TypeManager typeManager) {
        this.tableProperties = ImmutableList.builder().add(RaptorTableProperties.stringListSessionProperty(typeManager, ORDERING_PROPERTY, "Sort order for each shard of the table")).add(RaptorTableProperties.lowerCaseStringSessionProperty(TEMPORAL_COLUMN_PROPERTY, "Temporal column of the table")).add((Object)PropertyMetadata.integerProperty((String)BUCKET_COUNT_PROPERTY, (String)"Number of buckets into which to divide the table", null, (boolean)false)).add(RaptorTableProperties.stringListSessionProperty(typeManager, BUCKETED_ON_PROPERTY, "Table columns on which to bucket the table")).add(RaptorTableProperties.lowerCaseStringSessionProperty(DISTRIBUTION_NAME_PROPERTY, "Shared distribution name for colocated tables")).add((Object)PropertyMetadata.booleanProperty((String)ORGANIZED_PROPERTY, (String)"Keep the table organized using the sort order", null, (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)TABLE_SUPPORTS_DELTA_DELETE, (String)"Support delta delete on the table", null, (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static List<String> getSortColumns(Map<String, Object> tableProperties) {
        return RaptorTableProperties.stringList(tableProperties.get(ORDERING_PROPERTY));
    }

    public static String getTemporalColumn(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(TEMPORAL_COLUMN_PROPERTY);
    }

    public static OptionalInt getBucketCount(Map<String, Object> tableProperties) {
        Integer value = (Integer)tableProperties.get(BUCKET_COUNT_PROPERTY);
        return value != null ? OptionalInt.of(value) : OptionalInt.empty();
    }

    public static List<String> getBucketColumns(Map<String, Object> tableProperties) {
        return RaptorTableProperties.stringList(tableProperties.get(BUCKETED_ON_PROPERTY));
    }

    public static String getDistributionName(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(DISTRIBUTION_NAME_PROPERTY);
    }

    public static boolean isOrganized(Map<String, Object> tableProperties) {
        Boolean value = (Boolean)tableProperties.get(ORGANIZED_PROPERTY);
        return value == null ? false : value;
    }

    public static boolean isTableSupportsDeltaDelete(Map<String, Object> tableProperties) {
        Boolean value = (Boolean)tableProperties.get(TABLE_SUPPORTS_DELTA_DELETE);
        return value == null ? false : value;
    }

    public static PropertyMetadata<String> lowerCaseStringSessionProperty(String name, String description) {
        return new PropertyMetadata(name, description, (Type)VarcharType.createUnboundedVarcharType(), String.class, null, false, value -> ((String)value).toLowerCase(Locale.ENGLISH), value -> value);
    }

    private static PropertyMetadata<?> stringListSessionProperty(TypeManager typeManager, String name, String description) {
        return new PropertyMetadata(name, description, typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)VarcharType.createUnboundedVarcharType().getTypeSignature()))), List.class, (Object)ImmutableList.of(), false, value -> ImmutableList.copyOf((Collection)RaptorTableProperties.stringList(value).stream().map(s -> s.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())), value -> value);
    }

    private static List<String> stringList(Object value) {
        return value == null ? ImmutableList.of() : (List)value;
    }
}

