/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.filesystem;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.cache.CacheManager;
import com.facebook.presto.cache.ForCachingFileSystem;
import com.facebook.presto.cache.filemerge.FileMergeCachingFileSystem;
import com.facebook.presto.hadoop.FileSystemFactory;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.raptor.filesystem.FileSystemUtil;
import com.facebook.presto.raptor.filesystem.RaptorHdfsConfiguration;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

public class RaptorCachingHdfsConfiguration
implements RaptorHdfsConfiguration {
    private final RaptorHdfsConfiguration hiveHdfsConfiguration;
    private final CacheManager cacheManager;
    private final boolean cacheValidationEnabled;

    @Inject
    public RaptorCachingHdfsConfiguration(@ForCachingFileSystem RaptorHdfsConfiguration hiveHdfsConfiguration, CacheConfig cacheConfig, CacheManager cacheManager) {
        this.hiveHdfsConfiguration = Objects.requireNonNull(hiveHdfsConfiguration, "hiveHdfsConfiguration is null");
        this.cacheManager = Objects.requireNonNull(cacheManager, "CacheManager is null");
        this.cacheValidationEnabled = Objects.requireNonNull(cacheConfig, "cacheConfig is null").isValidationEnabled();
    }

    @Override
    public Configuration getConfiguration(HdfsContext context, URI uri) {
        CachingJobConf config = new CachingJobConf((factoryConfig, factoryUri) -> {
            try {
                FileSystem fileSystem = new Path(factoryUri).getFileSystem(this.hiveHdfsConfiguration.getConfiguration(context, (URI)factoryUri));
                Preconditions.checkState((boolean)(fileSystem instanceof ExtendedFileSystem));
                return new FileMergeCachingFileSystem(factoryUri, factoryConfig, this.cacheManager, (ExtendedFileSystem)fileSystem, this.cacheValidationEnabled);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "cannot create caching FS", (Throwable)e);
            }
        });
        Configuration defaultConfig = this.hiveHdfsConfiguration.getConfiguration(context, uri);
        FileSystemUtil.copy(defaultConfig, (Configuration)config);
        return config;
    }

    private static class CachingJobConf
    extends JobConf
    implements FileSystemFactory {
        private final BiFunction<Configuration, URI, FileSystem> factory;

        public CachingJobConf(BiFunction<Configuration, URI, FileSystem> factory) {
            super(false);
            this.factory = Objects.requireNonNull(factory, "factory is null");
        }

        public FileSystem createFileSystem(URI uri) {
            return this.factory.apply((Configuration)this, uri);
        }
    }
}

