/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.metadata.BucketShards;
import com.facebook.presto.raptor.metadata.DatabaseShardManager;
import com.facebook.presto.raptor.metadata.RaptorNode;
import com.facebook.presto.raptor.metadata.ShardDao;
import com.facebook.presto.raptor.metadata.ShardNodes;
import com.facebook.presto.raptor.metadata.ShardPredicate;
import com.facebook.presto.raptor.util.ArrayUtil;
import com.facebook.presto.raptor.util.DatabaseUtil;
import com.facebook.presto.raptor.util.UuidUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.ResultIterator;

final class ShardIterator
extends AbstractIterator<BucketShards>
implements ResultIterator<BucketShards> {
    private static final Logger log = Logger.get(ShardIterator.class);
    private final Map<Integer, String> nodeMap = new HashMap<Integer, String>();
    private final boolean merged;
    private final boolean tableSupportsDeltaDelete;
    private final List<String> bucketToNode;
    private final ShardDao dao;
    private final Connection connection;
    private final PreparedStatement statement;
    private final ResultSet resultSet;
    private boolean first = true;

    public ShardIterator(long tableId, boolean merged, boolean tableSupportsDeltaDelete, Optional<List<String>> bucketToNode, TupleDomain<RaptorColumnHandle> effectivePredicate, IDBI dbi) {
        this.merged = merged;
        this.tableSupportsDeltaDelete = tableSupportsDeltaDelete;
        this.bucketToNode = bucketToNode.orElse(null);
        ShardPredicate predicate = ShardPredicate.create(effectivePredicate);
        String sql = "SELECT shard_uuid, " + (tableSupportsDeltaDelete ? "delta_shard_uuid, " : "") + (bucketToNode.isPresent() ? "bucket_number " : "node_ids ") + "FROM %s WHERE %s " + (bucketToNode.isPresent() ? "ORDER BY bucket_number" : "");
        sql = String.format(sql, DatabaseShardManager.shardIndexTable(tableId), predicate.getPredicate());
        this.dao = DatabaseUtil.onDemandDao(dbi, ShardDao.class);
        this.fetchNodes();
        try {
            this.connection = dbi.open().getConnection();
            this.statement = this.connection.prepareStatement(sql);
            DatabaseUtil.enableStreamingResults(this.statement);
            predicate.bind(this.statement);
            log.debug("Running query: %s", new Object[]{this.statement});
            this.resultSet = this.statement.executeQuery();
        }
        catch (SQLException e) {
            throw DatabaseUtil.metadataError(e);
        }
        finally {
            this.close();
        }
    }

    protected BucketShards computeNext() {
        try {
            return this.merged ? this.computeMerged() : this.compute();
        }
        catch (SQLException e) {
            throw DatabaseUtil.metadataError(e);
        }
    }

    public void close() {
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;){
            ResultSet resultSet = this.resultSet;
            Throwable throwable = null;
            if (resultSet != null) {
                if (throwable != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private BucketShards compute() throws SQLException {
        ImmutableSet nodeIdentifiers;
        if (!this.resultSet.next()) {
            return (BucketShards)this.endOfData();
        }
        UUID shardUuid = UuidUtil.uuidFromBytes(this.resultSet.getBytes("shard_uuid"));
        Optional<UUID> deltaShardUuid = this.getDeltaShardUuidFromResultSet();
        OptionalInt bucketNumber = OptionalInt.empty();
        if (this.bucketToNode != null) {
            int bucket = this.resultSet.getInt("bucket_number");
            bucketNumber = OptionalInt.of(bucket);
            nodeIdentifiers = ImmutableSet.of((Object)this.getBucketNode(bucket));
        } else {
            List<Integer> nodeIds = ArrayUtil.intArrayFromBytes(this.resultSet.getBytes("node_ids"));
            nodeIdentifiers = this.getNodeIdentifiers(nodeIds, shardUuid);
        }
        ShardNodes shard = new ShardNodes(shardUuid, deltaShardUuid, (Set<String>)nodeIdentifiers);
        return new BucketShards(bucketNumber, (Set<ShardNodes>)ImmutableSet.of((Object)shard));
    }

    private BucketShards computeMerged() throws SQLException {
        if (this.resultSet.isAfterLast()) {
            return (BucketShards)this.endOfData();
        }
        if (this.first) {
            this.first = false;
            if (!this.resultSet.next()) {
                return (BucketShards)this.endOfData();
            }
        }
        int bucketNumber = this.resultSet.getInt("bucket_number");
        ImmutableSet.Builder shards = ImmutableSet.builder();
        do {
            UUID shardUuid = UuidUtil.uuidFromBytes(this.resultSet.getBytes("shard_uuid"));
            Optional<UUID> deltaShardUuid = this.getDeltaShardUuidFromResultSet();
            int bucket = this.resultSet.getInt("bucket_number");
            ImmutableSet nodeIdentifiers = ImmutableSet.of((Object)this.getBucketNode(bucket));
            shards.add((Object)new ShardNodes(shardUuid, deltaShardUuid, (Set<String>)nodeIdentifiers));
        } while (this.resultSet.next() && this.resultSet.getInt("bucket_number") == bucketNumber);
        return new BucketShards(OptionalInt.of(bucketNumber), (Set<ShardNodes>)shards.build());
    }

    private String getBucketNode(int bucket) {
        String node = this.bucketToNode.get(bucket);
        if (node == null) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "No node mapping for bucket: " + bucket);
        }
        return node;
    }

    private Set<String> getNodeIdentifiers(List<Integer> nodeIds, UUID shardUuid) {
        Function<Integer, String> fetchNode = id -> this.fetchNode((int)id, shardUuid);
        return nodeIds.stream().map(id -> this.nodeMap.computeIfAbsent((Integer)id, fetchNode)).collect(Collectors.toSet());
    }

    private String fetchNode(int id, UUID shardUuid) {
        String node = this.dao.getNodeIdentifier(id);
        if (node == null) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, String.format("Missing node ID [%s] for shard: %s", id, shardUuid));
        }
        return node;
    }

    private void fetchNodes() {
        for (RaptorNode node : this.dao.getNodes()) {
            this.nodeMap.put(node.getNodeId(), node.getNodeIdentifier());
        }
    }

    private Optional<UUID> getDeltaShardUuidFromResultSet() throws SQLException {
        if (this.tableSupportsDeltaDelete && this.resultSet.getBytes("delta_shard_uuid") != null) {
            return Optional.of(UuidUtil.uuidFromBytes(this.resultSet.getBytes("delta_shard_uuid")));
        }
        return Optional.empty();
    }
}

