/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.raptor.metadata.DatabaseShardManager;
import com.facebook.presto.raptor.metadata.ShardsAndIndexDeleter;
import com.facebook.presto.raptor.util.UuidUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;

public class ShardsAndIndexUpdater
implements AutoCloseable {
    private static final Logger log = Logger.get(ShardsAndIndexUpdater.class);
    private final PreparedStatement updateShardEmptyDeltaStatement;
    private final PreparedStatement updateShardStatement;
    private final PreparedStatement updateIndexEmptyDeltaStatement;
    private final PreparedStatement updateIndexStatement;

    public ShardsAndIndexUpdater(Connection connection, long tableId) throws SQLException {
        String updateIndexSqlEmptyDelta = "UPDATE " + DatabaseShardManager.shardIndexTable(tableId) + " SET \n  delta_shard_uuid = ?\n  WHERE shard_id = ? AND delta_shard_uuid IS NULL";
        String updateIndexSql = "UPDATE " + DatabaseShardManager.shardIndexTable(tableId) + " SET \n  delta_shard_uuid = ?\n  WHERE shard_id = ? AND delta_shard_uuid = ?";
        String updateShardSqlEmptyDelta = "UPDATE shards SET \n  delta_uuid = ?\n  WHERE shard_id = ? AND delta_uuid IS NULL";
        String updateShardSql = "UPDATE shards SET \n  delta_uuid = ?\n  WHERE shard_id = ? AND delta_uuid = ?";
        this.updateShardEmptyDeltaStatement = connection.prepareStatement(updateShardSqlEmptyDelta);
        this.updateIndexEmptyDeltaStatement = connection.prepareStatement(updateIndexSqlEmptyDelta);
        this.updateShardStatement = connection.prepareStatement(updateShardSql);
        this.updateIndexStatement = connection.prepareStatement(updateIndexSql);
    }

    public void update(long oldId, Optional<UUID> oldUuid, UUID newUuid) throws SQLException {
        if (oldUuid.isPresent()) {
            this.updateShardStatement.setBytes(1, UuidUtil.uuidToBytes(newUuid));
            this.updateShardStatement.setLong(2, oldId);
            this.updateShardStatement.setBytes(3, UuidUtil.uuidToBytes(oldUuid.get()));
            this.updateShardStatement.addBatch();
            this.updateIndexStatement.setBytes(1, UuidUtil.uuidToBytes(newUuid));
            this.updateIndexStatement.setLong(2, oldId);
            this.updateIndexStatement.setBytes(3, UuidUtil.uuidToBytes(oldUuid.get()));
            this.updateIndexStatement.addBatch();
        } else {
            this.updateShardEmptyDeltaStatement.setBytes(1, UuidUtil.uuidToBytes(newUuid));
            this.updateShardEmptyDeltaStatement.setLong(2, oldId);
            this.updateShardEmptyDeltaStatement.addBatch();
            this.updateIndexEmptyDeltaStatement.setBytes(1, UuidUtil.uuidToBytes(newUuid));
            this.updateIndexEmptyDeltaStatement.setLong(2, oldId);
            this.updateIndexEmptyDeltaStatement.addBatch();
        }
    }

    public int execute() throws SQLException {
        int shardsUpdatedCount = 0;
        int indexUpdatedCount = 0;
        shardsUpdatedCount += ShardsAndIndexDeleter.updatedCount(this.updateShardStatement.executeBatch());
        indexUpdatedCount += ShardsAndIndexDeleter.updatedCount(this.updateIndexStatement.executeBatch());
        log.info("ShardsAndIndexUpdater shardsUpdatedCount:" + (shardsUpdatedCount += ShardsAndIndexDeleter.updatedCount(this.updateShardEmptyDeltaStatement.executeBatch())));
        log.info("ShardsAndIndexUpdater indexUpdatedCount:" + (indexUpdatedCount += ShardsAndIndexDeleter.updatedCount(this.updateIndexEmptyDeltaStatement.executeBatch())));
        if (shardsUpdatedCount != indexUpdatedCount) {
            throw DatabaseShardManager.transactionConflict();
        }
        return shardsUpdatedCount;
    }

    @Override
    public void close() throws SQLException {
        this.updateShardStatement.close();
        this.updateShardEmptyDeltaStatement.close();
        this.updateIndexStatement.close();
        this.updateIndexEmptyDeltaStatement.close();
    }
}

