/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.spi.SchemaTableName;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class ViewResult {
    private final SchemaTableName name;
    private final String data;

    public ViewResult(SchemaTableName name, String data) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.data = Objects.requireNonNull(data, "data is null");
    }

    public SchemaTableName getName() {
        return this.name;
    }

    public String getData() {
        return this.data;
    }

    public static class Mapper
    implements ResultSetMapper<ViewResult> {
        public ViewResult map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            SchemaTableName name = new SchemaTableName(r.getString("schema_name"), r.getString("table_name"));
            return new ViewResult(name, r.getString("data"));
        }
    }
}

