/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcWriterStats;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TupleDomainOrcPredicate;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.raptor.RaptorConnectorId;
import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.RaptorOrcAggregatedMemoryContext;
import com.facebook.presto.raptor.backup.BackupManager;
import com.facebook.presto.raptor.backup.BackupStore;
import com.facebook.presto.raptor.filesystem.FileSystemUtil;
import com.facebook.presto.raptor.metadata.ColumnInfo;
import com.facebook.presto.raptor.metadata.ColumnStats;
import com.facebook.presto.raptor.metadata.ShardInfo;
import com.facebook.presto.raptor.metadata.ShardRecorder;
import com.facebook.presto.raptor.storage.DeltaShardLoader;
import com.facebook.presto.raptor.storage.DeltaShardRewriter;
import com.facebook.presto.raptor.storage.FileWriter;
import com.facebook.presto.raptor.storage.InplaceShardRewriter;
import com.facebook.presto.raptor.storage.OrcDataEnvironment;
import com.facebook.presto.raptor.storage.OrcFileInfo;
import com.facebook.presto.raptor.storage.OrcFileMetadata;
import com.facebook.presto.raptor.storage.OrcFileRewriter;
import com.facebook.presto.raptor.storage.OrcFileWriter;
import com.facebook.presto.raptor.storage.OrcPageSource;
import com.facebook.presto.raptor.storage.OrcUpdatablePageSource;
import com.facebook.presto.raptor.storage.ReaderAttributes;
import com.facebook.presto.raptor.storage.ShardRecoveryManager;
import com.facebook.presto.raptor.storage.ShardRewriter;
import com.facebook.presto.raptor.storage.ShardStats;
import com.facebook.presto.raptor.storage.StorageManager;
import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.facebook.presto.raptor.storage.StoragePageSink;
import com.facebook.presto.raptor.storage.StorageService;
import com.facebook.presto.raptor.storage.StorageTypeConverter;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;

public class OrcStorageManager
implements StorageManager {
    public static final DateTimeZone DEFAULT_STORAGE_TIMEZONE = DateTimeZone.UTC;
    public static final DataSize HUGE_MAX_READ_BLOCK_SIZE = new DataSize(1.0, DataSize.Unit.PETABYTE);
    private static final long MAX_ROWS = 1000000000L;
    private static final JsonCodec<OrcFileMetadata> METADATA_CODEC = JsonCodec.jsonCodec(OrcFileMetadata.class);
    private final String nodeId;
    private final StorageService storageService;
    private final Optional<BackupStore> backupStore;
    private final ReaderAttributes defaultReaderAttributes;
    private final BackupManager backupManager;
    private final ShardRecoveryManager recoveryManager;
    private final ShardRecorder shardRecorder;
    private final Duration recoveryTimeout;
    private final long maxShardRows;
    private final DataSize maxShardSize;
    private final DataSize minAvailableSpace;
    private final CompressionKind compression;
    private final StorageManagerConfig.OrcOptimizedWriterStage orcOptimizedWriterStage;
    private final TypeManager typeManager;
    private final ExecutorService deletionExecutor;
    private final ExecutorService commitExecutor;
    private final OrcDataEnvironment orcDataEnvironment;
    private final OrcFileRewriter fileRewriter;
    private final OrcWriterStats stats = new OrcWriterStats();
    private final OrcFileTailSource orcFileTailSource;
    private final StripeMetadataSource stripeMetadataSource;

    @Inject
    public OrcStorageManager(NodeManager nodeManager, StorageService storageService, Optional<BackupStore> backupStore, ReaderAttributes readerAttributes, StorageManagerConfig config, RaptorConnectorId connectorId, BackupManager backgroundBackupManager, ShardRecoveryManager recoveryManager, ShardRecorder shardRecorder, TypeManager typeManager, OrcDataEnvironment orcDataEnvironment, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource) {
        this(nodeManager.getCurrentNode().getNodeIdentifier(), storageService, backupStore, readerAttributes, backgroundBackupManager, recoveryManager, shardRecorder, typeManager, orcDataEnvironment, connectorId.toString(), config.getDeletionThreads(), config.getShardRecoveryTimeout(), config.getMaxShardRows(), config.getMaxShardSize(), config.getMinAvailableSpace(), config.getOrcCompressionKind(), config.getOrcOptimizedWriterStage(), orcFileTailSource, stripeMetadataSource);
    }

    public OrcStorageManager(String nodeId, StorageService storageService, Optional<BackupStore> backupStore, ReaderAttributes readerAttributes, BackupManager backgroundBackupManager, ShardRecoveryManager recoveryManager, ShardRecorder shardRecorder, TypeManager typeManager, OrcDataEnvironment orcDataEnvironment, String connectorId, int deletionThreads, Duration shardRecoveryTimeout, long maxShardRows, DataSize maxShardSize, DataSize minAvailableSpace, CompressionKind compression, StorageManagerConfig.OrcOptimizedWriterStage orcOptimizedWriterStage, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource) {
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
        this.storageService = Objects.requireNonNull(storageService, "storageService is null");
        this.backupStore = Objects.requireNonNull(backupStore, "backupStore is null");
        this.defaultReaderAttributes = Objects.requireNonNull(readerAttributes, "readerAttributes is null");
        this.backupManager = Objects.requireNonNull(backgroundBackupManager, "backgroundBackupManager is null");
        this.recoveryManager = Objects.requireNonNull(recoveryManager, "recoveryManager is null");
        this.recoveryTimeout = Objects.requireNonNull(shardRecoveryTimeout, "shardRecoveryTimeout is null");
        Preconditions.checkArgument((maxShardRows > 0L ? 1 : 0) != 0, (Object)"maxShardRows must be > 0");
        this.maxShardRows = Math.min(maxShardRows, 1000000000L);
        this.maxShardSize = Objects.requireNonNull(maxShardSize, "maxShardSize is null");
        this.minAvailableSpace = Objects.requireNonNull(minAvailableSpace, "minAvailableSpace is null");
        this.shardRecorder = Objects.requireNonNull(shardRecorder, "shardRecorder is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.deletionExecutor = Executors.newFixedThreadPool(deletionThreads, Threads.daemonThreadsNamed((String)("raptor-delete-" + connectorId + "-%s")));
        this.commitExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("raptor-commit-" + connectorId + "-%s")));
        this.compression = Objects.requireNonNull(compression, "compression is null");
        this.orcOptimizedWriterStage = Objects.requireNonNull(orcOptimizedWriterStage, "orcOptimizedWriterStage is null");
        this.orcDataEnvironment = Objects.requireNonNull(orcDataEnvironment, "orcDataEnvironment is null");
        this.fileRewriter = new OrcFileRewriter(readerAttributes, orcOptimizedWriterStage.equals((Object)StorageManagerConfig.OrcOptimizedWriterStage.ENABLED_AND_VALIDATED), (WriterStats)this.stats, typeManager, orcDataEnvironment, compression, orcFileTailSource, stripeMetadataSource);
        this.orcFileTailSource = Objects.requireNonNull(orcFileTailSource, "orcFileTailSource is null");
        this.stripeMetadataSource = Objects.requireNonNull(stripeMetadataSource, "stripeMetadataSource is null");
    }

    @PreDestroy
    public void shutdown() {
        this.deletionExecutor.shutdownNow();
        this.commitExecutor.shutdown();
    }

    @Override
    public ConnectorPageSource getPageSource(HdfsContext hdfsContext, HiveFileContext hiveFileContext, UUID shardUuid, Optional<UUID> deltaShardUuid, boolean tableSupportsDeltaDelete, OptionalInt bucketNumber, List<Long> columnIds, List<Type> columnTypes, TupleDomain<RaptorColumnHandle> effectivePredicate, ReaderAttributes readerAttributes, OptionalLong transactionId, Optional<Map<String, Type>> allColumnTypes) {
        FileSystem fileSystem = this.orcDataEnvironment.getFileSystem(hdfsContext);
        OrcDataSource dataSource = this.openShard(fileSystem, shardUuid, readerAttributes);
        RaptorOrcAggregatedMemoryContext systemMemoryUsage = new RaptorOrcAggregatedMemoryContext();
        try {
            OrcReader reader = new OrcReader(dataSource, OrcEncoding.ORC, this.orcFileTailSource, this.stripeMetadataSource, (OrcAggregatedMemoryContext)new RaptorOrcAggregatedMemoryContext(), new OrcReaderOptions(readerAttributes.getMaxMergeDistance(), readerAttributes.getTinyStripeThreshold(), HUGE_MAX_READ_BLOCK_SIZE, readerAttributes.isZstdJniDecompressionEnabled()), hiveFileContext.isCacheable(), DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY);
            Map<Long, Integer> indexMap = OrcStorageManager.columnIdIndex(reader.getColumnNames());
            ImmutableMap.Builder includedColumns = ImmutableMap.builder();
            ImmutableList.Builder columnIndexes = ImmutableList.builder();
            for (int i = 0; i < columnIds.size(); ++i) {
                long columnId = columnIds.get(i);
                if (RaptorColumnHandle.isHiddenColumn(columnId)) {
                    columnIndexes.add((Object)OrcStorageManager.toSpecialIndex(columnId));
                    continue;
                }
                Integer index = indexMap.get(columnId);
                if (index == null) {
                    columnIndexes.add((Object)-1);
                    continue;
                }
                columnIndexes.add((Object)index);
                includedColumns.put((Object)index, (Object)OrcStorageManager.toOrcFileType(columnTypes.get(i), this.typeManager));
            }
            OrcPredicate predicate = OrcStorageManager.getPredicate(effectivePredicate, indexMap);
            StorageTypeConverter storageTypeConverter = new StorageTypeConverter(this.typeManager);
            OrcBatchRecordReader recordReader = reader.createBatchRecordReader(storageTypeConverter.toStorageTypes((Map<Integer, Type>)includedColumns.build()), predicate, DEFAULT_STORAGE_TIMEZONE, (OrcAggregatedMemoryContext)systemMemoryUsage, 1);
            Optional<ShardRewriter> shardRewriter = Optional.empty();
            if (transactionId.isPresent()) {
                Preconditions.checkState((boolean)allColumnTypes.isPresent());
                if (reader.getFooter().getNumberOfRows() >= Integer.MAX_VALUE) {
                    throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "File has too many rows, failed to read file: " + shardUuid);
                }
                shardRewriter = Optional.of(this.createShardRewriter(hdfsContext, fileSystem, transactionId.getAsLong(), bucketNumber, shardUuid, Math.toIntExact(reader.getFooter().getNumberOfRows()), deltaShardUuid, tableSupportsDeltaDelete, allColumnTypes.get()));
            }
            return new OrcUpdatablePageSource(shardRewriter, recordReader, new OrcPageSource(recordReader, dataSource, columnIds, columnTypes, (List<Integer>)columnIndexes.build(), shardUuid, bucketNumber, systemMemoryUsage, new DeltaShardLoader(deltaShardUuid, tableSupportsDeltaDelete, this, fileSystem)));
        }
        catch (IOException | RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to create page source for shard " + shardUuid, (Throwable)e);
        }
        finally {
            OrcStorageManager.closeQuietly((Closeable)dataSource);
        }
    }

    /*
     * Exception decompiling
     */
    Optional<BitSet> getRowsFromUuid(FileSystem fileSystem, Optional<UUID> deltaShardUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int toSpecialIndex(long columnId) {
        if (RaptorColumnHandle.isShardRowIdColumn(columnId)) {
            return -2;
        }
        if (RaptorColumnHandle.isShardUuidColumn(columnId)) {
            return -3;
        }
        if (RaptorColumnHandle.isBucketNumberColumn(columnId)) {
            return -4;
        }
        throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Invalid column ID: " + columnId);
    }

    @Override
    public StoragePageSink createStoragePageSink(HdfsContext hdfsContext, long transactionId, OptionalInt bucketNumber, List<Long> columnIds, List<Type> columnTypes, boolean checkSpace) {
        if (checkSpace && this.storageService.getAvailableBytes() < this.minAvailableSpace.toBytes()) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_LOCAL_DISK_FULL, "Local disk is full on node " + this.nodeId);
        }
        return new OrcStoragePageSink(this.orcDataEnvironment.getFileSystem(hdfsContext), transactionId, columnIds, columnTypes, bucketNumber);
    }

    ShardRewriter createShardRewriter(HdfsContext hdfsContext, FileSystem fileSystem, long transactionId, OptionalInt bucketNumber, UUID shardUuid, int shardRowCount, Optional<UUID> deltaShardUuid, boolean tableSupportsDeltaDelete, Map<String, Type> columns) {
        if (tableSupportsDeltaDelete) {
            return new DeltaShardRewriter(shardUuid, shardRowCount, deltaShardUuid, this.deletionExecutor, transactionId, bucketNumber, this, hdfsContext, fileSystem);
        }
        return new InplaceShardRewriter(shardUuid, columns, this.deletionExecutor, transactionId, bucketNumber, this.nodeId, this, fileSystem, this.storageService, this.shardRecorder, this.backupManager);
    }

    void writeShard(UUID shardUuid) {
        if (this.backupStore.isPresent() && !this.backupStore.get().shardExists(shardUuid)) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Backup does not exist after write");
        }
        this.storageService.promoteFromStagingToStorage(shardUuid);
    }

    @VisibleForTesting
    OrcDataSource openShard(FileSystem fileSystem, UUID shardUuid, ReaderAttributes readerAttributes) {
        boolean exists;
        Path file = this.storageService.getStorageFile(shardUuid);
        try {
            exists = fileSystem.exists(file);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Error locating file " + file, e.getCause());
        }
        if (!exists && this.backupStore.isPresent()) {
            try {
                Future<?> future = this.recoveryManager.recoverShard(shardUuid);
                future.get(this.recoveryTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
                }
                throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_RECOVERY_ERROR, "Error recovering shard " + shardUuid, e.getCause());
            }
            catch (TimeoutException e) {
                throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_RECOVERY_TIMEOUT, "Shard is being recovered from backup. Please retry in a few minutes: " + shardUuid);
            }
        }
        try {
            return this.orcDataEnvironment.createOrcDataSource(fileSystem, file, readerAttributes);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to open shard file: " + file, (Throwable)e);
        }
    }

    ShardInfo createShardInfo(FileSystem fileSystem, UUID shardUuid, OptionalInt bucketNumber, Path file, Set<String> nodes, long rowCount, long uncompressedSize) {
        try {
            return new ShardInfo(shardUuid, bucketNumber, nodes, this.computeShardStats(fileSystem, file), rowCount, fileSystem.getFileStatus(file).getLen(), uncompressedSize, FileSystemUtil.xxhash64(fileSystem, file));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to get file status: " + file, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ColumnStats> computeShardStats(FileSystem fileSystem, Path file) {
        try (OrcDataSource dataSource = this.orcDataEnvironment.createOrcDataSource(fileSystem, file, this.defaultReaderAttributes);){
            OrcReader reader = new OrcReader(dataSource, OrcEncoding.ORC, this.orcFileTailSource, this.stripeMetadataSource, (OrcAggregatedMemoryContext)new RaptorOrcAggregatedMemoryContext(), new OrcReaderOptions(this.defaultReaderAttributes.getMaxMergeDistance(), this.defaultReaderAttributes.getTinyStripeThreshold(), HUGE_MAX_READ_BLOCK_SIZE, this.defaultReaderAttributes.isZstdJniDecompressionEnabled()), false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY);
            ImmutableList.Builder list = ImmutableList.builder();
            for (ColumnInfo info : this.getColumnInfo(reader)) {
                ShardStats.computeColumnStats(reader, info.getColumnId(), info.getType(), this.typeManager).ifPresent(arg_0 -> ((ImmutableList.Builder)list).add(arg_0));
            }
            ImmutableList immutableList = list.build();
            return immutableList;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to read file: " + file, (Throwable)e);
        }
    }

    OrcFileInfo rewriteFile(FileSystem fileSystem, Map<String, Type> columns, Path input, Path output, BitSet rowsToDelete) {
        try {
            return this.fileRewriter.rewrite(fileSystem, columns, input, output, rowsToDelete);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to rewrite shard file: " + input, (Throwable)e);
        }
    }

    private List<ColumnInfo> getColumnInfo(OrcReader reader) {
        Optional<OrcFileMetadata> metadata = OrcStorageManager.getOrcFileMetadata(reader);
        if (metadata.isPresent()) {
            return this.getColumnInfoFromOrcUserMetadata(metadata.get());
        }
        return this.getColumnInfoFromOrcColumnTypes(reader.getColumnNames(), reader.getFooter().getTypes());
    }

    private List<ColumnInfo> getColumnInfoFromOrcColumnTypes(List<String> orcColumnNames, List<OrcType> orcColumnTypes) {
        Type rowType = this.getType(orcColumnTypes, 0);
        if (orcColumnNames.size() != rowType.getTypeParameters().size()) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Column names and types do not match");
        }
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < orcColumnNames.size(); ++i) {
            list.add((Object)new ColumnInfo(Long.parseLong(orcColumnNames.get(i)), (Type)rowType.getTypeParameters().get(i)));
        }
        return list.build();
    }

    private static Optional<OrcFileMetadata> getOrcFileMetadata(OrcReader reader) {
        return Optional.ofNullable(reader.getFooter().getUserMetadata().get("metadata")).map(slice -> (OrcFileMetadata)METADATA_CODEC.fromJson(slice.getBytes()));
    }

    private List<ColumnInfo> getColumnInfoFromOrcUserMetadata(OrcFileMetadata orcFileMetadata) {
        return orcFileMetadata.getColumnTypes().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> new ColumnInfo((Long)entry.getKey(), this.typeManager.getType((TypeSignature)entry.getValue()))).collect(Collectors.toList());
    }

    private Type getType(List<OrcType> types, int index) {
        OrcType type = types.get(index);
        switch (type.getOrcTypeKind()) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case STRING: {
                return VarcharType.createUnboundedVarcharType();
            }
            case VARCHAR: {
                return VarcharType.createVarcharType((int)((Integer)type.getLength().get()));
            }
            case CHAR: {
                return CharType.createCharType((long)((Integer)type.getLength().get()).intValue());
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
            case DECIMAL: {
                return DecimalType.createDecimalType((int)((Integer)type.getPrecision().get()), (int)((Integer)type.getScale().get()));
            }
            case LIST: {
                TypeSignature elementType = this.getType(types, type.getFieldTypeIndex(0)).getTypeSignature();
                return this.typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)elementType)));
            }
            case MAP: {
                TypeSignature keyType = this.getType(types, type.getFieldTypeIndex(0)).getTypeSignature();
                TypeSignature valueType = this.getType(types, type.getFieldTypeIndex(1)).getTypeSignature();
                return this.typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType), (Object)TypeSignatureParameter.of((TypeSignature)valueType)));
            }
            case STRUCT: {
                List fieldNames = type.getFieldNames();
                ImmutableList.Builder fieldTypes = ImmutableList.builder();
                for (int i = 0; i < type.getFieldCount(); ++i) {
                    fieldTypes.add((Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName((String)fieldNames.get(i), false)), this.getType(types, type.getFieldTypeIndex(i)).getTypeSignature())));
                }
                return this.typeManager.getParameterizedType("row", (List)fieldTypes.build());
            }
        }
        throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Unhandled ORC type: " + type);
    }

    static Type toOrcFileType(Type raptorType, TypeManager typeManager) {
        if (raptorType == TimestampType.TIMESTAMP) {
            return BigintType.BIGINT;
        }
        if (raptorType instanceof ArrayType) {
            Type elementType = OrcStorageManager.toOrcFileType(((ArrayType)raptorType).getElementType(), typeManager);
            return new ArrayType(elementType);
        }
        if (raptorType instanceof MapType) {
            TypeSignature keyType = OrcStorageManager.toOrcFileType(((MapType)raptorType).getKeyType(), typeManager).getTypeSignature();
            TypeSignature valueType = OrcStorageManager.toOrcFileType(((MapType)raptorType).getValueType(), typeManager).getTypeSignature();
            return typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType), (Object)TypeSignatureParameter.of((TypeSignature)valueType)));
        }
        if (raptorType instanceof RowType) {
            List fields = (List)((RowType)raptorType).getFields().stream().map(field -> new RowType.Field(field.getName(), OrcStorageManager.toOrcFileType(field.getType(), typeManager))).collect(ImmutableList.toImmutableList());
            return RowType.from((List)fields);
        }
        return raptorType;
    }

    private static OrcPredicate getPredicate(TupleDomain<RaptorColumnHandle> effectivePredicate, Map<Long, Integer> indexMap) {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (RaptorColumnHandle column : ((Map)effectivePredicate.getDomains().get()).keySet()) {
            Integer index = indexMap.get(column.getColumnId());
            if (index == null) continue;
            columns.add((Object)new TupleDomainOrcPredicate.ColumnReference((Object)column, index.intValue(), column.getColumnType()));
        }
        return new TupleDomainOrcPredicate(effectivePredicate, (List)columns.build(), false, Optional.empty());
    }

    private static Map<Long, Integer> columnIdIndex(List<String> columnNames) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (int i = 0; i < columnNames.size(); ++i) {
            map.put((Object)Long.valueOf(columnNames.get(i)), (Object)i);
        }
        return map.build();
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class OrcStoragePageSink
    implements StoragePageSink {
        private final long transactionId;
        private final List<Long> columnIds;
        private final List<Type> columnTypes;
        private final OptionalInt bucketNumber;
        private final List<Path> stagingFiles = new ArrayList<Path>();
        private final List<ShardInfo> shards = new ArrayList<ShardInfo>();
        private final List<CompletableFuture<?>> futures = new ArrayList();
        private final FileSystem fileSystem;
        private boolean committed;
        private FileWriter writer;
        private UUID shardUuid;

        public OrcStoragePageSink(FileSystem fileSystem, long transactionId, List<Long> columnIds, List<Type> columnTypes, OptionalInt bucketNumber) {
            this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
            this.transactionId = transactionId;
            this.columnIds = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnIds, "columnIds is null"));
            this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
            this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        }

        @Override
        public void appendPages(List<Page> pages) {
            this.createWriterIfNecessary();
            this.writer.appendPages(pages);
        }

        @Override
        public void appendPages(List<Page> inputPages, int[] pageIndexes, int[] positionIndexes) {
            this.createWriterIfNecessary();
            this.writer.appendPages(inputPages, pageIndexes, positionIndexes);
        }

        @Override
        public boolean isFull() {
            if (this.writer == null) {
                return false;
            }
            return this.writer.getRowCount() >= OrcStorageManager.this.maxShardRows || this.writer.getUncompressedSize() >= OrcStorageManager.this.maxShardSize.toBytes();
        }

        @Override
        public void flush() {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to close writer", (Throwable)e);
                }
                OrcStorageManager.this.shardRecorder.recordCreatedShard(this.transactionId, this.shardUuid);
                Path stagingFile = OrcStorageManager.this.storageService.getStagingFile(this.shardUuid);
                this.futures.add(OrcStorageManager.this.backupManager.submit(this.shardUuid, stagingFile));
                ImmutableSet nodes = ImmutableSet.of((Object)OrcStorageManager.this.nodeId);
                long rowCount = this.writer.getRowCount();
                long uncompressedSize = this.writer.getUncompressedSize();
                this.shards.add(OrcStorageManager.this.createShardInfo(this.fileSystem, this.shardUuid, this.bucketNumber, stagingFile, (Set<String>)nodes, rowCount, uncompressedSize));
                this.writer = null;
                this.shardUuid = null;
            }
        }

        @Override
        public CompletableFuture<List<ShardInfo>> commit() {
            Preconditions.checkState((!this.committed ? 1 : 0) != 0, (Object)"already committed");
            this.committed = true;
            this.flush();
            return MoreFutures.allAsList(this.futures).thenApplyAsync(ignored -> {
                for (ShardInfo shard : this.shards) {
                    OrcStorageManager.this.writeShard(shard.getShardUuid());
                }
                return ImmutableList.copyOf(this.shards);
            }, (Executor)OrcStorageManager.this.commitExecutor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() {
            block13: {
                try {
                    if (this.writer == null) break block13;
                    try {
                        this.writer.close();
                    }
                    catch (IOException e) {
                        throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to close writer", (Throwable)e);
                    }
                    finally {
                        this.writer = null;
                    }
                }
                finally {
                    for (Path file : this.stagingFiles) {
                        try {
                            this.fileSystem.delete(file, false);
                        }
                        catch (IOException iOException) {}
                    }
                    this.futures.forEach(future -> future.cancel(true));
                    OrcStorageManager.this.backupStore.ifPresent(backupStore -> {
                        for (ShardInfo shard : this.shards) {
                            backupStore.deleteShard(shard.getShardUuid());
                        }
                    });
                }
            }
        }

        private void createWriterIfNecessary() {
            if (this.writer == null) {
                DataSink sink;
                this.shardUuid = UUID.randomUUID();
                Path stagingFile = OrcStorageManager.this.storageService.getStagingFile(this.shardUuid);
                OrcStorageManager.this.storageService.createParents(stagingFile);
                this.stagingFiles.add(stagingFile);
                try {
                    sink = OrcStorageManager.this.orcDataEnvironment.createOrcDataSink(this.fileSystem, stagingFile);
                }
                catch (IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, String.format("Failed to create staging file %s", stagingFile), (Throwable)e);
                }
                this.writer = new OrcFileWriter(this.columnIds, this.columnTypes, sink, OrcStorageManager.this.orcOptimizedWriterStage.equals((Object)StorageManagerConfig.OrcOptimizedWriterStage.ENABLED_AND_VALIDATED), (WriterStats)OrcStorageManager.this.stats, OrcStorageManager.this.typeManager, OrcStorageManager.this.compression);
            }
        }
    }
}

