/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.raptor.NodeSupplier;
import com.facebook.presto.raptor.RaptorConnectorId;
import com.facebook.presto.raptor.backup.BackupStore;
import com.facebook.presto.raptor.filesystem.LocalOrcDataEnvironment;
import com.facebook.presto.raptor.metadata.ShardManager;
import com.facebook.presto.raptor.metadata.ShardMetadata;
import com.facebook.presto.raptor.storage.OrcDataEnvironment;
import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.facebook.presto.raptor.storage.StorageService;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ShardEjector {
    private static final Logger log = Logger.get(ShardEjector.class);
    private final String currentNode;
    private final NodeSupplier nodeSupplier;
    private final ShardManager shardManager;
    private final StorageService storageService;
    private final Duration interval;
    private final Optional<BackupStore> backupStore;
    private final ScheduledExecutorService executor;
    private final Optional<RawLocalFileSystem> localFileSystem;
    private final AtomicBoolean started = new AtomicBoolean();
    private final CounterStat shardsEjected = new CounterStat();
    private final CounterStat jobErrors = new CounterStat();

    @Inject
    public ShardEjector(NodeManager nodeManager, NodeSupplier nodeSupplier, ShardManager shardManager, StorageService storageService, StorageManagerConfig config, Optional<BackupStore> backupStore, OrcDataEnvironment environment, RaptorConnectorId connectorId) {
        this(nodeManager.getCurrentNode().getNodeIdentifier(), nodeSupplier, shardManager, storageService, config.getShardEjectorInterval(), backupStore, environment, connectorId.toString());
    }

    public ShardEjector(String currentNode, NodeSupplier nodeSupplier, ShardManager shardManager, StorageService storageService, Duration interval, Optional<BackupStore> backupStore, OrcDataEnvironment environment, String connectorId) {
        this.currentNode = Objects.requireNonNull(currentNode, "currentNode is null");
        this.nodeSupplier = Objects.requireNonNull(nodeSupplier, "nodeSupplier is null");
        this.shardManager = Objects.requireNonNull(shardManager, "shardManager is null");
        this.storageService = Objects.requireNonNull(storageService, "storageService is null");
        this.interval = Objects.requireNonNull(interval, "interval is null");
        this.backupStore = Objects.requireNonNull(backupStore, "backupStore is null");
        this.executor = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)("shard-ejector-" + connectorId)));
        this.localFileSystem = LocalOrcDataEnvironment.tryGetLocalFileSystem(Objects.requireNonNull(environment, "environment is null"));
        Preconditions.checkState((!backupStore.isPresent() || this.localFileSystem.isPresent() ? 1 : 0) != 0, (Object)"cannot support backup for remote file system");
    }

    @PostConstruct
    public void start() {
        if (!this.backupStore.isPresent()) {
            return;
        }
        if (!this.started.getAndSet(true)) {
            this.startJob();
        }
    }

    @PreDestroy
    public void shutdown() {
        this.executor.shutdownNow();
    }

    @Managed
    @Nested
    public CounterStat getShardsEjected() {
        return this.shardsEjected;
    }

    @Managed
    @Nested
    public CounterStat getJobErrors() {
        return this.jobErrors;
    }

    private void startJob() {
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                long interval = this.interval.roundTo(TimeUnit.SECONDS);
                TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextLong(1L, interval));
                this.process();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                log.error(t, "Error ejecting shards");
                this.jobErrors.update(1L);
            }
        }, 0L, this.interval.toMillis(), TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    void process() throws IOException {
        long averageSize;
        long maxSize;
        Preconditions.checkState((boolean)this.backupStore.isPresent(), (Object)"backup store must be present");
        Map<String, Long> nodes = this.shardManager.getNodeBytes();
        Set activeNodes = this.nodeSupplier.getWorkerNodes().stream().map(Node::getNodeIdentifier).collect(Collectors.toSet());
        nodes = new HashMap<String, Long>(Maps.filterKeys(nodes, activeNodes::contains));
        if (nodes.isEmpty()) {
            return;
        }
        if (!nodes.containsKey(this.currentNode)) {
            return;
        }
        long nodeSize = nodes.get(this.currentNode);
        if (nodeSize <= (maxSize = Math.round((double)(averageSize = Math.round(nodes.values().stream().mapToLong(Long::longValue).average().getAsDouble())) * 1.01))) {
            return;
        }
        nodes = new HashMap<String, Long>(Maps.filterValues(nodes, size -> size <= averageSize));
        List shards = this.shardManager.getNodeShards(this.currentNode).stream().filter(shard -> !shard.getBucketNumber().isPresent()).sorted(Comparator.comparingLong(ShardMetadata::getCompressedSize).reversed()).collect(Collectors.toList());
        ArrayDeque queue = new ArrayDeque(shards);
        while (nodeSize > maxSize && !queue.isEmpty()) {
            String target;
            ShardMetadata shard2 = (ShardMetadata)queue.remove();
            long shardSize = shard2.getCompressedSize();
            UUID shardUuid = shard2.getShardUuid();
            Optional<UUID> deltaUuid = shard2.getDeltaUuid();
            if (!this.backupStore.get().shardExists(shardUuid)) {
                log.warn("No backup for shard: %s", new Object[]{shardUuid});
            }
            if ((target = ShardEjector.pickTargetNode(nodes, shardSize, averageSize)) == null) {
                return;
            }
            long targetSize = nodes.get(target);
            log.info("Moving shard %s to node %s (shard: %s, node: %s, average: %s, target: %s)", new Object[]{shardUuid, target, shardSize, nodeSize, averageSize, targetSize});
            this.shardsEjected.update(1L);
            nodes.put(target, targetSize + shardSize);
            nodeSize -= shardSize;
            this.shardManager.replaceShardAssignment(shard2.getTableId(), shardUuid, deltaUuid, target, false);
            Path file = this.storageService.getStorageFile(shardUuid);
            if (!this.localFileSystem.get().exists(file) || this.localFileSystem.get().delete(file, false)) continue;
            log.warn("Failed to delete shard file: %s", new Object[]{file});
        }
    }

    private static String pickTargetNode(Map<String, Long> nodes, long shardSize, long maxSize) {
        while (!nodes.isEmpty()) {
            String node = ShardEjector.pickCandidateNode(nodes);
            if (nodes.get(node) + shardSize <= maxSize) {
                return node;
            }
            nodes.remove(node);
        }
        return null;
    }

    private static String pickCandidateNode(Map<String, Long> nodes) {
        Preconditions.checkArgument((!nodes.isEmpty() ? 1 : 0) != 0);
        if (nodes.size() == 1) {
            return nodes.keySet().iterator().next();
        }
        ArrayList<String> candidates = new ArrayList<String>(nodes.keySet());
        Collections.shuffle(candidates);
        String first = (String)candidates.get(0);
        String second = (String)candidates.get(1);
        return nodes.get(first) <= nodes.get(second) ? first : second;
    }
}

