/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage.organization;

import com.facebook.airlift.concurrent.ThreadPoolExecutorMBean;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.facebook.presto.raptor.storage.organization.JobFactory;
import com.facebook.presto.raptor.storage.organization.OrganizationJob;
import com.facebook.presto.raptor.storage.organization.OrganizationSet;
import com.facebook.presto.raptor.util.PrioritizedFifoExecutor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ShardOrganizer {
    private static final Logger log = Logger.get(ShardOrganizer.class);
    private final ExecutorService executorService;
    private final PrioritizedFifoExecutor<Runnable> prioritizedFifoExecutor;
    private final ThreadPoolExecutorMBean executorMBean;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final Map<UUID, Optional<UUID>> shardsInProgress = new ConcurrentHashMap<UUID, Optional<UUID>>();
    private final JobFactory jobFactory;
    private final CounterStat successCount = new CounterStat();
    private final CounterStat failureCount = new CounterStat();
    private int deltaCountInProgress;

    @Inject
    public ShardOrganizer(JobFactory jobFactory, StorageManagerConfig config) {
        this(jobFactory, config.getOrganizationThreads());
    }

    public ShardOrganizer(JobFactory jobFactory, int threads) {
        Preconditions.checkArgument((threads > 0 ? 1 : 0) != 0, (Object)"threads must be > 0");
        this.jobFactory = Objects.requireNonNull(jobFactory, "jobFactory is null");
        this.executorService = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"shard-organizer-%s"));
        this.prioritizedFifoExecutor = new PrioritizedFifoExecutor<OrganizationJob>(this.executorService, threads, new OrganizationJobComparator());
        this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.executorService);
    }

    @PreDestroy
    public void shutdown() {
        if (!this.shutdown.getAndSet(true)) {
            this.executorService.shutdownNow();
        }
    }

    public ListenableFuture<?> enqueue(OrganizationSet organizationSet) {
        log.info("enqueue organizationSet: %s", new Object[]{organizationSet});
        this.shardsInProgress.putAll(organizationSet.getShardsMap());
        this.deltaCountInProgress = this.shardsInProgress.values().stream().filter(Optional::isPresent).collect(Collectors.toSet()).size();
        ListenableFuture<?> listenableFuture = this.prioritizedFifoExecutor.submit(this.jobFactory.create(organizationSet));
        listenableFuture.addListener(() -> {
            for (UUID uuid : organizationSet.getShardsMap().keySet()) {
                this.shardsInProgress.remove(uuid);
                this.deltaCountInProgress = this.shardsInProgress.values().stream().filter(Optional::isPresent).collect(Collectors.toSet()).size();
            }
        }, MoreExecutors.directExecutor());
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object o) {
                ShardOrganizer.this.successCount.update(1L);
            }

            public void onFailure(Throwable throwable) {
                log.warn(throwable, "Error running organization job");
                ShardOrganizer.this.failureCount.update(1L);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return listenableFuture;
    }

    public boolean inProgress(UUID shardUuid) {
        return this.shardsInProgress.containsKey(shardUuid);
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }

    @Managed
    public int getShardsInProgress() {
        return this.shardsInProgress.size();
    }

    @Managed
    public int getDeltaCountInProgress() {
        return this.deltaCountInProgress;
    }

    @Managed
    @Nested
    public CounterStat getSuccessCount() {
        return this.successCount;
    }

    @Managed
    @Nested
    public CounterStat getFailureCount() {
        return this.failureCount;
    }

    @VisibleForTesting
    static class OrganizationJobComparator
    implements Comparator<OrganizationJob> {
        OrganizationJobComparator() {
        }

        @Override
        public int compare(OrganizationJob left, OrganizationJob right) {
            return right.getPriority() - left.getPriority();
        }
    }
}

