/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.systemtables;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.raptor.systemtables.ValueBuffer;
import com.facebook.presto.raptor.util.DatabaseUtil;
import com.facebook.presto.raptor.util.UuidUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class PreparedStatementBuilder {
    private PreparedStatementBuilder() {
    }

    public static PreparedStatement create(Connection connection, String sql, List<String> columnNames, List<Type> types, Set<Integer> uuidColumnIndexes, TupleDomain<Integer> tupleDomain) throws SQLException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sql) ? 1 : 0) != 0, (Object)"sql is null or empty");
        ArrayList<ValueBuffer> bindValues = new ArrayList<ValueBuffer>(256);
        sql = sql + PreparedStatementBuilder.getWhereClause(tupleDomain, columnNames, types, uuidColumnIndexes, bindValues);
        PreparedStatement statement = connection.prepareStatement(sql, 1003, 1007);
        DatabaseUtil.enableStreamingResults(statement);
        int bindIndex = 1;
        for (ValueBuffer value : bindValues) {
            PreparedStatementBuilder.bindField(value, statement, bindIndex, uuidColumnIndexes.contains(value.getColumnIndex()));
            ++bindIndex;
        }
        return statement;
    }

    private static String getWhereClause(TupleDomain<Integer> tupleDomain, List<String> columnNames, List<Type> types, Set<Integer> uuidColumnIndexes, List<ValueBuffer> bindValues) {
        if (tupleDomain.isNone()) {
            return "";
        }
        ImmutableList.Builder conjunctsBuilder = ImmutableList.builder();
        Map domainMap = (Map)tupleDomain.getDomains().get();
        for (Map.Entry entry : domainMap.entrySet()) {
            int index = (Integer)entry.getKey();
            String columnName = columnNames.get(index);
            Type type = types.get(index);
            conjunctsBuilder.add((Object)PreparedStatementBuilder.toPredicate(index, columnName, type, (Domain)entry.getValue(), uuidColumnIndexes, bindValues));
        }
        ImmutableList conjuncts = conjunctsBuilder.build();
        if (conjuncts.isEmpty()) {
            return "";
        }
        StringBuilder where = new StringBuilder("WHERE ");
        return Joiner.on((String)" AND\n").appendTo(where, (Iterable)conjuncts).toString();
    }

    private static String toPredicate(int columnIndex, String columnName, Type type, Domain domain, Set<Integer> uuidColumnIndexes, List<ValueBuffer> bindValues) {
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? "TRUE" : columnName + " IS NOT NULL";
        }
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? columnName + " IS NULL" : "FALSE";
        }
        return (String)domain.getValues().getValuesProcessor().transform(ranges -> {
            ArrayList<String> disjuncts = new ArrayList<String>();
            ArrayList<Object> singleValues = new ArrayList<Object>();
            for (Range range : ranges.getOrderedRanges()) {
                Object bindValue;
                Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
                if (range.isSingleValue()) {
                    singleValues.add(range.getLow().getValue());
                    continue;
                }
                ArrayList<String> rangeConjuncts = new ArrayList<String>();
                if (!range.getLow().isLowerUnbounded()) {
                    bindValue = PreparedStatementBuilder.getBindValue(columnIndex, uuidColumnIndexes, range.getLow().getValue());
                    switch (range.getLow().getBound()) {
                        case ABOVE: {
                            rangeConjuncts.add(PreparedStatementBuilder.toBindPredicate(columnName, ">"));
                            bindValues.add(ValueBuffer.create(columnIndex, type, bindValue));
                            break;
                        }
                        case EXACTLY: {
                            rangeConjuncts.add(PreparedStatementBuilder.toBindPredicate(columnName, ">="));
                            bindValues.add(ValueBuffer.create(columnIndex, type, bindValue));
                            break;
                        }
                        case BELOW: {
                            throw new VerifyException("Low Marker should never use BELOW bound");
                        }
                        default: {
                            throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                        }
                    }
                }
                if (!range.getHigh().isUpperUnbounded()) {
                    bindValue = PreparedStatementBuilder.getBindValue(columnIndex, uuidColumnIndexes, range.getHigh().getValue());
                    switch (range.getHigh().getBound()) {
                        case ABOVE: {
                            throw new VerifyException("High Marker should never use ABOVE bound");
                        }
                        case EXACTLY: {
                            rangeConjuncts.add(PreparedStatementBuilder.toBindPredicate(columnName, "<="));
                            bindValues.add(ValueBuffer.create(columnIndex, type, bindValue));
                            break;
                        }
                        case BELOW: {
                            rangeConjuncts.add(PreparedStatementBuilder.toBindPredicate(columnName, "<"));
                            bindValues.add(ValueBuffer.create(columnIndex, type, bindValue));
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                        }
                    }
                }
                Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
                disjuncts.add("(" + Joiner.on((String)" AND ").join(rangeConjuncts) + ")");
            }
            if (singleValues.size() == 1) {
                disjuncts.add(PreparedStatementBuilder.toBindPredicate(columnName, "="));
                bindValues.add(ValueBuffer.create(columnIndex, type, PreparedStatementBuilder.getBindValue(columnIndex, uuidColumnIndexes, Iterables.getOnlyElement(singleValues))));
            } else if (singleValues.size() > 1) {
                disjuncts.add(columnName + " IN (" + Joiner.on((String)",").join(Collections.nCopies(singleValues.size(), "?")) + ")");
                for (Object e : singleValues) {
                    bindValues.add(ValueBuffer.create(columnIndex, type, PreparedStatementBuilder.getBindValue(columnIndex, uuidColumnIndexes, e)));
                }
            }
            Preconditions.checkState((!disjuncts.isEmpty() ? 1 : 0) != 0);
            if (domain.isNullAllowed()) {
                disjuncts.add(columnName + " IS NULL");
            }
            return "(" + Joiner.on((String)" OR ").join(disjuncts) + ")";
        }, discreteValues -> {
            String values = Joiner.on((String)",").join(Collections.nCopies(discreteValues.getValues().size(), "?"));
            String predicate = columnName + (discreteValues.isWhiteList() ? "" : " NOT") + " IN (" + values + ")";
            for (Object value : discreteValues.getValues()) {
                bindValues.add(ValueBuffer.create(columnIndex, type, PreparedStatementBuilder.getBindValue(columnIndex, uuidColumnIndexes, value)));
            }
            if (domain.isNullAllowed()) {
                predicate = "(" + predicate + " OR " + columnName + " IS NULL)";
            }
            return predicate;
        }, allOrNone -> {
            throw new IllegalStateException("Case should not be reachable");
        });
    }

    private static Object getBindValue(int columnIndex, Set<Integer> uuidColumnIndexes, Object value) {
        if (uuidColumnIndexes.contains(columnIndex)) {
            return UuidUtil.uuidToBytes(UUID.fromString(((Slice)value).toStringUtf8()));
        }
        return value;
    }

    private static String toBindPredicate(String columnName, String operator) {
        return String.format("%s %s ?", columnName, operator);
    }

    private static void bindField(ValueBuffer valueBuffer, PreparedStatement preparedStatement, int parameterIndex, boolean isUuid) throws SQLException {
        Type type = valueBuffer.getType();
        if (valueBuffer.isNull()) {
            preparedStatement.setNull(parameterIndex, PreparedStatementBuilder.typeToSqlType(type));
        } else if (type.getJavaType() == Long.TYPE) {
            preparedStatement.setLong(parameterIndex, valueBuffer.getLong());
        } else if (type.getJavaType() == Double.TYPE) {
            preparedStatement.setDouble(parameterIndex, valueBuffer.getDouble());
        } else if (type.getJavaType() == Boolean.TYPE) {
            preparedStatement.setBoolean(parameterIndex, valueBuffer.getBoolean());
        } else if (type.getJavaType() == Slice.class && isUuid) {
            preparedStatement.setBytes(parameterIndex, valueBuffer.getSlice().getBytes());
        } else if (type.getJavaType() == Slice.class) {
            preparedStatement.setString(parameterIndex, new String(valueBuffer.getSlice().getBytes()));
        } else {
            throw new IllegalArgumentException("Unknown Java type: " + type.getJavaType());
        }
    }

    private static int typeToSqlType(Type type) {
        if (type.equals(BigintType.BIGINT)) {
            return -5;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return 8;
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return 16;
        }
        if (Varchars.isVarcharType((Type)type)) {
            return 12;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return -3;
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }
}

