/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.util;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static List<Integer> intArrayFromBytes(byte[] bytes) {
        ImmutableList.Builder list = ImmutableList.builder();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        while (buffer.hasRemaining()) {
            list.add((Object)buffer.getInt());
        }
        return list.build();
    }

    public static byte[] intArrayToBytes(Collection<Integer> values) {
        ByteBuffer buffer = ByteBuffer.allocate(values.size() * 4);
        for (int value : values) {
            buffer.putInt(value);
        }
        return buffer.array();
    }
}

