/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.util;

import com.facebook.airlift.log.Logger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Comparator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PrioritizedFifoExecutor<T extends Runnable> {
    private static final Logger log = Logger.get(PrioritizedFifoExecutor.class);
    private final Queue<FifoRunnableTask<T>> queue;
    private final AtomicInteger queueSize = new AtomicInteger(0);
    private final AtomicLong sequenceNumber = new AtomicLong(0L);
    private final Runnable triggerTask = this::executeOrMerge;
    private final ExecutorService executorService;
    private final int maxThreads;
    private final Comparator<T> taskComparator;

    public PrioritizedFifoExecutor(ExecutorService coreExecutor, int maxThreads, Comparator<T> taskComparator) {
        Preconditions.checkArgument((maxThreads > 0 ? 1 : 0) != 0, (Object)"maxThreads must be greater than zero");
        this.taskComparator = Objects.requireNonNull(taskComparator, "taskComparator is null");
        this.executorService = Objects.requireNonNull(coreExecutor, "coreExecutor is null");
        this.maxThreads = maxThreads;
        this.queue = new PriorityBlockingQueue<FifoRunnableTask<T>>(maxThreads);
    }

    public ListenableFuture<?> submit(T task) {
        FifoRunnableTask<T> fifoTask = new FifoRunnableTask<T>(task, this.sequenceNumber.incrementAndGet(), this.taskComparator);
        this.queue.add(fifoTask);
        this.executorService.submit(this.triggerTask);
        return fifoTask;
    }

    private void executeOrMerge() {
        int size = this.queueSize.incrementAndGet();
        if (size > this.maxThreads) {
            return;
        }
        do {
            try {
                this.queue.poll().run();
            }
            catch (Throwable e) {
                log.error(e, "Task failed");
            }
        } while (this.queueSize.getAndDecrement() > this.maxThreads);
    }

    private static class FifoRunnableTask<T extends Runnable>
    extends FutureTask<Void>
    implements ListenableFuture<Void>,
    Comparable<FifoRunnableTask<T>> {
        private final ExecutionList executionList = new ExecutionList();
        private final T task;
        private final long sequenceNumber;
        private final Comparator<T> taskComparator;

        public FifoRunnableTask(T task, long sequenceNumber, Comparator<T> taskComparator) {
            super((Runnable)Objects.requireNonNull(task, "task is null"), null);
            this.task = task;
            this.sequenceNumber = sequenceNumber;
            this.taskComparator = Objects.requireNonNull(taskComparator, "taskComparator is null");
        }

        public void addListener(Runnable listener, Executor executor) {
            this.executionList.add(listener, executor);
        }

        @Override
        protected void done() {
            this.executionList.execute();
        }

        @Override
        public int compareTo(FifoRunnableTask<T> other) {
            return ComparisonChain.start().compare(this.task, other.task, this.taskComparator).compare(this.sequenceNumber, other.sequenceNumber).result();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FifoRunnableTask other = (FifoRunnableTask)o;
            return Objects.equals(this.task, other.task) && Objects.equals(this.sequenceNumber, other.sequenceNumber);
        }

        public int hashCode() {
            return Objects.hash(this.task, this.sequenceNumber);
        }
    }
}

