/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.util;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.TypedMapper;

public final class UuidUtil {
    private UuidUtil() {
    }

    public static UUID uuidFromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long msb = buffer.getLong();
        long lsb = buffer.getLong();
        return new UUID(msb, lsb);
    }

    public static byte[] uuidToBytes(UUID uuid) {
        return ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
    }

    public static Slice uuidStringToBytes(Slice uuidSlice) {
        UUID uuid = UUID.fromString(uuidSlice.toStringUtf8());
        byte[] bytes = UuidUtil.uuidToBytes(uuid);
        return Slices.wrappedBuffer((byte[])bytes);
    }

    public static final class UuidMapper
    extends TypedMapper<UUID> {
        protected UUID extractByName(ResultSet r, String name) throws SQLException {
            return UuidUtil.uuidFromBytes(r.getBytes(name));
        }

        protected UUID extractByIndex(ResultSet r, int index) throws SQLException {
            return UuidUtil.uuidFromBytes(r.getBytes(index));
        }
    }

    public static class UuidMapperFactory
    implements ResultSetMapperFactory {
        public boolean accepts(Class type, StatementContext ctx) {
            return type == UUID.class;
        }

        public ResultSetMapper mapperFor(Class type, StatementContext ctx) {
            return new UuidMapper();
        }
    }

    public static final class UuidArgument
    implements Argument {
        private final UUID uuid;

        public UuidArgument(UUID uuid) {
            this.uuid = uuid;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            if (this.uuid == null) {
                statement.setNull(position, -3);
            } else {
                statement.setBytes(position, UuidUtil.uuidToBytes(this.uuid));
            }
        }

        public String toString() {
            return String.valueOf(this.uuid);
        }
    }

    public static final class UuidArgumentFactory
    implements ArgumentFactory<UUID> {
        public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
            return value instanceof UUID;
        }

        public Argument build(Class<?> expectedType, UUID value, StatementContext ctx) {
            return new UuidArgument(value);
        }
    }
}

