/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.security.csr;

import com.facebook.airlift.security.csr.CertificationRequestInfo;
import com.facebook.airlift.security.csr.SignatureAlgorithmIdentifier;
import com.facebook.airlift.security.der.DerUtils;
import com.google.common.base.MoreObjects;
import com.google.common.io.BaseEncoding;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;

public class CertificationRequest {
    private final CertificationRequestInfo certificationRequestInfo;
    private final SignatureAlgorithmIdentifier signatureAlgorithmIdentifier;
    private final byte[] signature;
    private final byte[] encoded;

    public CertificationRequest(String x500Name, String signatureAlgorithm, KeyPair keyPair) throws GeneralSecurityException {
        this(new CertificationRequestInfo(new X500Principal(x500Name), keyPair.getPublic()), SignatureAlgorithmIdentifier.findSignatureAlgorithmIdentifier(signatureAlgorithm), keyPair.getPrivate());
    }

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo, SignatureAlgorithmIdentifier signatureAlgorithmIdentifier, PrivateKey privateKey) throws GeneralSecurityException {
        this(certificationRequestInfo, signatureAlgorithmIdentifier, certificationRequestInfo.sign(signatureAlgorithmIdentifier, privateKey));
    }

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo, SignatureAlgorithmIdentifier signatureAlgorithmIdentifier, byte[] signature) {
        this.certificationRequestInfo = Objects.requireNonNull(certificationRequestInfo, "certificationRequestInfo is null");
        this.signatureAlgorithmIdentifier = Objects.requireNonNull(signatureAlgorithmIdentifier, "signatureAlgorithmIdentifier is null");
        this.signature = (byte[])Objects.requireNonNull(signature, "signature is null").clone();
        this.encoded = DerUtils.encodeSequence(certificationRequestInfo.getEncoded(), DerUtils.encodeSequence(new byte[][]{signatureAlgorithmIdentifier.getEncoded()}), DerUtils.encodeBitString(0, signature));
    }

    public CertificationRequestInfo getCertificationRequestInfo() {
        return this.certificationRequestInfo;
    }

    public SignatureAlgorithmIdentifier getSignatureAlgorithmIdentifier() {
        return this.signatureAlgorithmIdentifier;
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public String getPemEncoded() {
        return "-----BEGIN CERTIFICATE REQUEST-----\n" + Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(this.encoded) + '\n' + "-----END CERTIFICATE REQUEST-----\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificationRequest that = (CertificationRequest)o;
        return Objects.equals(this.certificationRequestInfo, that.certificationRequestInfo) && Objects.equals(this.signatureAlgorithmIdentifier, that.signatureAlgorithmIdentifier) && Arrays.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.certificationRequestInfo, this.signatureAlgorithmIdentifier, this.signature);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("certificationRequestInfo", (Object)this.certificationRequestInfo).add("signatureAlgorithmIdentifier", (Object)this.signatureAlgorithmIdentifier).add("signature", (Object)BaseEncoding.base16().encode(this.signature)).toString();
    }
}

