/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.google.common.base.Preconditions;
import io.airlift.slice.FixedLengthSliceInput;
import java.util.Objects;

public final class OrcDataSourceInput {
    private final FixedLengthSliceInput input;
    private final int retainedSizeInBytes;

    public OrcDataSourceInput(FixedLengthSliceInput input, int retainedSizeInBytes) {
        this.input = Objects.requireNonNull(input, "input is null");
        Preconditions.checkArgument((retainedSizeInBytes >= 0 ? 1 : 0) != 0, (Object)"retainedSizeInBytes is negative");
        this.retainedSizeInBytes = retainedSizeInBytes;
    }

    public FixedLengthSliceInput getInput() {
        return this.input;
    }

    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }
}

