/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.io.DataOutput;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DictionaryCompressionOptimizer;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.DwrfEncryptionInfo;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.DwrfWriterEncryption;
import com.facebook.presto.orc.EncryptionLibrary;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.StreamLayout;
import com.facebook.presto.orc.WriterEncryptionGroup;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfEncryption;
import com.facebook.presto.orc.metadata.DwrfMetadataWriter;
import com.facebook.presto.orc.metadata.EncryptionGroup;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeEncryptionGroup;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.ColumnWriters;
import com.facebook.presto.orc.writer.DictionaryColumnWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class OrcWriter
implements Closeable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(OrcWriter.class).instanceSize();
    private static final Logger log = Logger.get(OrcWriter.class);
    static final String PRESTO_ORC_WRITER_VERSION_METADATA_KEY = "presto.writer.version";
    static final String PRESTO_ORC_WRITER_VERSION;
    private final WriterStats stats;
    private final DataSink dataSink;
    private final List<Type> types;
    private final OrcEncoding orcEncoding;
    private final ColumnWriterOptions columnWriterOptions;
    private final int stripeMinBytes;
    private final int stripeMaxBytes;
    private final int chunkMaxLogicalBytes;
    private final int stripeMaxRowCount;
    private final int rowGroupMaxRowCount;
    private final StreamLayout streamLayout;
    private final Map<String, String> userMetadata;
    private final CompressedMetadataWriter metadataWriter;
    private final DateTimeZone hiveStorageTimeZone;
    private final DwrfEncryptionProvider dwrfEncryptionProvider;
    private final DwrfEncryptionInfo dwrfEncryptionInfo;
    private final Optional<DwrfWriterEncryption> dwrfWriterEncryption;
    private final List<ClosedStripe> closedStripes = new ArrayList<ClosedStripe>();
    private final List<OrcType> orcTypes;
    private final List<ColumnWriter> columnWriters;
    private final int dictionaryMaxMemoryBytes;
    private final DictionaryCompressionOptimizer dictionaryCompressionOptimizer;
    private int stripeRowCount;
    private int rowGroupRowCount;
    private int bufferedBytes;
    private long columnWritersRetainedBytes;
    private long closedStripesRetainedBytes;
    private long previouslyRecordedSizeInBytes;
    private boolean closed;
    @Nullable
    private final OrcWriteValidation.OrcWriteValidationBuilder validationBuilder;

    public OrcWriter(DataSink dataSink, List<String> columnNames, List<Type> types, OrcEncoding orcEncoding, CompressionKind compressionKind, Optional<DwrfWriterEncryption> encryption, DwrfEncryptionProvider dwrfEncryptionProvider, OrcWriterOptions options, Map<String, String> userMetadata, DateTimeZone hiveStorageTimeZone, boolean validate, OrcWriteValidation.OrcWriteValidationMode validationMode, WriterStats stats) {
        this.validationBuilder = validate ? new OrcWriteValidation.OrcWriteValidationBuilder(validationMode, types).setStringStatisticsLimitInBytes(Math.toIntExact(options.getMaxStringStatisticsLimit().toBytes())) : null;
        this.dataSink = Objects.requireNonNull(dataSink, "dataSink is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.orcEncoding = Objects.requireNonNull(orcEncoding, "orcEncoding is null");
        Objects.requireNonNull(compressionKind, "compressionKind is null");
        this.columnWriterOptions = ColumnWriterOptions.builder().setCompressionKind(compressionKind).setCompressionLevel(options.getCompressionLevel()).setCompressionMaxBufferSize(options.getMaxCompressionBufferSize()).setStringStatisticsLimit(options.getMaxStringStatisticsLimit()).setIntegerDictionaryEncodingEnabled(options.isIntegerDictionaryEncodingEnabled()).build();
        this.recordValidation(validation -> validation.setCompression(compressionKind));
        Objects.requireNonNull(options, "options is null");
        Preconditions.checkArgument((options.getStripeMaxSize().compareTo(options.getStripeMinSize()) >= 0 ? 1 : 0) != 0, (Object)"stripeMaxSize must be greater than stripeMinSize");
        this.stripeMinBytes = Math.toIntExact(Objects.requireNonNull(options.getStripeMinSize(), "stripeMinSize is null").toBytes());
        this.stripeMaxBytes = Math.toIntExact(Objects.requireNonNull(options.getStripeMaxSize(), "stripeMaxSize is null").toBytes());
        this.chunkMaxLogicalBytes = Math.max(1, this.stripeMaxBytes / 2);
        this.stripeMaxRowCount = options.getStripeMaxRowCount();
        this.rowGroupMaxRowCount = options.getRowGroupMaxRowCount();
        this.recordValidation(validation -> validation.setRowGroupMaxRowCount(this.rowGroupMaxRowCount));
        this.streamLayout = Objects.requireNonNull(options.getStreamLayout(), "streamLayout is null");
        this.userMetadata = ImmutableMap.builder().putAll(Objects.requireNonNull(userMetadata, "userMetadata is null")).put((Object)PRESTO_ORC_WRITER_VERSION_METADATA_KEY, (Object)PRESTO_ORC_WRITER_VERSION).build();
        this.metadataWriter = new CompressedMetadataWriter(orcEncoding.createMetadataWriter(), this.columnWriterOptions, Optional.empty());
        this.hiveStorageTimeZone = Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        this.orcTypes = OrcType.createOrcRowType(0, columnNames, types);
        this.recordValidation(validation -> validation.setColumnNames(columnNames));
        this.dwrfWriterEncryption = Objects.requireNonNull(encryption, "encryption is null");
        this.dwrfEncryptionProvider = Objects.requireNonNull(dwrfEncryptionProvider, "dwrfEncryptionProvider is null");
        if (this.dwrfWriterEncryption.isPresent()) {
            List<WriterEncryptionGroup> writerEncryptionGroups = this.dwrfWriterEncryption.get().getWriterEncryptionGroups();
            Map<Integer, Integer> nodeToGroupMap = DwrfEncryptionInfo.createNodeToGroupMap((List)writerEncryptionGroups.stream().map(WriterEncryptionGroup::getNodes).collect(ImmutableList.toImmutableList()), this.orcTypes);
            EncryptionLibrary encryptionLibrary = dwrfEncryptionProvider.getEncryptionLibrary(this.dwrfWriterEncryption.get().getKeyProvider());
            List dataEncryptionKeys = (List)writerEncryptionGroups.stream().map(group -> encryptionLibrary.generateDataEncryptionKey(group.getIntermediateKeyMetadata().getBytes())).collect(ImmutableList.toImmutableList());
            Map dwrfEncryptors = (Map)IntStream.range(0, writerEncryptionGroups.size()).boxed().collect(ImmutableMap.toImmutableMap(groupId -> groupId, groupId -> new DwrfDataEncryptor((byte[])dataEncryptionKeys.get((int)groupId), encryptionLibrary)));
            List encryptedKeyMetadatas = (List)IntStream.range(0, writerEncryptionGroups.size()).boxed().map(groupId -> encryptionLibrary.encryptKey(((WriterEncryptionGroup)writerEncryptionGroups.get((int)groupId)).getIntermediateKeyMetadata().getBytes(), (byte[])dataEncryptionKeys.get((int)groupId), 0, ((byte[])dataEncryptionKeys.get((int)groupId)).length)).collect(ImmutableList.toImmutableList());
            this.dwrfEncryptionInfo = new DwrfEncryptionInfo(dwrfEncryptors, encryptedKeyMetadatas, nodeToGroupMap);
        } else {
            this.dwrfEncryptionInfo = DwrfEncryptionInfo.UNENCRYPTED;
        }
        OrcType rootType = this.orcTypes.get(0);
        Preconditions.checkArgument((rootType.getFieldCount() == types.size() ? 1 : 0) != 0);
        ImmutableList.Builder columnWriters = ImmutableList.builder();
        ImmutableSet.Builder dictionaryColumnWriters = ImmutableSet.builder();
        for (int fieldId = 0; fieldId < types.size(); ++fieldId) {
            int fieldColumnIndex = rootType.getFieldTypeIndex(fieldId);
            Type fieldType = types.get(fieldId);
            ColumnWriter columnWriter = ColumnWriters.createColumnWriter(fieldColumnIndex, this.orcTypes, fieldType, this.columnWriterOptions, orcEncoding, hiveStorageTimeZone, this.dwrfEncryptionInfo, orcEncoding.createMetadataWriter());
            columnWriters.add((Object)columnWriter);
            if (columnWriter instanceof DictionaryColumnWriter) {
                dictionaryColumnWriters.add((Object)((DictionaryColumnWriter)columnWriter));
                continue;
            }
            for (ColumnWriter nestedColumnWriter : columnWriter.getNestedColumnWriters()) {
                if (!(nestedColumnWriter instanceof DictionaryColumnWriter)) continue;
                dictionaryColumnWriters.add((Object)((DictionaryColumnWriter)nestedColumnWriter));
            }
        }
        this.columnWriters = columnWriters.build();
        this.dictionaryMaxMemoryBytes = Math.toIntExact(Objects.requireNonNull(options.getDictionaryMaxMemory(), "dictionaryMaxMemory is null").toBytes());
        this.dictionaryCompressionOptimizer = new DictionaryCompressionOptimizer((Set<? extends DictionaryCompressionOptimizer.DictionaryColumn>)dictionaryColumnWriters.build(), this.stripeMinBytes, this.stripeMaxBytes, this.stripeMaxRowCount, this.dictionaryMaxMemoryBytes);
        for (Map.Entry<String, String> entry : this.userMetadata.entrySet()) {
            this.recordValidation(validation -> validation.addMetadataProperty((String)entry.getKey(), Slices.utf8Slice((String)((String)entry.getValue()))));
        }
        this.previouslyRecordedSizeInBytes = this.getRetainedBytes();
        stats.updateSizeInBytes(this.previouslyRecordedSizeInBytes);
    }

    @VisibleForTesting
    List<ColumnWriter> getColumnWriters() {
        return this.columnWriters;
    }

    @VisibleForTesting
    DictionaryCompressionOptimizer getDictionaryCompressionOptimizer() {
        return this.dictionaryCompressionOptimizer;
    }

    public long getWrittenBytes() {
        return this.dataSink.size();
    }

    public int getBufferedBytes() {
        return this.bufferedBytes;
    }

    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.columnWritersRetainedBytes + this.closedStripesRetainedBytes + this.dataSink.getRetainedSizeInBytes() + (this.validationBuilder == null ? 0L : this.validationBuilder.getRetainedSize());
    }

    public void write(Page page) throws IOException {
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        Preconditions.checkArgument((page.getChannelCount() == this.columnWriters.size() ? 1 : 0) != 0);
        if (this.validationBuilder != null) {
            this.validationBuilder.addPage((Page)page);
        }
        double averageLogicalSizePerRow = (double)page.getApproximateLogicalSizeInBytes() / (double)page.getPositionCount();
        int maxChunkRowCount = Math.max(1, (int)((double)this.chunkMaxLogicalBytes / Math.max(1.0, averageLogicalSizePerRow)));
        while (page != null) {
            int chunkRows = Integer.min(maxChunkRowCount, Integer.min(this.rowGroupMaxRowCount - this.rowGroupRowCount, this.stripeMaxRowCount - this.stripeRowCount));
            chunkRows = Integer.min(page.getPositionCount(), chunkRows);
            Page chunk = page.getRegion(0, chunkRows);
            page = chunkRows < page.getPositionCount() ? page.getRegion(chunkRows, page.getPositionCount() - chunkRows) : null;
            this.writeChunk(chunk);
        }
        long recordedSizeInBytes = this.getRetainedBytes();
        this.stats.updateSizeInBytes(recordedSizeInBytes - this.previouslyRecordedSizeInBytes);
        this.previouslyRecordedSizeInBytes = recordedSizeInBytes;
    }

    private void writeChunk(Page chunk) throws IOException {
        if (this.rowGroupRowCount == 0) {
            this.columnWriters.forEach(ColumnWriter::beginRowGroup);
        }
        this.bufferedBytes = 0;
        for (int channel = 0; channel < chunk.getChannelCount(); ++channel) {
            ColumnWriter writer = this.columnWriters.get(channel);
            writer.writeBlock(chunk.getBlock(channel));
            this.bufferedBytes = (int)((long)this.bufferedBytes + writer.getBufferedBytes());
        }
        this.rowGroupRowCount += chunk.getPositionCount();
        Preconditions.checkState((this.rowGroupRowCount <= this.rowGroupMaxRowCount ? 1 : 0) != 0);
        this.stripeRowCount += chunk.getPositionCount();
        if (this.rowGroupRowCount == this.rowGroupMaxRowCount) {
            this.finishRowGroup();
        }
        this.dictionaryCompressionOptimizer.optimize(this.bufferedBytes, this.stripeRowCount);
        this.bufferedBytes = Math.toIntExact(this.columnWriters.stream().mapToLong(ColumnWriter::getBufferedBytes).sum());
        if (this.stripeRowCount == this.stripeMaxRowCount) {
            this.flushStripe(WriterStats.FlushReason.MAX_ROWS);
        } else if (this.bufferedBytes > this.stripeMaxBytes) {
            this.flushStripe(WriterStats.FlushReason.MAX_BYTES);
        } else if (this.dictionaryCompressionOptimizer.isFull(this.bufferedBytes)) {
            this.flushStripe(WriterStats.FlushReason.DICTIONARY_FULL);
        }
        this.columnWritersRetainedBytes = this.columnWriters.stream().mapToLong(ColumnWriter::getRetainedBytes).sum();
    }

    private void finishRowGroup() {
        HashMap columnStatistics = new HashMap();
        this.columnWriters.forEach(columnWriter -> columnStatistics.putAll(columnWriter.finishRowGroup()));
        this.recordValidation(validation -> validation.addRowGroupStatistics(columnStatistics));
        this.rowGroupRowCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushStripe(WriterStats.FlushReason flushReason) throws IOException {
        ArrayList<DataOutput> outputData = new ArrayList<DataOutput>();
        long stripeStartOffset = this.dataSink.size();
        if (this.closedStripes.isEmpty()) {
            outputData.add(DataOutput.createDataOutput((Slice)PostScript.MAGIC));
            stripeStartOffset += (long)PostScript.MAGIC.length();
        }
        this.flushColumnWriters(flushReason);
        try {
            outputData.addAll(this.bufferStripeData(stripeStartOffset, flushReason));
            if (flushReason == WriterStats.FlushReason.CLOSED) {
                outputData.addAll(this.bufferFileFooter());
            }
            this.dataSink.write(outputData);
        }
        finally {
            this.columnWriters.forEach(ColumnWriter::reset);
            this.dictionaryCompressionOptimizer.reset();
            this.rowGroupRowCount = 0;
            this.stripeRowCount = 0;
            this.bufferedBytes = Math.toIntExact(this.columnWriters.stream().mapToLong(ColumnWriter::getBufferedBytes).sum());
        }
    }

    private void flushColumnWriters(WriterStats.FlushReason flushReason) {
        if (this.stripeRowCount == 0) {
            Verify.verify((flushReason == WriterStats.FlushReason.CLOSED ? 1 : 0) != 0, (String)"An empty stripe is not allowed", (Object[])new Object[0]);
        } else {
            if (this.rowGroupRowCount > 0) {
                this.finishRowGroup();
            }
            this.dictionaryCompressionOptimizer.finalOptimize(this.bufferedBytes);
        }
        this.columnWriters.forEach(ColumnWriter::close);
    }

    private List<DataOutput> bufferStripeData(long stripeStartOffset, WriterStats.FlushReason flushReason) throws IOException {
        if (this.stripeRowCount == 0) {
            return ImmutableList.of();
        }
        ArrayList<DataOutput> outputData = new ArrayList<DataOutput>();
        ArrayList<Stream> unencryptedStreams = new ArrayList<Stream>(this.columnWriters.size() * 3);
        ArrayListMultimap encryptedStreams = ArrayListMultimap.create();
        long indexLength = 0L;
        long offset = 0L;
        int previousEncryptionGroup = -1;
        for (ColumnWriter columnWriter2 : this.columnWriters) {
            for (StreamDataOutput streamDataOutput : columnWriter2.getIndexStreams()) {
                Stream stream;
                outputData.add(streamDataOutput);
                Optional<Integer> encryptionGroup = this.dwrfEncryptionInfo.getGroupByNodeId(streamDataOutput.getStream().getColumn());
                if (encryptionGroup.isPresent()) {
                    stream = previousEncryptionGroup == encryptionGroup.get() ? streamDataOutput.getStream() : streamDataOutput.getStream().withOffset(offset);
                    encryptedStreams.put((Object)encryptionGroup.get(), (Object)stream);
                    previousEncryptionGroup = encryptionGroup.get();
                } else {
                    stream = previousEncryptionGroup == -1 ? streamDataOutput.getStream() : streamDataOutput.getStream().withOffset(offset);
                    unencryptedStreams.add(stream);
                    previousEncryptionGroup = -1;
                }
                offset += streamDataOutput.size();
                indexLength += streamDataOutput.size();
            }
        }
        long dataLength = 0L;
        ArrayList<StreamDataOutput> dataStreams = new ArrayList<StreamDataOutput>(this.columnWriters.size() * 2);
        for (ColumnWriter columnWriter3 : this.columnWriters) {
            List<StreamDataOutput> streams = columnWriter3.getDataStreams();
            dataStreams.addAll(streams);
            dataLength += streams.stream().mapToLong(StreamDataOutput::size).sum();
        }
        this.streamLayout.reorder(dataStreams);
        for (StreamDataOutput dataStream : dataStreams) {
            Stream stream;
            outputData.add(dataStream);
            Optional<Integer> encryptionGroup = this.dwrfEncryptionInfo.getGroupByNodeId(dataStream.getStream().getColumn());
            if (encryptionGroup.isPresent()) {
                stream = previousEncryptionGroup == encryptionGroup.get() ? dataStream.getStream() : dataStream.getStream().withOffset(offset);
                encryptedStreams.put((Object)encryptionGroup.get(), (Object)stream);
                previousEncryptionGroup = encryptionGroup.get();
            } else {
                stream = previousEncryptionGroup == -1 ? dataStream.getStream() : dataStream.getStream().withOffset(offset);
                unencryptedStreams.add(stream);
                previousEncryptionGroup = -1;
            }
            offset += dataStream.size();
        }
        HashMap<Integer, ColumnEncoding> hashMap = new HashMap<Integer, ColumnEncoding>();
        this.columnWriters.forEach(columnWriter -> columnEncodings.putAll(columnWriter.getColumnEncodings()));
        HashMap<Integer, ColumnStatistics> columnStatistics = new HashMap<Integer, ColumnStatistics>();
        this.columnWriters.forEach(columnWriter -> columnStatistics.putAll(columnWriter.getColumnStripeStatistics()));
        hashMap.put(0, new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0));
        columnStatistics.put(0, new ColumnStatistics(Long.valueOf(this.stripeRowCount), 0L, null, null, null, null, null, null, null, null));
        Map unencryptedColumnEncodings = (Map)hashMap.entrySet().stream().filter(entry -> !this.dwrfEncryptionInfo.getGroupByNodeId((Integer)entry.getKey()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Map encryptedColumnEncodings = (Map)hashMap.entrySet().stream().filter(entry -> this.dwrfEncryptionInfo.getGroupByNodeId((Integer)entry.getKey()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        List<Slice> encryptedGroups = this.createEncryptedGroups((Multimap<Integer, Stream>)encryptedStreams, encryptedColumnEncodings);
        StripeFooter stripeFooter = new StripeFooter(unencryptedStreams, unencryptedColumnEncodings, encryptedGroups);
        Slice footer = this.metadataWriter.writeStripeFooter(stripeFooter);
        outputData.add(DataOutput.createDataOutput((Slice)footer));
        StripeStatistics statistics = new StripeStatistics(OrcWriter.toDenseList(columnStatistics, this.orcTypes.size()));
        this.recordValidation(validation -> validation.addStripeStatistics(stripeStartOffset, statistics));
        StripeInformation stripeInformation = new StripeInformation(this.stripeRowCount, stripeStartOffset, indexLength, dataLength, footer.length(), this.dwrfEncryptionInfo.getEncryptedKeyMetadatas());
        ClosedStripe closedStripe = new ClosedStripe(stripeInformation, statistics);
        this.closedStripes.add(closedStripe);
        this.closedStripesRetainedBytes += closedStripe.getRetainedSizeInBytes();
        this.recordValidation(validation -> validation.addStripe(stripeInformation.getNumberOfRows()));
        this.stats.recordStripeWritten(this.stripeMinBytes, this.stripeMaxBytes, this.dictionaryMaxMemoryBytes, flushReason, this.dictionaryCompressionOptimizer.getDictionaryMemoryBytes(), stripeInformation);
        return outputData;
    }

    private List<Slice> createEncryptedGroups(Multimap<Integer, Stream> encryptedStreams, Map<Integer, ColumnEncoding> encryptedColumnEncodings) throws IOException {
        ImmutableList.Builder encryptedGroups = ImmutableList.builder();
        for (int i = 0; i < encryptedStreams.keySet().size(); ++i) {
            int groupId = i;
            Map groupColumnEncodings = (Map)encryptedColumnEncodings.entrySet().stream().filter(entry -> this.dwrfEncryptionInfo.getGroupByNodeId((Integer)entry.getKey()).orElseThrow(() -> new VerifyError("missing group for encryptedColumn")) == groupId).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            DwrfDataEncryptor dwrfDataEncryptor = this.dwrfEncryptionInfo.getEncryptorByGroupId(i);
            OrcOutputBuffer buffer = new OrcOutputBuffer(this.columnWriterOptions, Optional.of(dwrfDataEncryptor));
            DwrfMetadataWriter.toStripeEncryptionGroup(new StripeEncryptionGroup((List<Stream>)ImmutableList.copyOf((Collection)encryptedStreams.get((Object)i)), groupColumnEncodings)).writeTo((OutputStream)((Object)buffer));
            buffer.close();
            DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(buffer.getOutputDataSize()));
            buffer.writeDataTo((SliceOutput)output);
            encryptedGroups.add((Object)output.slice());
        }
        return encryptedGroups.build();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stats.updateSizeInBytes(-this.previouslyRecordedSizeInBytes);
        this.previouslyRecordedSizeInBytes = 0L;
        this.flushStripe(WriterStats.FlushReason.CLOSED);
        this.dataSink.close();
    }

    private List<DataOutput> bufferFileFooter() throws IOException {
        Optional<DwrfEncryption> dwrfEncryption;
        ArrayList<DataOutput> outputData = new ArrayList<DataOutput>();
        Metadata metadata = new Metadata(this.closedStripes.stream().map(ClosedStripe::getStatistics).collect(Collectors.toList()));
        Slice metadataSlice = this.metadataWriter.writeMetadata(metadata);
        outputData.add(DataOutput.createDataOutput((Slice)metadataSlice));
        long numberOfRows = this.closedStripes.stream().mapToLong(stripe -> stripe.getStripeInformation().getNumberOfRows()).sum();
        List<ColumnStatistics> fileStats = OrcWriter.toFileStats(this.closedStripes.stream().map(ClosedStripe::getStatistics).map(StripeStatistics::getColumnStatistics).collect(Collectors.toList()));
        this.recordValidation(validation -> validation.setFileStatistics(fileStats));
        Map<String, Slice> userMetadata = this.userMetadata.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Slices.utf8Slice((String)((String)entry.getValue()))));
        ArrayList<ColumnStatistics> unencryptedStats = new ArrayList<ColumnStatistics>();
        HashMap<Integer, Map<Integer, Slice>> encryptedStats = new HashMap<Integer, Map<Integer, Slice>>();
        this.addStatsRecursive(fileStats, 0, new HashMap<Integer, List<ColumnStatistics>>(), unencryptedStats, encryptedStats);
        if (this.dwrfWriterEncryption.isPresent()) {
            ImmutableList.Builder encryptionGroupBuilder = ImmutableList.builder();
            List<WriterEncryptionGroup> writerEncryptionGroups = this.dwrfWriterEncryption.get().getWriterEncryptionGroups();
            for (int i = 0; i < writerEncryptionGroups.size(); ++i) {
                WriterEncryptionGroup group = writerEncryptionGroups.get(i);
                Map groupStats = (Map)encryptedStats.get(i);
                encryptionGroupBuilder.add((Object)new EncryptionGroup(group.getNodes(), Optional.empty(), group.getNodes().stream().map(groupStats::get).collect(Collectors.toList())));
            }
            dwrfEncryption = Optional.of(new DwrfEncryption(this.dwrfWriterEncryption.get().getKeyProvider(), (List<EncryptionGroup>)encryptionGroupBuilder.build()));
        } else {
            dwrfEncryption = Optional.empty();
        }
        Footer footer = new Footer(numberOfRows, this.rowGroupMaxRowCount, this.closedStripes.stream().map(ClosedStripe::getStripeInformation).collect(Collectors.toList()), this.orcTypes, (List<ColumnStatistics>)ImmutableList.copyOf(unencryptedStats), userMetadata, dwrfEncryption);
        this.closedStripes.clear();
        this.closedStripesRetainedBytes = 0L;
        Slice footerSlice = this.metadataWriter.writeFooter(footer);
        outputData.add(DataOutput.createDataOutput((Slice)footerSlice));
        this.recordValidation(validation -> validation.setVersion(this.metadataWriter.getOrcMetadataVersion()));
        Slice postscriptSlice = this.metadataWriter.writePostscript(footerSlice.length(), metadataSlice.length(), this.columnWriterOptions.getCompressionKind(), this.columnWriterOptions.getCompressionMaxBufferSize());
        outputData.add(DataOutput.createDataOutput((Slice)postscriptSlice));
        outputData.add(DataOutput.createDataOutput((Slice)Slices.wrappedBuffer((byte[])new byte[]{(byte)postscriptSlice.length()})));
        return outputData;
    }

    private void addStatsRecursive(List<ColumnStatistics> allStats, int index, Map<Integer, List<ColumnStatistics>> nodeAndSubNodeStats, List<ColumnStatistics> unencryptedStats, Map<Integer, Map<Integer, Slice>> encryptedStats) throws IOException {
        if (allStats.isEmpty()) {
            return;
        }
        ColumnStatistics columnStatistics = allStats.get(index);
        if (this.dwrfEncryptionInfo.getGroupByNodeId(index).isPresent()) {
            int group = this.dwrfEncryptionInfo.getGroupByNodeId(index).get();
            boolean isRootNode = this.dwrfWriterEncryption.get().getWriterEncryptionGroups().get(group).getNodes().contains(index);
            Verify.verify((isRootNode && nodeAndSubNodeStats.isEmpty() || nodeAndSubNodeStats.size() == 1 && nodeAndSubNodeStats.get(group) != null ? 1 : 0) != 0, (String)"nodeAndSubNodeStats should only be present for subnodes of a group", (Object[])new Object[0]);
            nodeAndSubNodeStats.computeIfAbsent(group, x -> new ArrayList()).add(columnStatistics);
            unencryptedStats.add(new ColumnStatistics(columnStatistics.getNumberOfValues(), columnStatistics.getMinAverageValueSizeInBytes(), null, null, null, null, null, null, null, null));
            for (Integer fieldIndex : this.orcTypes.get(index).getFieldTypeIndexes()) {
                this.addStatsRecursive(allStats, fieldIndex, nodeAndSubNodeStats, unencryptedStats, encryptedStats);
            }
            if (isRootNode) {
                Slice encryptedFileStatistics = this.toEncryptedFileStatistics(nodeAndSubNodeStats.get(group), group);
                encryptedStats.computeIfAbsent(group, x -> new HashMap()).put(index, encryptedFileStatistics);
            }
        } else {
            unencryptedStats.add(columnStatistics);
            for (Integer fieldIndex : this.orcTypes.get(index).getFieldTypeIndexes()) {
                this.addStatsRecursive(allStats, fieldIndex, new HashMap<Integer, List<ColumnStatistics>>(), unencryptedStats, encryptedStats);
            }
        }
    }

    private Slice toEncryptedFileStatistics(List<ColumnStatistics> statsFromRoot, int groupId) throws IOException {
        DwrfProto.FileStatistics fileStatistics = DwrfMetadataWriter.toFileStatistics(statsFromRoot);
        DwrfDataEncryptor dwrfDataEncryptor = this.dwrfEncryptionInfo.getEncryptorByGroupId(groupId);
        OrcOutputBuffer buffer = new OrcOutputBuffer(this.columnWriterOptions, Optional.of(dwrfDataEncryptor));
        fileStatistics.writeTo((OutputStream)((Object)buffer));
        buffer.close();
        DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(buffer.getOutputDataSize()));
        buffer.writeDataTo((SliceOutput)output);
        return output.slice();
    }

    private void recordValidation(Consumer<OrcWriteValidation.OrcWriteValidationBuilder> task) {
        if (this.validationBuilder != null) {
            task.accept(this.validationBuilder);
        }
    }

    public void validate(OrcDataSource input) throws OrcCorruptionException {
        Preconditions.checkState((this.validationBuilder != null ? 1 : 0) != 0, (Object)"validation is not enabled");
        ImmutableMap.Builder intermediateKeyMetadata = ImmutableMap.builder();
        if (this.dwrfWriterEncryption.isPresent()) {
            List<WriterEncryptionGroup> writerEncryptionGroups = this.dwrfWriterEncryption.get().getWriterEncryptionGroups();
            for (int i = 0; i < writerEncryptionGroups.size(); ++i) {
                for (Integer node : writerEncryptionGroups.get(i).getNodes()) {
                    intermediateKeyMetadata.put((Object)node, (Object)writerEncryptionGroups.get(i).getIntermediateKeyMetadata());
                }
            }
        }
        OrcReader.validateFile(this.validationBuilder.build(), input, this.types, this.hiveStorageTimeZone, this.orcEncoding, new OrcReaderOptions(new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), new DataSize(16.0, DataSize.Unit.MEGABYTE), false), this.dwrfEncryptionProvider, DwrfKeyProvider.of((Map<Integer, Slice>)intermediateKeyMetadata.build()));
    }

    private static <T> List<T> toDenseList(Map<Integer, T> data, int expectedSize) {
        Preconditions.checkArgument((data.size() == expectedSize ? 1 : 0) != 0);
        if (expectedSize == 0) {
            return ImmutableList.of();
        }
        ArrayList<T> list = new ArrayList<T>(expectedSize);
        TreeSet<Integer> sortedKeys = new TreeSet<Integer>();
        sortedKeys.addAll(data.keySet());
        for (Integer key : sortedKeys) {
            list.add(data.get(key));
        }
        return ImmutableList.copyOf(list);
    }

    private static List<ColumnStatistics> toFileStats(List<List<ColumnStatistics>> stripes) {
        if (stripes.isEmpty()) {
            return ImmutableList.of();
        }
        int columnCount = stripes.get(0).size();
        Preconditions.checkArgument((boolean)stripes.stream().allMatch(stripe -> columnCount == stripe.size()));
        ImmutableList.Builder fileStats = ImmutableList.builder();
        int i = 0;
        while (i < columnCount) {
            int column = i++;
            fileStats.add((Object)ColumnStatistics.mergeColumnStatistics(stripes.stream().map(stripe -> (ColumnStatistics)stripe.get(column)).collect(Collectors.toList())));
        }
        return fileStats.build();
    }

    static {
        String version = OrcWriter.class.getPackage().getImplementationVersion();
        PRESTO_ORC_WRITER_VERSION = version == null ? "UNKNOWN" : version;
    }

    private static class ClosedStripe {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(ClosedStripe.class).instanceSize() + ClassLayout.parseClass(StripeInformation.class).instanceSize();
        private final StripeInformation stripeInformation;
        private final StripeStatistics statistics;

        public ClosedStripe(StripeInformation stripeInformation, StripeStatistics statistics) {
            this.stripeInformation = Objects.requireNonNull(stripeInformation, "stripeInformation is null");
            this.statistics = Objects.requireNonNull(statistics, "stripeStatistics is null");
        }

        public StripeInformation getStripeInformation() {
            return this.stripeInformation;
        }

        public StripeStatistics getStatistics() {
            return this.statistics;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.statistics.getRetainedSizeInBytes();
        }
    }
}

