/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.StreamLayout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.OptionalInt;

public class OrcWriterOptions {
    private static final DataSize DEFAULT_STRIPE_MIN_SIZE = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_STRIPE_MAX_SIZE = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private static final int DEFAULT_STRIPE_MAX_ROW_COUNT = 10000000;
    private static final int DEFAULT_ROW_GROUP_MAX_ROW_COUNT = 10000;
    private static final DataSize DEFAULT_DICTIONARY_MAX_MEMORY = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    @VisibleForTesting
    static final DataSize DEFAULT_MAX_STRING_STATISTICS_LIMIT = new DataSize(64.0, DataSize.Unit.BYTE);
    @VisibleForTesting
    static final DataSize DEFAULT_MAX_COMPRESSION_BUFFER_SIZE = new DataSize(256.0, DataSize.Unit.KILOBYTE);
    private final DataSize stripeMinSize;
    private final DataSize stripeMaxSize;
    private final int stripeMaxRowCount;
    private final int rowGroupMaxRowCount;
    private final DataSize dictionaryMaxMemory;
    private final DataSize maxStringStatisticsLimit;
    private final DataSize maxCompressionBufferSize;
    private final OptionalInt compressionLevel;
    private final StreamLayout streamLayout;
    private final boolean integerDictionaryEncodingEnabled;

    public OrcWriterOptions() {
        this(DEFAULT_STRIPE_MIN_SIZE, DEFAULT_STRIPE_MAX_SIZE, 10000000, 10000, DEFAULT_DICTIONARY_MAX_MEMORY, DEFAULT_MAX_STRING_STATISTICS_LIMIT, DEFAULT_MAX_COMPRESSION_BUFFER_SIZE, OptionalInt.empty(), new StreamLayout.ByStreamSize(), false);
    }

    private OrcWriterOptions(DataSize stripeMinSize, DataSize stripeMaxSize, int stripeMaxRowCount, int rowGroupMaxRowCount, DataSize dictionaryMaxMemory, DataSize maxStringStatisticsLimit, DataSize maxCompressionBufferSize, OptionalInt compressionLevel, StreamLayout streamLayout, boolean integerDictionaryEncodingEnabled) {
        Objects.requireNonNull(stripeMinSize, "stripeMinSize is null");
        Objects.requireNonNull(stripeMaxSize, "stripeMaxSize is null");
        Preconditions.checkArgument((stripeMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"stripeMaxRowCount must be at least 1");
        Preconditions.checkArgument((rowGroupMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"rowGroupMaxRowCount must be at least 1");
        Objects.requireNonNull(dictionaryMaxMemory, "dictionaryMaxMemory is null");
        Objects.requireNonNull(maxStringStatisticsLimit, "maxStringStatisticsLimit is null");
        Objects.requireNonNull(maxCompressionBufferSize, "maxCompressionBufferSize is null");
        Objects.requireNonNull(compressionLevel, "compressionLevel is null");
        Objects.requireNonNull(streamLayout, "streamLayout is null");
        this.stripeMinSize = stripeMinSize;
        this.stripeMaxSize = stripeMaxSize;
        this.stripeMaxRowCount = stripeMaxRowCount;
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        this.dictionaryMaxMemory = dictionaryMaxMemory;
        this.maxStringStatisticsLimit = maxStringStatisticsLimit;
        this.maxCompressionBufferSize = maxCompressionBufferSize;
        this.compressionLevel = compressionLevel;
        this.streamLayout = streamLayout;
        this.integerDictionaryEncodingEnabled = integerDictionaryEncodingEnabled;
    }

    public DataSize getStripeMinSize() {
        return this.stripeMinSize;
    }

    public DataSize getStripeMaxSize() {
        return this.stripeMaxSize;
    }

    public int getStripeMaxRowCount() {
        return this.stripeMaxRowCount;
    }

    public int getRowGroupMaxRowCount() {
        return this.rowGroupMaxRowCount;
    }

    public DataSize getDictionaryMaxMemory() {
        return this.dictionaryMaxMemory;
    }

    public DataSize getMaxStringStatisticsLimit() {
        return this.maxStringStatisticsLimit;
    }

    public DataSize getMaxCompressionBufferSize() {
        return this.maxCompressionBufferSize;
    }

    public OptionalInt getCompressionLevel() {
        return this.compressionLevel;
    }

    public StreamLayout getStreamLayout() {
        return this.streamLayout;
    }

    public boolean isIntegerDictionaryEncodingEnabled() {
        return this.integerDictionaryEncodingEnabled;
    }

    public OrcWriterOptions withStripeMinSize(DataSize stripeMinSize) {
        return new OrcWriterOptions(stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.compressionLevel, this.streamLayout, this.integerDictionaryEncodingEnabled);
    }

    public OrcWriterOptions withStripeMaxSize(DataSize stripeMaxSize) {
        return new OrcWriterOptions(this.stripeMinSize, stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.compressionLevel, this.streamLayout, this.integerDictionaryEncodingEnabled);
    }

    public OrcWriterOptions withStripeMaxRowCount(int stripeMaxRowCount) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.compressionLevel, this.streamLayout, this.integerDictionaryEncodingEnabled);
    }

    public OrcWriterOptions withRowGroupMaxRowCount(int rowGroupMaxRowCount) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.compressionLevel, this.streamLayout, this.integerDictionaryEncodingEnabled);
    }

    public OrcWriterOptions withDictionaryMaxMemory(DataSize dictionaryMaxMemory) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.compressionLevel, this.streamLayout, this.integerDictionaryEncodingEnabled);
    }

    public OrcWriterOptions withMaxStringStatisticsLimit(DataSize maxStringStatisticsLimit) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, maxStringStatisticsLimit, this.maxCompressionBufferSize, this.compressionLevel, this.streamLayout, this.integerDictionaryEncodingEnabled);
    }

    public OrcWriterOptions withMaxCompressionBufferSize(DataSize maxCompressionBufferSize) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, maxCompressionBufferSize, this.compressionLevel, this.streamLayout, this.integerDictionaryEncodingEnabled);
    }

    public OrcWriterOptions withCompressionLevel(OptionalInt compressionLevel) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, compressionLevel, this.streamLayout, this.integerDictionaryEncodingEnabled);
    }

    public OrcWriterOptions withStreamLayout(StreamLayout streamLayout) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.compressionLevel, streamLayout, this.integerDictionaryEncodingEnabled);
    }

    public OrcWriterOptions withIntegerDictionaryEncodingEnabled(boolean integerDictionaryEncodingEnabled) {
        return new OrcWriterOptions(this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.compressionLevel, this.streamLayout, integerDictionaryEncodingEnabled);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stripeMinSize", (Object)this.stripeMinSize).add("stripeMaxSize", (Object)this.stripeMaxSize).add("stripeMaxRowCount", this.stripeMaxRowCount).add("rowGroupMaxRowCount", this.rowGroupMaxRowCount).add("dictionaryMaxMemory", (Object)this.dictionaryMaxMemory).add("maxStringStatisticsLimit", (Object)this.maxStringStatisticsLimit).add("maxCompressionBufferSize", (Object)this.maxCompressionBufferSize).add("compressionLevel", (Object)this.compressionLevel).add("streamLayout", (Object)this.streamLayout).add("integerDictionaryEncodingEnabled", this.integerDictionaryEncodingEnabled).toString();
    }
}

