/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class DecimalStatistics
implements RangeStatistics<BigDecimal>,
StatisticsHasher.Hashable {
    public static final long DECIMAL_VALUE_BYTES_OVERHEAD = 1L;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecimalStatistics.class).instanceSize();
    private static final long BIG_DECIMAL_INSTANCE_SIZE = (long)(ClassLayout.parseClass(BigDecimal.class).instanceSize() + ClassLayout.parseClass(BigInteger.class).instanceSize()) + SizeOf.sizeOf((int[])new int[0]);
    private final BigDecimal minimum;
    private final BigDecimal maximum;
    private final long retainedSizeInBytes;

    public DecimalStatistics(BigDecimal minimum, BigDecimal maximum, long decimalSizeInBytes) {
        Preconditions.checkArgument((minimum == null || maximum == null || minimum.compareTo(maximum) <= 0 ? 1 : 0) != 0, (Object)"minimum is not less than maximum");
        this.minimum = minimum;
        this.maximum = maximum;
        long retainedSizeInBytes = 0L;
        if (minimum != null) {
            retainedSizeInBytes += BIG_DECIMAL_INSTANCE_SIZE + decimalSizeInBytes;
        }
        if (maximum != null && minimum != maximum) {
            retainedSizeInBytes += BIG_DECIMAL_INSTANCE_SIZE + decimalSizeInBytes;
        }
        this.retainedSizeInBytes = retainedSizeInBytes + (long)INSTANCE_SIZE;
    }

    @Override
    public BigDecimal getMin() {
        return this.minimum;
    }

    @Override
    public BigDecimal getMax() {
        return this.maximum;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalStatistics that = (DecimalStatistics)o;
        return Objects.equals(this.minimum, that.minimum) && Objects.equals(this.maximum, that.maximum);
    }

    public int hashCode() {
        return Objects.hash(this.minimum, this.maximum);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minimum", (Object)this.minimum).add("maximum", (Object)this.maximum).toString();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        hasher.putOptionalBigDecimal(this.minimum).putOptionalBigDecimal(this.maximum);
    }
}

