/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class StripeStatistics {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(StripeStatistics.class).instanceSize();
    private final List<ColumnStatistics> columnStatistics;
    private final long retainedSizeInBytes;

    public StripeStatistics(List<ColumnStatistics> columnStatistics) {
        this.columnStatistics = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnStatistics, "columnStatistics is null"));
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + columnStatistics.stream().mapToLong(ColumnStatistics::getRetainedSizeInBytes).sum();
    }

    public List<ColumnStatistics> getColumnStatistics() {
        return this.columnStatistics;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StripeStatistics that = (StripeStatistics)o;
        return Objects.equals(this.columnStatistics, that.columnStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.columnStatistics);
    }
}

