/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;

public class CallQueueManager<E> {
    public static final Log LOG = LogFactory.getLog(CallQueueManager.class);
    private final boolean clientBackOffEnabled;
    private final AtomicReference<BlockingQueue<E>> putRef;
    private final AtomicReference<BlockingQueue<E>> takeRef;

    static <E> Class<? extends BlockingQueue<E>> convertQueueClass(Class<?> queneClass, Class<E> elementClass) {
        return queneClass;
    }

    public CallQueueManager(Class<? extends BlockingQueue<E>> backingClass, boolean clientBackOffEnabled, int maxQueueSize, String namespace, Configuration conf) {
        BlockingQueue<E> bq = this.createCallQueueInstance(backingClass, maxQueueSize, namespace, conf);
        this.clientBackOffEnabled = clientBackOffEnabled;
        this.putRef = new AtomicReference<BlockingQueue<E>>(bq);
        this.takeRef = new AtomicReference<BlockingQueue<E>>(bq);
        LOG.info("Using callQueue: " + backingClass + " queueCapacity: " + maxQueueSize);
    }

    private <T extends BlockingQueue<E>> T createCallQueueInstance(Class<T> theClass, int maxLen, String ns, Configuration conf) {
        try {
            Constructor<T> ctor = theClass.getDeclaredConstructor(Integer.TYPE, String.class, Configuration.class);
            return (T)((BlockingQueue)ctor.newInstance(maxLen, ns, conf));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(theClass.getName() + " could not be constructed.", e.getCause());
        }
        catch (Exception e) {
            try {
                Constructor<T> ctor = theClass.getDeclaredConstructor(Integer.TYPE);
                return (T)((BlockingQueue)ctor.newInstance(maxLen));
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (InvocationTargetException e3) {
                throw new RuntimeException(theClass.getName() + " could not be constructed.", e3.getCause());
            }
            catch (Exception e3) {
                try {
                    Constructor<T> ctor = theClass.getDeclaredConstructor(new Class[0]);
                    return (T)((BlockingQueue)ctor.newInstance(new Object[0]));
                }
                catch (RuntimeException e4) {
                    throw e4;
                }
                catch (InvocationTargetException e5) {
                    throw new RuntimeException(theClass.getName() + " could not be constructed.", e5.getCause());
                }
                catch (Exception exception) {
                    throw new RuntimeException(theClass.getName() + " could not be constructed.");
                }
            }
        }
    }

    boolean isClientBackoffEnabled() {
        return this.clientBackOffEnabled;
    }

    public void put(E e) throws InterruptedException {
        this.putRef.get().put(e);
    }

    public boolean offer(E e) throws InterruptedException {
        return this.putRef.get().offer(e);
    }

    public E take() throws InterruptedException {
        E e = null;
        while (e == null) {
            e = this.takeRef.get().poll(1000L, TimeUnit.MILLISECONDS);
        }
        return e;
    }

    public int size() {
        return this.takeRef.get().size();
    }

    public synchronized void swapQueue(Class<? extends BlockingQueue<E>> queueClassToUse, int maxSize, String ns, Configuration conf) {
        BlockingQueue<E> newQ = this.createCallQueueInstance(queueClassToUse, maxSize, ns, conf);
        BlockingQueue<E> oldQ = this.putRef.get();
        this.putRef.set(newQ);
        while (!this.queueIsReallyEmpty(oldQ)) {
        }
        this.takeRef.set(newQ);
        LOG.info("Old Queue: " + this.stringRepr(oldQ) + ", " + "Replacement: " + this.stringRepr(newQ));
    }

    private boolean queueIsReallyEmpty(BlockingQueue<?> q) {
        boolean wasEmpty = q.isEmpty();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException ie) {
            return false;
        }
        return q.isEmpty() && wasEmpty;
    }

    private String stringRepr(Object o) {
        return o.getClass().getName() + '@' + Integer.toHexString(o.hashCode());
    }
}

