/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.spring;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.spring.SpringDataSourceConnectionFactory;
import org.skife.jdbi.v2.tweak.StatementLocator;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class DBIFactoryBean
implements FactoryBean<IDBI>,
InitializingBean {
    private DataSource dataSource;
    private StatementLocator statementLocator;
    private final Map<String, Object> globalDefines = new HashMap<String, Object>();

    public DBIFactoryBean() {
    }

    public DBIFactoryBean(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBIFactoryBean(DataSource dataSource, StatementLocator statementLocator) {
        this.dataSource = dataSource;
        this.statementLocator = statementLocator;
    }

    public IDBI getObject() throws Exception {
        DBI dbi = new DBI(new SpringDataSourceConnectionFactory(this.dataSource));
        if (this.statementLocator != null) {
            dbi.setStatementLocator(this.statementLocator);
        }
        for (Map.Entry<String, Object> entry : this.globalDefines.entrySet()) {
            dbi.define(entry.getKey(), entry.getValue());
        }
        return dbi;
    }

    public Class<IDBI> getObjectType() {
        return IDBI.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setStatementLocator(StatementLocator statementLocator) {
        this.statementLocator = statementLocator;
    }

    public void setGlobalDefines(Map<String, Object> defines) {
        this.globalDefines.putAll(defines);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataSource == null) {
            throw new IllegalStateException("'dataSource' property must be set");
        }
    }
}

