/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.lang.reflect.Method;
import org.skife.jdbi.cglib.proxy.MethodProxy;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.Handler;

class PassThroughHandler
implements Handler {
    private final Method method;

    PassThroughHandler(Method method) {
        this.method = method;
    }

    @Override
    public Object invoke(HandleDing ding, Object target, Object[] args, MethodProxy mp) {
        try {
            return mp.invokeSuper(target, args);
        }
        catch (AbstractMethodError e) {
            AbstractMethodError error = new AbstractMethodError("Method " + this.method.getDeclaringClass().getName() + "#" + this.method.getName() + " doesn't make sense -- it probably needs a @Sql* annotation of some kind.");
            error.initCause(e);
            throw error;
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }
}

