/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.zookeeper.server.command;

import alluxio.shaded.client.org.apache.zookeeper.server.ServerCnxn;
import alluxio.shaded.client.org.apache.zookeeper.server.ServerCnxnFactory;
import alluxio.shaded.client.org.apache.zookeeper.server.ZooKeeperServer;
import alluxio.shaded.client.org.apache.zookeeper.server.command.AbstractFourLetterCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.CnxnStatResetCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.ConfCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.ConsCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.DirsCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.DumpCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.EnvCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.FourLetterCommands;
import alluxio.shaded.client.org.apache.zookeeper.server.command.IsroCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.MonitorCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.RuokCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.StatCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.StatResetCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.TraceMaskCommand;
import alluxio.shaded.client.org.apache.zookeeper.server.command.WatchCommand;
import java.io.PrintWriter;

public class CommandExecutor {
    public boolean execute(ServerCnxn serverCnxn, PrintWriter pwriter, int commandCode, ZooKeeperServer zkServer, ServerCnxnFactory factory) {
        AbstractFourLetterCommand command = this.getCommand(serverCnxn, pwriter, commandCode);
        if (command == null) {
            return false;
        }
        command.setZkServer(zkServer);
        command.setFactory(factory);
        command.start();
        return true;
    }

    private AbstractFourLetterCommand getCommand(ServerCnxn serverCnxn, PrintWriter pwriter, int commandCode) {
        AbstractFourLetterCommand command = null;
        if (commandCode == FourLetterCommands.ruokCmd) {
            command = new RuokCommand(pwriter, serverCnxn);
        } else if (commandCode == FourLetterCommands.getTraceMaskCmd) {
            command = new TraceMaskCommand(pwriter, serverCnxn);
        } else if (commandCode == FourLetterCommands.enviCmd) {
            command = new EnvCommand(pwriter, serverCnxn);
        } else if (commandCode == FourLetterCommands.confCmd) {
            command = new ConfCommand(pwriter, serverCnxn);
        } else if (commandCode == FourLetterCommands.srstCmd) {
            command = new StatResetCommand(pwriter, serverCnxn);
        } else if (commandCode == FourLetterCommands.crstCmd) {
            command = new CnxnStatResetCommand(pwriter, serverCnxn);
        } else if (commandCode == FourLetterCommands.dirsCmd) {
            command = new DirsCommand(pwriter, serverCnxn);
        } else if (commandCode == FourLetterCommands.dumpCmd) {
            command = new DumpCommand(pwriter, serverCnxn);
        } else if (commandCode == FourLetterCommands.statCmd || commandCode == FourLetterCommands.srvrCmd) {
            command = new StatCommand(pwriter, serverCnxn, commandCode);
        } else if (commandCode == FourLetterCommands.consCmd) {
            command = new ConsCommand(pwriter, serverCnxn);
        } else if (commandCode == FourLetterCommands.wchpCmd || commandCode == FourLetterCommands.wchcCmd || commandCode == FourLetterCommands.wchsCmd) {
            command = new WatchCommand(pwriter, serverCnxn, commandCode);
        } else if (commandCode == FourLetterCommands.mntrCmd) {
            command = new MonitorCommand(pwriter, serverCnxn);
        } else if (commandCode == FourLetterCommands.isroCmd) {
            command = new IsroCommand(pwriter, serverCnxn);
        }
        return command;
    }
}

