/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.raptor.RaptorMetadata;
import com.facebook.presto.raptor.RaptorMetadataFactory;
import com.facebook.presto.raptor.RaptorNodePartitioningProvider;
import com.facebook.presto.raptor.RaptorPageSinkProvider;
import com.facebook.presto.raptor.RaptorPageSourceProvider;
import com.facebook.presto.raptor.RaptorSessionProperties;
import com.facebook.presto.raptor.RaptorSplitManager;
import com.facebook.presto.raptor.RaptorTableProperties;
import com.facebook.presto.raptor.RaptorTransactionHandle;
import com.facebook.presto.raptor.metadata.ForMetadata;
import com.facebook.presto.raptor.metadata.MetadataDao;
import com.facebook.presto.raptor.util.DatabaseUtil;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.skife.jdbi.v2.IDBI;

public class RaptorConnector
implements Connector {
    private static final Logger log = Logger.get(RaptorConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final RaptorMetadataFactory metadataFactory;
    private final RaptorSplitManager splitManager;
    private final RaptorPageSourceProvider pageSourceProvider;
    private final RaptorPageSinkProvider pageSinkProvider;
    private final RaptorNodePartitioningProvider nodePartitioningProvider;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final List<PropertyMetadata<?>> tableProperties;
    private final Set<SystemTable> systemTables;
    private final MetadataDao dao;
    private final ConnectorAccessControl accessControl;
    private final boolean coordinator;
    private final Set<Procedure> procedures;
    private final ConcurrentMap<ConnectorTransactionHandle, RaptorMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, RaptorMetadata>();
    private final ScheduledExecutorService unblockMaintenanceExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"raptor-unblock-maintenance"));
    @GuardedBy(value="this")
    private final SetMultimap<Long, UUID> deletions = HashMultimap.create();

    @Inject
    public RaptorConnector(LifeCycleManager lifeCycleManager, NodeManager nodeManager, RaptorMetadataFactory metadataFactory, RaptorSplitManager splitManager, RaptorPageSourceProvider pageSourceProvider, RaptorPageSinkProvider pageSinkProvider, RaptorNodePartitioningProvider nodePartitioningProvider, RaptorSessionProperties sessionProperties, RaptorTableProperties tableProperties, Set<SystemTable> systemTables, ConnectorAccessControl accessControl, @ForMetadata IDBI dbi, Set<Procedure> procedures) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null").getSessionProperties();
        this.tableProperties = Objects.requireNonNull(tableProperties, "tableProperties is null").getTableProperties();
        this.systemTables = Objects.requireNonNull(systemTables, "systemTables is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.dao = DatabaseUtil.onDemandDao(dbi, MetadataDao.class);
        this.coordinator = nodeManager.getCurrentNode().isCoordinator();
        this.procedures = Objects.requireNonNull(procedures, "procedures is null");
    }

    @PostConstruct
    public void start() {
        if (this.coordinator) {
            this.dao.unblockAllMaintenance();
        }
    }

    public boolean isSingleStatementWritesOnly() {
        return true;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        RaptorTransactionHandle transaction = new RaptorTransactionHandle();
        this.transactions.put(transaction, this.metadataFactory.create(tableId -> this.beginDelete(tableId, transaction.getUuid())));
        return transaction;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        Preconditions.checkArgument((this.transactions.remove(transaction) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        this.finishDelete(((RaptorTransactionHandle)transaction).getUuid());
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        RaptorMetadata metadata = (RaptorMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        this.finishDelete(((RaptorTransactionHandle)transaction).getUuid());
        metadata.rollback();
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        RaptorMetadata metadata = (RaptorMetadata)this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl;
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }

    private synchronized void beginDelete(long tableId, UUID transactionId) {
        this.dao.blockMaintenance(tableId);
        Verify.verify((boolean)this.deletions.put((Object)tableId, (Object)transactionId));
    }

    private synchronized void finishDelete(UUID transactionId) {
        this.deletions.entries().stream().filter(entry -> ((UUID)entry.getValue()).equals(transactionId)).findFirst().ifPresent(entry -> {
            long tableId = (Long)entry.getKey();
            this.deletions.remove((Object)tableId, (Object)transactionId);
            if (!this.deletions.containsKey((Object)tableId)) {
                this.unblockMaintenance(tableId);
            }
        });
    }

    private void unblockMaintenance(long tableId) {
        try {
            this.dao.unblockMaintenance(tableId);
        }
        catch (Throwable t) {
            log.warn(t, "Failed to unblock maintenance for table ID %s, will retry", new Object[]{tableId});
            this.unblockMaintenanceExecutor.schedule(() -> this.unblockMaintenance(tableId), 2L, TimeUnit.SECONDS);
        }
    }
}

