/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.backup;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.configuration.ConfigurationAwareModule;
import com.facebook.presto.raptor.RaptorConnectorId;
import com.facebook.presto.raptor.backup.BackupConfig;
import com.facebook.presto.raptor.backup.BackupService;
import com.facebook.presto.raptor.backup.BackupServiceManager;
import com.facebook.presto.raptor.backup.BackupStore;
import com.facebook.presto.raptor.backup.FileBackupModule;
import com.facebook.presto.raptor.backup.HttpBackupModule;
import com.facebook.presto.raptor.backup.ManagedBackupStore;
import com.facebook.presto.raptor.backup.TimeoutBackupStore;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.util.Providers;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

public class BackupModule
extends AbstractConfigurationAwareModule {
    private final Map<String, Module> providers;

    public BackupModule(Map<String, Module> providers) {
        this.providers = ImmutableMap.builder().put((Object)"file", (Object)new FileBackupModule()).put((Object)"http", (Object)new HttpBackupModule()).putAll(providers).build();
    }

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(BackupConfig.class);
        String provider = ((BackupConfig)this.buildConfigObject(BackupConfig.class)).getProvider();
        if (provider == null) {
            binder.bind(BackupStore.class).toProvider(Providers.of(null));
        } else {
            Module module = this.providers.get(provider);
            if (module == null) {
                binder.addError("Unknown backup provider: %s", new Object[]{provider});
            } else if (module instanceof ConfigurationAwareModule) {
                this.install((Module)((ConfigurationAwareModule)module));
            } else {
                binder.install(module);
            }
        }
        binder.bind(BackupService.class).to(BackupServiceManager.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    private static Optional<BackupStore> createBackupStore(@Nullable BackupStore store, LifeCycleManager lifeCycleManager, MBeanExporter exporter, RaptorConnectorId connectorId, BackupConfig config) throws Exception {
        if (store == null) {
            return Optional.empty();
        }
        TimeoutBackupStore proxy = new TimeoutBackupStore(store, connectorId.toString(), config.getTimeout(), config.getTimeoutThreads());
        lifeCycleManager.addInstance((Object)proxy);
        ManagedBackupStore managed = new ManagedBackupStore(proxy);
        exporter.export(ObjectNames.generatedNameOf(BackupStore.class, (String)connectorId.toString()), (Object)managed);
        return Optional.of(managed);
    }
}

