/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.backup;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.ExecutorServiceAdapter;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.backup.BackupStore;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import io.airlift.units.Duration;
import java.io.File;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;

public class TimeoutBackupStore
implements BackupStore {
    private final ExecutorService executor;
    private final BackupStore store;

    public TimeoutBackupStore(BackupStore store, String connectorId, Duration timeout, int maxThreads) {
        Objects.requireNonNull(store, "store is null");
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(timeout, "timeout is null");
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("backup-proxy-" + connectorId + "-%s")));
        this.store = TimeoutBackupStore.timeLimited(store, BackupStore.class, timeout, this.executor, maxThreads);
    }

    @PreDestroy
    public void shutdown() {
        this.executor.shutdownNow();
    }

    @Override
    public void backupShard(UUID uuid, File source) {
        try {
            this.store.backupShard(uuid, source);
        }
        catch (UncheckedTimeoutException e) {
            TimeoutBackupStore.timeoutException(uuid, "Shard backup timed out");
        }
    }

    @Override
    public void restoreShard(UUID uuid, File target) {
        try {
            this.store.restoreShard(uuid, target);
        }
        catch (UncheckedTimeoutException e) {
            TimeoutBackupStore.timeoutException(uuid, "Shard restore timed out");
        }
    }

    @Override
    public boolean deleteShard(UUID uuid) {
        try {
            return this.store.deleteShard(uuid);
        }
        catch (UncheckedTimeoutException e) {
            throw TimeoutBackupStore.timeoutException(uuid, "Shard delete timed out");
        }
    }

    @Override
    public boolean shardExists(UUID uuid) {
        try {
            return this.store.shardExists(uuid);
        }
        catch (UncheckedTimeoutException e) {
            throw TimeoutBackupStore.timeoutException(uuid, "Shard existence check timed out");
        }
    }

    private static <T> T timeLimited(T target, Class<T> clazz, Duration timeout, ExecutorService executor, int maxThreads) {
        executor = new ExecutorServiceAdapter((Executor)new BoundedExecutor((Executor)executor, maxThreads));
        SimpleTimeLimiter limiter = SimpleTimeLimiter.create((ExecutorService)executor);
        return (T)limiter.newProxy(target, clazz, timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    private static PrestoException timeoutException(UUID uuid, String message) {
        throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_TIMEOUT, message + ": " + uuid);
    }
}

