/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.filesystem;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.cache.CacheManager;
import com.facebook.presto.cache.CacheStats;
import com.facebook.presto.cache.CacheType;
import com.facebook.presto.cache.ForCachingFileSystem;
import com.facebook.presto.cache.NoOpCacheManager;
import com.facebook.presto.cache.filemerge.FileMergeCacheConfig;
import com.facebook.presto.cache.filemerge.FileMergeCacheManager;
import com.facebook.presto.raptor.filesystem.HdfsOrcDataEnvironment;
import com.facebook.presto.raptor.filesystem.HdfsStorageService;
import com.facebook.presto.raptor.filesystem.RaptorCachingHdfsConfiguration;
import com.facebook.presto.raptor.filesystem.RaptorHdfsConfig;
import com.facebook.presto.raptor.filesystem.RaptorHdfsConfiguration;
import com.facebook.presto.raptor.filesystem.RaptorHiveHdfsConfiguration;
import com.facebook.presto.raptor.storage.OrcDataEnvironment;
import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.facebook.presto.raptor.storage.StorageService;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.apache.hadoop.fs.Path;
import org.weakref.jmx.guice.ExportBinder;

public class HdfsModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(StorageManagerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(RaptorHdfsConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CacheConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(FileMergeCacheConfig.class);
        binder.bind(CacheStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(CacheStats.class).withGeneratedName();
        binder.bind(RaptorHdfsConfiguration.class).annotatedWith(ForCachingFileSystem.class).to(RaptorHiveHdfsConfiguration.class).in(Scopes.SINGLETON);
        binder.bind(RaptorHdfsConfiguration.class).to(RaptorCachingHdfsConfiguration.class).in(Scopes.SINGLETON);
        binder.bind(StorageService.class).to(HdfsStorageService.class).in(Scopes.SINGLETON);
        binder.bind(OrcDataEnvironment.class).to(HdfsOrcDataEnvironment.class).in(Scopes.SINGLETON);
    }

    @Singleton
    @Provides
    public Path createBaseLocation(StorageManagerConfig config) {
        return new Path(config.getDataDirectory());
    }

    @Singleton
    @Provides
    public CacheManager createCacheManager(CacheConfig cacheConfig, FileMergeCacheConfig fileMergeCacheConfig, CacheStats cacheStats) {
        if (cacheConfig.isCachingEnabled() && cacheConfig.getCacheType() == CacheType.FILE_MERGE) {
            return new FileMergeCacheManager(cacheConfig, fileMergeCacheConfig, cacheStats, (ExecutorService)Executors.newScheduledThreadPool(5, Threads.daemonThreadsNamed((String)"raptor-cache-flusher-%s")), (ExecutorService)Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"raptor-cache-remover-%s")), Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"hive-cache-size-calculator-%s")));
        }
        return new NoOpCacheManager();
    }
}

