/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.filesystem;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.LegacyConfig;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.fs.Path;

public class RaptorHdfsConfig {
    private HostAndPort socksProxy;
    private Duration ipcPingInterval = new Duration(10.0, TimeUnit.SECONDS);
    private Duration dfsTimeout = new Duration(60.0, TimeUnit.SECONDS);
    private Duration dfsConnectTimeout = new Duration(500.0, TimeUnit.MILLISECONDS);
    private int dfsConnectMaxRetries = 5;
    private String domainSocketPath;
    private List<String> resourceConfigFiles = ImmutableList.of();
    private DataSize textMaxLineLength = new DataSize(100.0, DataSize.Unit.MEGABYTE);
    private boolean hdfsWireEncryptionEnabled;
    private int fileSystemMaxCacheSize = 1000;
    private Path hdfsPath;

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="hive.thrift.client.socks-proxy")
    public RaptorHdfsConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    @NotNull
    public List<String> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Config(value="hive.config.resources")
    public RaptorHdfsConfig setResourceConfigFiles(String files) {
        this.resourceConfigFiles = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)files);
        return this;
    }

    public RaptorHdfsConfig setResourceConfigFiles(List<String> files) {
        this.resourceConfigFiles = ImmutableList.copyOf(files);
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getIpcPingInterval() {
        return this.ipcPingInterval;
    }

    @Config(value="hive.dfs.ipc-ping-interval")
    public RaptorHdfsConfig setIpcPingInterval(Duration pingInterval) {
        this.ipcPingInterval = pingInterval;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getDfsTimeout() {
        return this.dfsTimeout;
    }

    @Config(value="hive.dfs-timeout")
    public RaptorHdfsConfig setDfsTimeout(Duration dfsTimeout) {
        this.dfsTimeout = dfsTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getDfsConnectTimeout() {
        return this.dfsConnectTimeout;
    }

    @Config(value="hive.dfs.connect.timeout")
    public RaptorHdfsConfig setDfsConnectTimeout(Duration dfsConnectTimeout) {
        this.dfsConnectTimeout = dfsConnectTimeout;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getDfsConnectMaxRetries() {
        return this.dfsConnectMaxRetries;
    }

    @Config(value="hive.dfs.connect.max-retries")
    public RaptorHdfsConfig setDfsConnectMaxRetries(int dfsConnectMaxRetries) {
        this.dfsConnectMaxRetries = dfsConnectMaxRetries;
        return this;
    }

    public String getDomainSocketPath() {
        return this.domainSocketPath;
    }

    @Config(value="hive.dfs.domain-socket-path")
    @LegacyConfig(value={"dfs.domain-socket-path"})
    public RaptorHdfsConfig setDomainSocketPath(String domainSocketPath) {
        this.domainSocketPath = domainSocketPath;
        return this;
    }

    @MinDataSize(value="1B")
    @MaxDataSize(value="1GB")
    @NotNull
    public DataSize getTextMaxLineLength() {
        return this.textMaxLineLength;
    }

    @Config(value="hive.text.max-line-length")
    @ConfigDescription(value="Maximum line length for text files")
    public RaptorHdfsConfig setTextMaxLineLength(DataSize textMaxLineLength) {
        this.textMaxLineLength = textMaxLineLength;
        return this;
    }

    public boolean isHdfsWireEncryptionEnabled() {
        return this.hdfsWireEncryptionEnabled;
    }

    @Config(value="hive.hdfs.wire-encryption.enabled")
    @ConfigDescription(value="Should be turned on when HDFS wire encryption is enabled")
    public RaptorHdfsConfig setHdfsWireEncryptionEnabled(boolean hdfsWireEncryptionEnabled) {
        this.hdfsWireEncryptionEnabled = hdfsWireEncryptionEnabled;
        return this;
    }

    public int getFileSystemMaxCacheSize() {
        return this.fileSystemMaxCacheSize;
    }

    @Config(value="hive.fs.cache.max-size")
    @ConfigDescription(value="Hadoop FileSystem cache size")
    public RaptorHdfsConfig setFileSystemMaxCacheSize(int fileSystemMaxCacheSize) {
        this.fileSystemMaxCacheSize = fileSystemMaxCacheSize;
        return this;
    }
}

