/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage.organization;

import com.facebook.presto.raptor.storage.organization.ShardRange;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;

public class ShardIndexInfo {
    private final long tableId;
    private final OptionalInt bucketNumber;
    private final UUID shardUuid;
    private final boolean isDelta;
    private final Optional<UUID> deltaUuid;
    private final long rowCount;
    private final long uncompressedSize;
    private final Optional<ShardRange> sortRange;
    private final Optional<ShardRange> temporalRange;

    public ShardIndexInfo(long tableId, OptionalInt bucketNumber, UUID shardUuid, boolean isDelta, Optional<UUID> deltaUuid, long rowCount, long uncompressedSize, Optional<ShardRange> sortRange, Optional<ShardRange> temporalRange) {
        this.tableId = tableId;
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.shardUuid = Objects.requireNonNull(shardUuid, "shardUuid is null");
        this.isDelta = isDelta;
        this.deltaUuid = Objects.requireNonNull(deltaUuid, "Optional<deltaUuid> is null");
        this.rowCount = rowCount;
        this.uncompressedSize = uncompressedSize;
        this.sortRange = Objects.requireNonNull(sortRange, "sortRange is null");
        this.temporalRange = Objects.requireNonNull(temporalRange, "temporalRange is null");
    }

    public long getTableId() {
        return this.tableId;
    }

    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    public UUID getShardUuid() {
        return this.shardUuid;
    }

    public boolean isDelta() {
        return this.isDelta;
    }

    public Optional<UUID> getDeltaUuid() {
        return this.deltaUuid;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public Optional<ShardRange> getSortRange() {
        return this.sortRange;
    }

    public Optional<ShardRange> getTemporalRange() {
        return this.temporalRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardIndexInfo that = (ShardIndexInfo)o;
        return this.tableId == that.tableId && this.rowCount == that.rowCount && this.uncompressedSize == that.uncompressedSize && this.isDelta == that.isDelta && Objects.equals(this.deltaUuid, that.deltaUuid) && Objects.equals(this.bucketNumber, that.bucketNumber) && Objects.equals(this.shardUuid, that.shardUuid) && Objects.equals(this.sortRange, that.sortRange) && Objects.equals(this.temporalRange, that.temporalRange);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.bucketNumber, this.shardUuid, this.rowCount, this.isDelta, this.deltaUuid, this.uncompressedSize, this.sortRange, this.temporalRange);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", this.tableId).add("bucketNumber", this.bucketNumber.isPresent() ? Integer.valueOf(this.bucketNumber.getAsInt()) : null).add("shardUuid", (Object)this.shardUuid).add("isDelta", this.isDelta).add("deltaUuid", this.deltaUuid.orElse(null)).add("rowCount", this.rowCount).add("uncompressedSize", this.uncompressedSize).add("sortRange", this.sortRange.orElse(null)).add("temporalRange", this.temporalRange.orElse(null)).omitNullValues().toString();
    }
}

