/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.util;

import java.util.Objects;

public class Closer<T, X extends Exception>
implements AutoCloseable {
    private final T delegate;
    private final Cleaner<T, X> cleaner;

    public static <T, X extends Exception> Closer<T, X> closer(T delegate, Cleaner<T, X> cleaner) {
        return new Closer<T, X>(delegate, cleaner);
    }

    private Closer(T delegate, Cleaner<T, X> cleaner) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.cleaner = Objects.requireNonNull(cleaner, "cleaner is null");
    }

    public T get() {
        return this.delegate;
    }

    @Override
    public void close() throws X {
        this.cleaner.close(this.delegate);
    }

    public static interface Cleaner<T, X extends Exception> {
        public void close(T var1) throws X;
    }
}

