/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.jetty;

import com.facebook.airlift.http.client.BodyGenerator;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.api.ContentProvider;

class BodyGeneratorContentProvider
implements ContentProvider {
    private static final ByteBuffer DONE = ByteBuffer.allocate(0);
    private static final ByteBuffer EXCEPTION = ByteBuffer.allocate(0);
    private final BodyGenerator bodyGenerator;
    private final Executor executor;

    public BodyGeneratorContentProvider(BodyGenerator bodyGenerator, Executor executor) {
        this.bodyGenerator = bodyGenerator;
        this.executor = executor;
    }

    public long getLength() {
        return -1L;
    }

    public Iterator<ByteBuffer> iterator() {
        final ArrayBlockingQueue chunks = new ArrayBlockingQueue(16);
        final AtomicReference exception = new AtomicReference();
        this.executor.execute(() -> {
            BodyGeneratorOutputStream out = new BodyGeneratorOutputStream(chunks);
            try {
                this.bodyGenerator.write(out);
                out.close();
            }
            catch (Exception e) {
                exception.set(e);
                chunks.add(EXCEPTION);
            }
        });
        return new AbstractIterator<ByteBuffer>(){

            protected ByteBuffer computeNext() {
                ByteBuffer chunk;
                try {
                    chunk = (ByteBuffer)chunks.take();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted", e);
                }
                if (chunk == EXCEPTION) {
                    Throwables.throwIfUnchecked((Throwable)((Throwable)exception.get()));
                    throw new RuntimeException((Throwable)exception.get());
                }
                if (chunk == DONE) {
                    return (ByteBuffer)this.endOfData();
                }
                return chunk;
            }
        };
    }

    private static final class BodyGeneratorOutputStream
    extends OutputStream {
        private final BlockingQueue<ByteBuffer> chunks;

        private BodyGeneratorOutputStream(BlockingQueue<ByteBuffer> chunks) {
            this.chunks = chunks;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.chunks.put(ByteBuffer.wrap(new byte[]{(byte)b}));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                byte[] copy = Arrays.copyOfRange(b, off, len);
                this.chunks.put(ByteBuffer.wrap(copy));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.chunks.put(DONE);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
    }
}

