/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.dbpool;

import com.facebook.airlift.stats.TimeStat;
import io.airlift.units.Duration;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public final class ManagedDataSourceStats {
    private final TimeStat checkout = new TimeStat();
    private final TimeStat create = new TimeStat();
    private final TimeStat held = new TimeStat();
    private final AtomicLong connectionErrorCount = new AtomicLong();
    private final AtomicLong creationErrorCount = new AtomicLong();

    @Managed
    @Nested
    public TimeStat getCheckout() {
        return this.checkout;
    }

    @Managed
    @Nested
    public TimeStat getCreate() {
        return this.create;
    }

    @Managed
    @Nested
    public TimeStat getHeld() {
        return this.held;
    }

    @Managed
    public long getConnectionErrorCount() {
        return this.connectionErrorCount.get();
    }

    @Managed
    public long getCreationErrorCount() {
        return this.creationErrorCount.get();
    }

    void connectionCheckedOut(Duration elapsedTime) {
        this.checkout.add(elapsedTime);
    }

    void connectionCreated(Duration elapsedTime) {
        this.create.add(elapsedTime);
    }

    void connectionReturned(Duration elapsedTime) {
        this.held.add(elapsedTime);
    }

    void creationErrorOccurred() {
        this.creationErrorCount.incrementAndGet();
    }

    void connectionErrorOccurred() {
        this.connectionErrorCount.incrementAndGet();
    }
}

