/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.dbpool;

import com.facebook.airlift.dbpool.ManagedDataSource;
import com.facebook.airlift.dbpool.PostgreSqlDataSourceConfig;
import com.facebook.airlift.discovery.client.ServiceDescriptor;
import com.facebook.airlift.discovery.client.ServiceSelector;
import com.google.common.primitives.Ints;
import java.sql.SQLException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.sql.PooledConnection;
import org.postgresql.ds.PGConnectionPoolDataSource;

public class PostgreSqlDataSource
extends ManagedDataSource {
    private final ServiceSelector serviceSelector;
    private final int defaultFetchSize;
    private UUID currentServer;
    private PGConnectionPoolDataSource dataSource;

    public PostgreSqlDataSource(ServiceSelector serviceSelector, PostgreSqlDataSourceConfig config) {
        super(config.getMaxConnections(), config.getMaxConnectionWait());
        this.serviceSelector = Objects.requireNonNull(serviceSelector, "serviceSelector is null");
        this.defaultFetchSize = config.getDefaultFetchSize();
    }

    @Override
    protected PooledConnection createConnectionInternal() throws SQLException {
        SQLException lastException = null;
        if (this.dataSource != null) {
            try {
                return this.dataSource.getPooledConnection();
            }
            catch (SQLException e) {
                lastException = e;
            }
        }
        this.dataSource = null;
        for (ServiceDescriptor serviceDescriptor : this.serviceSelector.selectAllServices()) {
            String jdbcUrl;
            if (serviceDescriptor.getId().equals(this.currentServer) || (jdbcUrl = (String)serviceDescriptor.getProperties().get("jdbc")) == null) continue;
            try {
                PGConnectionPoolDataSource dataSource = new PGConnectionPoolDataSource();
                dataSource.setUrl(jdbcUrl);
                dataSource.setDefaultRowFetchSize(this.defaultFetchSize);
                int timeout = Ints.saturatedCast((long)TimeUnit.MILLISECONDS.toSeconds(this.getMaxConnectionWaitMillis()));
                dataSource.setConnectTimeout(timeout);
                dataSource.setLoginTimeout(timeout);
                dataSource.setSocketTimeout(timeout);
                PooledConnection connection = dataSource.getPooledConnection();
                this.dataSource = dataSource;
                this.currentServer = serviceDescriptor.getId();
                return connection;
            }
            catch (SQLException e) {
                lastException = e;
            }
        }
        this.currentServer = null;
        if (lastException != null) {
            throw lastException;
        }
        throw new SQLException(String.format("No PostgreSQL servers of type '%s' available in pool '%s'", this.serviceSelector.getType(), this.serviceSelector.getPool()));
    }
}

