/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.google.common.hash.Hashing;
import io.airlift.units.DataSize;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;

public class CacheQuota {
    public static final CacheQuota NO_CACHE_CONSTRAINTS = new CacheQuota("NO_IDENTITY", Optional.empty());
    private final String identity;
    private final long identifier;
    private final Optional<DataSize> quota;

    public CacheQuota(String identity, Optional<DataSize> quota) {
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.identifier = Hashing.md5().hashString((CharSequence)identity, StandardCharsets.UTF_8).asLong();
        this.quota = Objects.requireNonNull(quota, "quota is null");
    }

    public String getIdentity() {
        return this.identity;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public Optional<DataSize> getQuota() {
        return this.quota;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheQuota that = (CacheQuota)o;
        return this.identity.equals(that.identity) && this.identifier == that.identifier && Objects.equals(this.quota, that.quota);
    }

    public int hashCode() {
        return Objects.hash(this.identity, this.identifier, this.quota);
    }
}

